/**************************************************************************
**                                                                        *
**  FILE        :  malloc.h                                               *
**                                                                        *
**  DESCRIPTION :  Include file with prototypes of functions for          *
**                 memory allocation.                                     *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _MALLOC_H
#define _MALLOC_H

#ifndef _STDLIB_H

#ifdef  __cplusplus
extern "C" {
#endif  /* defined(__cplusplus) */

#ifndef _SIZE_T_DEF
typedef __size_t        size_t;
#define _SIZE_T_DEF
#endif

#ifdef  __cplusplus
#define NULL    (0)
#else   /* !defined(__cplusplus) */
#define NULL    ( 0)
#endif  /* defined(__cplusplus) */


extern  void *        calloc  ( size_t, size_t );
extern  void *        malloc  ( size_t );
extern  void *        realloc ( void *, size_t );
extern  void          free    ( void * );
extern  void *        _malloc ( size_t );
extern  void *        _realloc( void *, size_t );
extern  void          _free   ( void * );

#ifdef  __cplusplus
}
#endif  /* defined(__cplusplus) */

#endif  /* _STDLIB_H */

#endif  /* _MALLOC_H */
