/**************************************************************************
**                                                                        *
**  FILE        :  fss.h                                                  *
**                                                                        *
**  DESCRIPTION :  Definitions for file system simulation                 *
**                                                                        *
**  Copyright 1996-2005 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _FSS_H
#define _FSS_H

#ifdef  __cplusplus
extern "C" {
#endif  /* defined(__cplusplus) */


#include <io.h>

typedef enum
{
        FSS_OPEN        = 1,
        FSS_CLOSE       = 2,
        FSS_UNLINK      = 3,
        FSS_READ_SHORT  = 4,
        FSS_READ_LONG   = 5,
        FSS_WRITE_SHORT = 6,
        FSS_WRITE_LONG  = 7,
        FSS_STAT        = 8,
        FSS_LSEEK       = 9,
        FSS_GETCWD      = 10,
        FSS_CHDIR       = 11,
        FSS_ACCESS      = 12,
        FSS_RENAME      = 13
}       FSS_CALL_ID;

#ifdef FSS_MINIMAL
#define FSS_MAXBUF      16              /* enough for _fss_init() and tmpnam() */
#else
#define FSS_MAXBUF      255
#endif

typedef struct
{
        int     buff_size;
        union
        {
                int     call_id;
                int     retval;
        }       u1;
        union
        {
                int     errno;
                struct
                {
                        int     flags;
                        char    name[FSS_MAXBUF];
                }       open;
                struct
                {
                        int     fd;
                }       close;
                struct
                {
                        char    name[FSS_MAXBUF];
                }       unlink;
                union
                {
                        struct
                        {
                                int     fd;
                                long    offset;
                                int     whence;
                        }       in;
                        struct
                        {
                                int     errno;
                                long    retval;
                        }       out;
                }       lseek;
                struct
                {
                        int     fd;
                        int     count;
                        char*   buffer;
                }       read_long;
                struct
                {
                        int     fd;
                        int     count;
                        const char*     buffer;
                }       write_long;
                struct
                {
                        char*   old;
                        int     oldlen;
                        char*   new;
                        int     newlen;
                }       rename;
#ifndef FSS_MINIMAL
                union
                {
                        struct
                        {
                                int     fd;
                                int     count;
                        }       in;
                        struct
                        {
                                int     errno;
                                char    buffer[FSS_MAXBUF];
                        }       out;
                }       read_short;
                struct
                {
                        int     fd;
                        char    buffer[FSS_MAXBUF];
                }       write_short;
                union
                {
                        char    name[FSS_MAXBUF];
                        struct
                        {
                                int     errno;
                                int     st_dev;
                                int     st_mode;
                                int     st_nlink;
                                long    st_size;
                                long    st_atime;
                                long    st_mtime;
                                long    st_ctime;
                        }       out;
                }       stat;
                struct
                {
                        int     size;
                        char    path[FSS_MAXBUF];
                }       getcwd;
                struct
                {
                        char    name[FSS_MAXBUF];
                }       chdir;
                struct
                {
                        int     mode;
                        char    name[FSS_MAXBUF];
                }       access;
#endif
        }       u2;
}       FSS_BUF;

extern  FSS_BUF _fss_buffer;

extern  void    _fss_break(void);
extern  void    _fss_init(int, int);

#ifdef  __cplusplus
}
#endif  /* defined(__cplusplus) */

#endif  /* _FSS_H */
