////////////////////////////////////////////////////////////////////////////
//
//  File        :  51.lsl
//
//  Version	:  1.17
//
//  Description :  Locator control file for the 80C51 architecture
//
//  Copyright 2003 Altium BV
//


////////////////////////////////////////////////////////////////////////////
//
// Some default values
//

#ifndef __XPAGE
#  define __XPAGE 0x0
#endif
#ifndef __STACK
#  define __STACK 32
#endif
#ifndef __XHEAP
#  define __XHEAP 2k
#endif
#ifndef __PHEAP
#  define __PHEAP 2
#endif
#ifndef __VSTACK_XDATA
#  define __VSTACK_XDATA 8k
#endif
#ifndef __VSTACK_PDATA
#  define __VSTACK_PDATA 32
#endif

architecture c51
{
	endianness
	{
		big;
	}

	space data
	{
		id = 1;
		mau = 8;
		map (size=0x80, dest=space:idata);
	}
	
	space sfr
	{
		id = 2;
		mau = 8;
		map (size=0x80, src_offset=0x80, dest_offset=0x80, dest=bus:sfr_bus);
	}
	
	space idata
	{
		id = 3;
		mau = 8;
		map (size=0x100, dest=bus:idata_bus);

		
		stack "stack" 
		(
#ifdef __STACK_FIXED
			fixed,
#endif
			min_size = (__STACK) 
		);
		
		section_layout
		{
                       "__lc_bs" := "__lc_ub_stack";
#ifdef __STACKADDR
	                group (run_addr=__STACKADDR, ordered, contiguous ) select "stack";
#endif
 		}
	}
	
	space bit
	{
		id = 4;
		mau = 1;
		map (size=0x80, dest_offset=0x20, dest=space:data);
	}

	space sfrbit
	{
		id = 8;
		mau = 1;
		map (size=8, src_offset=0x80, dest_offset=0x80, dest=space:sfr);
		map (size=8, src_offset=0x88, dest_offset=0x88, dest=space:sfr);
		map (size=8, src_offset=0x90, dest_offset=0x90, dest=space:sfr);
		map (size=8, src_offset=0x98, dest_offset=0x98, dest=space:sfr);
		map (size=8, src_offset=0xA0, dest_offset=0xA0, dest=space:sfr);
		map (size=8, src_offset=0xA8, dest_offset=0xA8, dest=space:sfr);
		map (size=8, src_offset=0xB0, dest_offset=0xB0, dest=space:sfr);
		map (size=8, src_offset=0xB8, dest_offset=0xB8, dest=space:sfr);
		map (size=8, src_offset=0xC0, dest_offset=0xC0, dest=space:sfr);
		map (size=8, src_offset=0xC8, dest_offset=0xC8, dest=space:sfr);
		map (size=8, src_offset=0xD0, dest_offset=0xD0, dest=space:sfr);
		map (size=8, src_offset=0xD8, dest_offset=0xD8, dest=space:sfr);
		map (size=8, src_offset=0xE0, dest_offset=0xE0, dest=space:sfr);
		map (size=8, src_offset=0xE8, dest_offset=0xE8, dest=space:sfr);
		map (size=8, src_offset=0xF0, dest_offset=0xF0, dest=space:sfr);
		map (size=8, src_offset=0xF8, dest_offset=0xF8, dest=space:sfr);
	}

	space xdata
	{
		id = 5;
		mau = 8;
		map (size=64k, dest=bus:xdata_bus);

		stack "vstack_xdata" 
		(
#ifdef __VSTACK_FIXED
			fixed,
#endif
			min_size = (__VSTACK_XDATA) 
		);
		heap "xheap" 
		(
#ifdef __HEAP_FIXED
			fixed,
#endif
			min_size = (__XHEAP) 
		);
		section_layout
		{
#ifdef __XHEAPADDR
			group ( ordered, contiguous )
			{
				group (run_addr=__XHEAPADDR) select "xheap";
			}
#endif
                        //heap
                        "__lc_ub_heap" := "__lc_ub_xheap";
                        "__lc_ue_heap" := "__lc_ue_xheap";
		}
	}

	space pdata
	{
		id = 6;
		mau = 8;
		map (size=256, dest_offset=256*__XPAGE, dest=space:xdata);
		
		stack "vstack_pdata" 
		(
#ifdef __VSTACK_FIXED
			fixed,
#endif
			min_size = (__VSTACK_PDATA) 
		);
		heap "pheap" 
		(
#ifdef __HEAP_FIXED
			fixed,
#endif
			min_size= (__PHEAP) 
		);
	}
	
	space code
	{
		id = 7;
		mau = 8;
		map (size=64k, dest=bus:code_bus);

		copytable;

		start_address
                (
                        symbol = "__start"
                );

		section_layout
                {
                        "__lc_cp" := "__lc_ub_table";
	                group ( run_addr=[0..255], ordered, contiguous ) select "_start";
		}
	}

	space bdata
	{
		id = 9;
		mau = 8;
		map (size=0x10, src_offset=0x20, dest_offset=0x20, dest=space:data);
	}

	space bsfr
	{
		id = 10;
		mau = 8;
		map (size=1, src_offset=0x80, dest_offset=0x80, dest=space:sfr);
		map (size=1, src_offset=0x88, dest_offset=0x88, dest=space:sfr);
		map (size=1, src_offset=0x90, dest_offset=0x90, dest=space:sfr);
		map (size=1, src_offset=0x98, dest_offset=0x98, dest=space:sfr);
		map (size=1, src_offset=0xA0, dest_offset=0xA0, dest=space:sfr);
		map (size=1, src_offset=0xA8, dest_offset=0xA8, dest=space:sfr);
		map (size=1, src_offset=0xB0, dest_offset=0xB0, dest=space:sfr);
		map (size=1, src_offset=0xB8, dest_offset=0xB8, dest=space:sfr);
		map (size=1, src_offset=0xC0, dest_offset=0xC0, dest=space:sfr);
		map (size=1, src_offset=0xC8, dest_offset=0xC8, dest=space:sfr);
		map (size=1, src_offset=0xD0, dest_offset=0xD0, dest=space:sfr);
		map (size=1, src_offset=0xD8, dest_offset=0xD8, dest=space:sfr);
		map (size=1, src_offset=0xE0, dest_offset=0xE0, dest=space:sfr);
		map (size=1, src_offset=0xE8, dest_offset=0xE8, dest=space:sfr);
		map (size=1, src_offset=0xF0, dest_offset=0xF0, dest=space:sfr);
		map (size=1, src_offset=0xF8, dest_offset=0xF8, dest=space:sfr);
	}

	bus idata_bus
	{
		mau = 8;
		width = 8;
		// size = 256
	}
	
	bus xdata_bus
	{
		mau = 8;
		width = 8;
		// size = 64k
	}
	
	bus code_bus
	{
		mau = 8;
		width = 8;
		// size = 64k
	}

	bus sfr_bus
	{
		mau = 8;
		width = 8;
	}
}

////////////////////////////////////////////////////////////////////////////
//
// If no memory is defined yet use the following memory settings
//
#ifndef __MEMORY
memory iram
{
    mau = 8;
    type = ram;
    size = 256;
    map ( dest=bus:c51:idata_bus, src_offset=0x0, dest_offset=0x0, size=256 );
}
memory xram
{
    mau = 8;
    type = ram;
    size = 64k;
    map ( dest=bus:c51:xdata_bus, src_offset=0x0, dest_offset=0x0, size=64k );
}
memory xrom
{
    mau = 8;
    type = rom;
    size = 64k;
    map ( dest=bus:c51:code_bus, src_offset=0x0, dest_offset=0x0, size=64k );
}
memory sfr
{
    mau = 8;
    type = ram;
    size = 128;
    map ( dest=bus:c51:sfr_bus, src_offset=0x0, dest_offset=0x80, size=128 );
}
section_layout c51:c51:xdata {
    group (run_addr = 0x0, ordered, contiguous) reserved "no_null_ptr" (size=1);
}
#endif /* __MEMORY */
