/**************************************************************************
**                                                                        *
**  FILE        :  wmemcpy.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wmemcpy routine.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Copy n wide characters from the object pointed to by s2 to the object
 * pointed to by s1. Don't checks for memory overlapping.
 *
 * Return the value of s1.
 */
wchar_t*
wmemcpy( wchar_t* restrict s1, const wchar_t* restrict s2, size_t n )
{
        wchar_t *dst;

        for ( dst = s1; n > 0; n--, dst++, s2++ )
        {
                *dst = *s2;
        }

        return s1;
}

#endif
