/**************************************************************************
**                                                                        *
**  FILE        :  wcspbrk.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcspbrk routine.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Locate the first occurence in the wide string pointed to by s1 of any 
 * wide character from the wide string pointed to by s2.
 *
 * Return a pointer to the wide character in s1 that also occurs in s2;
 * otherwise return a null pointer.
 */
wchar_t *wcspbrk(const wchar_t *s1, const wchar_t *s2)
{
        if (s1 && s2)
        {
                for (; *s1; s1++)
                {
                        if (wcschr(s2, *s1))
                        {
                                return (wchar_t *) s1;
                        }
                }
        }

        return NULL;
}

#endif
