/**************************************************************************
**                                                                        *
**  FILE        :  wcsncpy.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for wcsncpy routine.                       *
**                 Copies not more than n wide characters of s2 to s1.    *
**                 Returns s1.                                            *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

wchar_t *wcsncpy(wchar_t * restrict s1, const wchar_t * restrict s2, size_t n)
{
        wchar_t* os1 = s1;

        for ( ; n>0 && *s2; --n )
        {
                *os1++ = *s2++;
        }

        for ( ; n-- > 0; )
        {
                *os1++ = '\0';
        }

        return s1;
}

#endif
