/**************************************************************************
**                                                                        *
**  FILE        :  time.c                                                 *
**                                                                        *
**  DESCRIPTION :  The time function determines the current calendar      *
**                 time in seconds, and stores that value in the location *
**                 pointed to by timer. It also returns this value.       *
**                 The _stime function sets the current calendar time.    *
**                 Before _stime() is called, time() will return -1 to    *
**                 indicate that the calender time is not available.      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <time.h>

static time_t _initial = (time_t)-1;    /* Not initialized */

time_t  time( time_t *timer )
{
        time_t  elapsed;
        clock_t clk;

        clk = clock();
        elapsed = _initial;
        if ( elapsed != (time_t)-1 )
        {
                elapsed += (time_t) (clk / CLOCKS_PER_SEC);
        }
        if ( timer )
        {
                *timer = elapsed;
        }
        return elapsed;
}

void    _stime( time_t *s )
{
        _initial = *s - (time_t)(clock() / CLOCKS_PER_SEC);
}
