/**************************************************************************
**                                                                        *
**  FILE        :  strcpy.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for strcpy() routine                       *
**                 Copies one string to another.                          *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <string.h>

char *
strcpy( char * restrict dst, const char * restrict src)
{
        char *org_dst   = dst;  

#if __TRADEOFF__ < 2    /* Optimize for speed */

        long            *long_dst;
        const long      *long_src;
        long            temp;

        if (!(((long)dst & 0x3) | ((long)src & 0x3)))
        {
                /* Destination and source are word-aligned
                 */
                long_dst = (long *)dst;
                long_src = (long *)src;
                temp = *long_src;

                while (!((temp - 0x01010101) & ~temp & 0x80808080))
                {
                        /* No zero-byte in source, so copy word
                         */
                        *long_dst++ = temp;
                        temp = *++long_src;
                }

                dst = (char *)long_dst;
                src = (char *)long_src;
        }

        /* Copy remaining bytes
         */
#endif
        
        while (*dst++ = *src++)
        {
                /* No action */
                ;
        }

        return org_dst;
}
