/**************************************************************************
**                                                                        *
**  FILE        :  signal.c                                               *
**                                                                        *
**  DESCRIPTION :  Install signal handler in table.                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <signal.h>

extern signalfunction *signaltable[_NSIG];
extern signalfunction *__aborthandler;

signalfunction *(signal)(int signal, signalfunction *function)
{
        signalfunction *s;
        
        if (signal <= 0 || _NSIG <= signal || function == SIG_ERR) 
                return (SIG_ERR);
                
        s = signaltable[signal], signaltable[signal] = function;

        if (signal == SIGABRT)
        {
                __aborthandler = function;
        }
        return (s);
}
