;;  setjmp.asm  ---  save environment in jmp_buf
;;
;;  FILE:               setjmp.asm
;;
;;  COPYRIGHT:          Copyright 2006-2009 Altium BV
;;
;;  DESCRIPTION:
;;
;;      The setjmp function saves its calling environment in
;;      its jmp_buf for later use by the longjmp function.
;;      If the return is from a direct invocation, the setjmp
;;      function returns zero. If the return is from a call to
;;      the longjmp, the setjmp function returns a nonzero
;;      value.
;;
;;      Buffer layout:
;;
;;      Offset          Register        Description
;;      --------------- --------------- -----------------------
;;      0x00            r16             callee saved register
;;      0x04            r17             callee saved register
;;      0x08            r18             callee saved register
;;      0x0C            r19             callee saved register
;;      0x10            r20             callee saved register
;;      0x14            r21             callee saved register
;;      0x18            r22             callee saved register
;;      0x1C            r23             callee saved register
;;      0x20            ra              setjmp() return address
;;      0x24            sp              stack pointer
;;
        
        .section .text.libc

        .global setjmp

setjmp: 
        stw     r16,0(r4)       ; save callee-saved register
        stw     r17,4(r4)
        stw     r18,8(r4)
        stw     r19,12(r4)
        stw     r20,16(r4)
        stw     r21,20(r4)
        stw     r22,24(r4)
        stw     r23,28(r4)
        stw     ra,32(r4)       ; save return address
        stw     sp,36(r4)       ; save stack pointer
        
        mov     r2,r0           ; clear the status return result
        ret

        .endsec
                
        .end
        
