/**************************************************************************
**                                                                        *
**  FILE        :  mbrlen.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for mbrlen routine.                        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Determine the number of bytes that complete the multibyte character.
 *
 * Return the of number of bytes that complete the multibyte character 
 * on success; otherwise see the mbrtowc function.
 */
size_t mbrlen(const char * restrict s, size_t n, mbstate_t * restrict ps)
{
        mbstate_t internal_state;

        INIT_MBSTATE_OBJECT(internal_state);
        
        return mbrtowc(NULL, s, n, ps != NULL ? ps : &internal_state);
}

#endif
