;;  longjmp.asm  ---  load environment from jmp_buf
;;
;;  FILE:               longjmp.asm
;;
;;  COPYRIGHT:          Copyright 2006-2009 Altium BV
;;
;;  DESCRIPTION:
;;
;;      The longjmp function restores the environment saved by
;;      the most recent invocation of the program, with the
;;      corresponding jmp_buf argument. The longjmp function
;;      cause setjmp to return "val". The longjmp function
;;      cannot cause setjmp to return the value 0. If "val"
;;      is 0, then setjmp returns 1.
;;
;;      The buffer layout is described in: setjmp.asm
        
        .section .text.libc

        .global longjmp

longjmp:
        ldw     r16,0(r4)       ; restore callee-saved register
        ldw     r17,4(r4)
        ldw     r18,8(r4)
        ldw     r19,12(r4)
        ldw     r20,16(r4)
        ldw     r21,20(r4)
        ldw     r22,24(r4)
        ldw     r23,28(r4)
        ldw     ra,32(r4)       ; restore return address
        ldw     sp,36(r4)       ; restore stack pointer
        
        cmpeq   r2,r5,r0        ; r2=1 if r5==0, r2=0 otherwise
        or      r2,r2,r5        ; r2=1 if r5==0, r2=r5 otherwise
        ret
        
        .endsec
        
        .end

