/**************************************************************************
**                                                                        *
**  FILE        :  log10.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for log10() routine                        *
**                 Computes the 'logarithm' for the given value           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <errno.h>
#include <math.h>

#if 0


#define LN10     2.302585092994045684l

static
long double
_log10_qpf( long double arg )
{
        long double     log_result;

        log_result      = log( arg );

        /*
         * Here we can't test on errno == ERANGE since errno is not reset
         * on success. Also do not reset errno here first, since that
         * is not expected behavior of a math function.
         */
        if ( log_result == -HUGE_VALL )
        {
                return log_result;
        }

        return log_result / LN10;
}

#endif

