/**************************************************************************
**                                                                        *
**  FILE        :  fseek.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for fseek() routine                        *
**                 Sets the file position indicator for the stream        *
**                 pointed by 'file' by adding the value 'offset' to      *
**                 the position indicated by whence                       *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

int fseek(FILE *fp, long offset, int whence)
{
        if (_fflush(fp) || _lseek(fileno(fp), offset, (_whence_t)whence) == -1)
        {
                return -1;
        }
        fp->_flag &= ~_IOEOF;
        return 0;
}
