/**************************************************************************
**                                                                        *
**  FILE        :  fgetpos.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for fgetpos() routine                      *
**                 Stores the current value of the file position          *
**                 indicator for the stream pointed by 'file' in the      *
**                 object pointed to by 'pos'.                            *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>

int fgetpos(FILE * restrict fp, fpos_t * restrict pos)
{
        long    t;

        t = ftell(fp);
        if (t == -1)
        {
                return -1;
        }
        *pos = t;
        return 0;
}
