/**************************************************************************
**                                                                        *
**  FILE        :  cpsignf.c                                              *
**                                                                        *
**  DESCRIPTION :  The copysignf() function.                              *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

/*****************************************************************************
|*
|* FUNCTION:           copysignf
|*
|* AVAILABILITY:       EXTERNAL
|*
|* PARAMETERS:
|*
|*     Copy the sign of the second argument into that of the first argument
|*
|* RETURN VALUE:
|*
|*     The first argument with the sign of the second argument
|*
|* DESCRIPTION:
|*
|*     IEEE-754-1985 Recommended function.
|*     Copy the sign of the second argument to the value of the first argument
|*     and return that as result.
|*
|*     No need for error handling since it can not occur in this function.
*/
#if _IEEE_754_FORMAT
#ifdef  __SINGLE_FP__
#pragma alias   copysign        = _copysign_spf
#pragma alias   copysignl       = _copysign_spf
#endif
#pragma alias   copysignf       = _copysign_spf
static
float   _copysign_spf( float f, float sign )
{
        float2long_t    u_f;
        float2long_t    u_sign;

        /* this assumes that the float internally has the *same* endianess as the long */
        u_f.f           = f;
        u_sign.f        = sign;
        u_f.l           = COPY_FLOAT_SIGN( u_sign.l, u_f.l );

        return u_f.f;
}
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
