/**************************************************************************
**                                                                        *
**  FILE        :  atan.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for atan() routine                         *
**                 Computes the 'arctangent' for the given value          *
**                 (return value in radians)                              *
**                 argument in the range [-pi/2,pi/2].                    *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifndef __SINGLE_FP__
#pragma alias   atanl   = _atan_dpf
#pragma alias   atan            = _atan_dpf


extern double _atan( double );

/*
        atan makes its argument positive and
        calls the inner routine _atan.
*/
static
double
_atan_dpf( double arg )
{
        if( arg > 0.0 )
                return( _atan( arg ) );
        else
                return( -_atan( -arg ) );
}

#endif

