/**************************************************************************
**                                                                        *
**  FILE        :  asin.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for asin() routine                         *
**                 Computes the 'arcsinus' of the given value.            *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>
#include        <errno.h>

#if 0


#define PIO2    1.570796326794896619231e0l

static
long double
_asin_qpf( long double arg )
{
        int     negative;
        long double     temp;

        negative = 0;

        if( arg < 0.0l )
        {
                arg = -arg;
                negative = 1;
        }
        
        if( arg > 1.0l )
        {
                errno = EDOM;
                return( 0.0l );
        }

        temp = sqrtl( 1.0l - arg * arg );
        if( arg > 0.7l )
                temp = PIO2 - atanl( temp / arg );
        else
                temp = atanl( arg / temp );

        if( !negative )
                return( temp );
        else
                return( -temp );
}

#endif

