/**************************************************************************
**                                                                        *
**  FILE        :  asinhg.c                                               *
**                                                                        *
**  DESCRIPTION :  The asinh() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * asinh(x)
 *
 * Edwards
 * See calc for extra sign stuff.
 */
extern  long double             asinhl(long double x)
{
        int     is_neg;
        long double     result;
        if (x == 0.0l || isinf(x))
        {
                return x;
        }
        is_neg = (x < 0.0l);
        if (is_neg)
        {
                x = -x;
        }
        result = logl(x+sqrtl(x*x+1.0l));
        if (is_neg)
        {
                result = -result;
        }
        return result;
}
