/**************************************************************************
**                                                                        *
**  FILE        :  asin.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for asin() routine                         *
**                 Computes the 'arcsinus' of the given value.            *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>
#include        <errno.h>

#ifdef __SINGLE_FP__
#pragma alias   asinl   = _asin_spf
#pragma alias   asin            = _asin_spf
#endif
#pragma alias   asinf   = _asin_spf


#define PIO2    1.570796326794896619231e0f

static
float
_asin_spf( float arg )
{
        int     negative;
        float   temp;

        negative = 0;

        if( arg < 0.0f )
        {
                arg = -arg;
                negative = 1;
        }
        
        if( arg > 1.0f )
        {
                errno = EDOM;
                return( 0.0f );
        }

        temp = sqrtf( 1.0f - arg * arg );
        if( arg > 0.7f )
                temp = PIO2 - atanf( temp / arg );
        else
                temp = atanf( arg / temp );

        if( !negative )
                return( temp );
        else
                return( -temp );
}


