/**************************************************************************
**                                                                        *
**  FILE        :  _mbchar.c                                              *
**                                                                        *
**  DESCRIPTION :  Skeletons for multibyte character functions.           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdlib.h>

#ifdef WCHAR_SUPPORT_ENABLED

int     mblen ( const char *s, size_t n )
{
        return mbtowc( (wchar_t*) 0, s, n );
}

int     mbtowc ( wchar_t * restrict pwc, const char * restrict s,
                 size_t n )
{
        wchar_t w;

        if      ( s && n > 0 )
        {
                w = (wchar_t) *s;
                if      ( pwc )
                {
                        *pwc = w;
                }
                if      ( w )
                {
                        return MB_CUR_MAX;
                }
                return 0;
        }
        return 0;
}

int     wctomb ( char *s, wchar_t wchar )
{
        if      ( s )
        {
                *s = (char) wchar;
                return MB_CUR_MAX;
        }
        return 0;
}

size_t  mbstowcs ( wchar_t * restrict pwcs, const char * restrict s,
                   size_t n )
{
        size_t  count = 0;

        while   ( count < n && mbtowc( pwcs++, s++, 1 ) )
        {
                count++;
        }
        return count;
}

size_t  wcstombs ( char * restrict s, const wchar_t * restrict pwcs,
                   size_t n )
{
        size_t  count = 0;

        while   ( ( count < n ) && wctomb( s++, *pwcs ) && ( *pwcs++ != L'\0' ) )
        {
                count++;
        }
        return count;
}

#endif
