/**************************************************************************
**                                                                        *
**  FILE        :  _io_ungetc.c                                           *
**                                                                        *
**  DESCRIPTION :  _io_getc(), _io_putc(), _io_puts(), _io_ungetc() and   *
**                 their wide character variants are wrapper functions    *
**                 which operate either on a string or call a standard    *
**                 I/O function. They are used solely by the printf/scanf *
**                 family of functions.                                   *
**                 Unless _iob.c:_iob[] is referenced, the standard I/O   *
**                 function references will turn out to be NULL pointers  *
**                 because the references are weak. This is ok because in *
**                 that case io->fp will always be NULL. Linking in       *
**                 _iob.c will automatically pull in the standard I/O     *
**                 functions.                                             *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

#pragma weak ungetc
void    _io_ungetc(int c, struct _io *io)
{
        if (io->fp)
        {
                ungetc(c, io->fp);
        }
        else if (c != EOF)
        {
                --io->ptr;
        }
}
