/**************************************************************************
**
**  FILE        :  memzero.c
**
**  DESCRIPTION :  Routine to clear a block of memory.  Used to initialize
**                 arrays that do not have constructors.
**
**  COPYRIGHT   :  Copyright 1998-2009 Altium BV
**
**************************************************************************/

#include "basics.h"
#include "runtime.h"
#pragma hdrstop

#include <tasking_config.h>
#include __TASKING_CXX_NATIVE_HEADER(cstring)

EXTERN_C void __memzero(void                    *buffer,
                        STD_NAMESPACE::size_t   size)
/*
Initialize a block of memory.
*/
{
  STD_NAMESPACE::memset(buffer, 0, size);
}  /* __memzero */
