/**************************************************************************
**
**  FILE        :  array_nodel.c
**
**  DESCRIPTION :  No-throw version of C++ operator delete[]()
**
**  COPYRIGHT   :  Copyright 1998-2009 Altium BV
**
**************************************************************************/

#include "basics.h"
#include "runtime.h"

#if ABI_CHANGES_FOR_ARRAY_NEW_AND_DELETE

void operator delete[](void                             *ptr,
                       const STD_NAMESPACE::nothrow_t&  nothrow_arg)
THROW_NOTHING()
/*
Nothrow version of array operator delete.  Just call the normal nothrow
operator delete.
*/
{
  operator delete(ptr, nothrow_arg);
}  /* operator delete[] */

#endif /* ABI_CHANGES_FOR_ARRAY_NEW_AND_DELETE */
