////////////////////////////////////////////////////////////////////////////
//
//  File        :  nios.lsl
//
//  Version     :  @(#)nios.lsl 1.23    10/06/19
//
//  Description :  Linker script file for the Nios II architecture  
//
//  Copyright 2003-2010 Altium BV
//
////////////////////////////////////////////////////////////////////////////

#ifndef __STACK
#  define __STACK       32k
#endif
#ifndef __HEAP
#  define __HEAP        32k
#endif
#ifndef __START
#  define __START       0x00000000
#endif

#define BOUNDS_GROUP_NAME       grp_bounds
#define BOUNDS_GROUP_SELECT     "bounds"

#define SDA_GROUP_NAME          sda
#define SDA_GROUP_SELECT        "(.sdata*|.sbss*)"


architecture NiosII
{
        endianness
        {
                little;
                big;
        }

        space main 
        {
                id = 1;
                mau = 8;

                map (size=4G, dest=bus:addr_bus);

                copytable
                (
                        align = 4,
                        copy_unit = 1
                );

                stack "stack" 
                (
#ifdef __STACK_FIXED
                        fixed,
#endif
                        align = 4,
                        min_size = (__STACK),
                        grows    = high_to_low
                );

                heap "heap" 
                (
#ifdef __HEAP_FIXED
                        fixed,
#endif
                        align = 4,
                        min_size = (__HEAP)
                );

                start_address
                (
                        run_addr = __START,
                        symbol = "_START"
                );

                section_layout
                {
                        // define labels for bounds begin and end as used in C library
#ifndef BOUNDS_GROUP_REDEFINED
                        group BOUNDS_GROUP_NAME (ordered, contiguous)
                        {
                                select BOUNDS_GROUP_SELECT;
                        }
#endif
                        "_lc_ub_bounds" := addressof(group:BOUNDS_GROUP_NAME);
                        "_lc_ue_bounds" := addressof(group:BOUNDS_GROUP_NAME) + sizeof(group:BOUNDS_GROUP_NAME);

                        // quasi address space (relative to address in $GP register)
                        // note: linker has a problem when this space wraps around 4G!
#ifndef SDA_GROUP_REDEFINED
#ifdef SDA_BASE
                        group SDA_GROUP_NAME (ordered, contiguous, run_addr = SDA_BASE - 32k)
#else
                        group SDA_GROUP_NAME (ordered, contiguous)
#endif
                        {
                                select SDA_GROUP_SELECT;
                        }
#endif
                        "_SDA_BASE_" = sizeof(group:SDA_GROUP_NAME) > 0 ? addressof(group:SDA_GROUP_NAME) + 32k : 0;

#ifdef __HEAPADDR
                        group ( ordered, run_addr=__HEAPADDR )
                        {
                                select "heap";
                        }
#endif
#ifdef __STACKADDR
                        group ( ordered, run_addr=__STACKADDR )
                        {
                                select "stack";
                        }
#endif
                }
        }

        bus addr_bus
        {
                mau = 8;
                width = 32;
        }
}

////////////////////////////////////////////////////////////////////////////
//
// If no memory is defined yet use the following memory settings
//
#ifndef __MEMORY

#ifndef __IROMSTART
#  define __IROMSTART   0
#endif
#ifndef __IROMSIZE
#  define __IROMSIZE    64k
#endif
#ifndef __IRAMSTART
#  define __IRAMSTART   (__IROMSTART + __IROMSIZE)
#endif
#ifndef __IRAMSIZE
#  define __IRAMSIZE    512k
#endif
#ifndef __XROMSTART
#  define __XROMSTART   (__IRAMSTART + __IRAMSIZE)
#endif
#ifndef __XROMSIZE
#  define __XROMSIZE    512k
#endif

memory irom
{
    mau = 8;
    type = rom;
    size = __IROMSIZE;
    map ( size = __IROMSIZE, dest_offset = __IROMSTART, dest = bus:NiosII:addr_bus );
}

memory iram
{
    mau = 8;
    type = ram;
    size = __IRAMSIZE;
    map ( size = __IRAMSIZE, dest_offset = __IRAMSTART, dest = bus:NiosII:addr_bus );
}

memory xrom
{
    mau = 8;
    type = rom;
    size = __XROMSIZE;
    map ( size = __XROMSIZE, dest_offset = __XROMSTART, dest = bus:NiosII:addr_bus );
}

#endif /* __MEMORY */

