--synopsys synthesis_off
----------------------------------------------------------------------------
--
-- Copyright (c) 1990, 1991, 1992 by Synopsys, Inc.  All rights reserved.
-- 
-- This source file may be used and distributed without restriction 
-- provided that this copyright statement is not removed from the file 
-- and that any derivative work contains this copyright notice.
--
--	Package name: SDF_HEADER
--
--	Purpose: This package includes the SDF header information
--	which defines the design name, the tools used to generate the
--	SDF, and other parameters used to identify the design and
--	specify its operating conditions. 
--
--	Author: DS, CRC
--
--
----------------------------------------------------------------------------
package SDF_HEADER is

	type MIN_TYP_MAX is
	record
		min, typical, max: real;
	end record;

	---------------------------------------------------------------------

	-- Version number of the SDF
	signal sdfversion: STRING(1 to 5) := "0.000";
	
	-- Design name in the SDF
	signal design_name: STRING(1 to 32) := (others => ' ');

	-- Date/Time when the SDF was generated
	signal date: STRING(1 to 32) := (others => ' ');

	-- Vendor's Name who generated the SDF
	signal vendor: STRING(1 to 32) := (others => ' ');

	-- Name of the program used to generate the SDF
	signal program: STRING(1 to 32) := (others => ' ');

	-- Version number of the program used to generate the SDF
	signal version: STRING(1 to 32) := (others => ' ');

	-- Hierarchical path name divider used in the SDF
	signal divider: STRING(1 to 1) := ".";

	-- Operating voltage of the design when the SDF was generated
	signal voltage: MIN_TYP_MAX := (0.0, 0.0, 0.0);

	-- Process operating envelope of the design when the SDF was generated
	signal process_op_env: STRING(1 to 7) := "typical";

	-- Ambiant temperature of the design when the SDF was generated
	signal temperature: MIN_TYP_MAX := (0.0, 0.0, 0.0);

	-- Number of units to represent a single unit of time scale
	signal timescale: TIME := 1 ns;

end SDF_HEADER;
--synopsys synthesis_on
