----------------------------------------------------------------------------
-- 
-- Copyright (c) 1994 by Synopsys, Inc.  All rights reserved.
-- 
-- This source file may be used and distributed without restriction 
-- provided that this copyright statement is not removed from the file 
-- and that any derivative work contains this copyright notice.
--
--	Package name: BEHAVIORAL
--
--	Purpose: This package defines the attributes associated with
--		 the Synopsys Behavioral Compiler. 
--
--	Author: RM
--
----------------------------------------------------------------------------

package BEHAVIORAL is

    -- Attribute that can be placed on for loops to preserve them as a
    -- loop instead of unrolling them.
    attribute dont_unroll : boolean;

    -- Attribute placed on a resource to indicate the variables that will
    -- be mapped onto a memory.
    attribute variables   : string;

    -- Attribute that is placed on processes to indicate how they should
    -- be synthesized. Currently, this should be either "rtl" or "behavioral".
    attribute synthesis_type : string;

    -- Attribute that is placed on resources to indicate that they
    -- should be implemented as register files during behavioral synthesis.
    attribute map_to_registerfiles : boolean;

end BEHAVIORAL;

package body BEHAVIORAL is

    -- intentionally left empty

end BEHAVIORAL;
