------------------------------------------------------------------------
--                                                                      
--                   Copyright (c) 2007 by Mentor Graphics              
--                                                                      
--  This source file is proprietary information of Mentor Graphics,Inc. 
--  It may be distributed in whole without restriction provided that    
--  this copyright statement is not removed from the file and that      
--  any derivative work contains this copyright notice.                 
--       
--      Package  : precision_attributes
--
--      Version  : 1.0
--
--      Purpose  : Definition of package precision_attributes.
--                 The purpose of this package is to declare the
--                 built-in attributes for the Precision synthesis tool.
--
------------------------------------------------------------------------
------------------------------------------------------------------------

package precision_attributes is

    -- This HDL-only attribute is used to enable an initial value on a
    -- signal (a net). The initial value is coded into the HDL and
    -- allow_init_val is set on the signal or variable that gets
    -- inferred as storage (a register).
    attribute ALLOW_INIT_VAL : boolean;

    -- This VHDL-only array_pin_number attribute makes it easier to
    -- assign pin numbers to buses.
    -- Valid values: (pin1,pin2,pin3,...,pinN)
    type exemplar_string_array is array (natural range <>, natural range <>) of character ;
    attribute ARRAY_PIN_NUMBER : exemplar_string_array ;

    -- Is used to specify a module not be compiled or optimized. Only
    -- the interface need be defined for synthesis.
    attribute BLACK_BOX : boolean;

    -- Used to specify a particular black-box input pin is a clock pin,
    -- and Precision will insert an appropriate clock buffer.
    attribute BLACK_BOX_CLOCK : boolean;

    -- This attribute specifies that a black box pin will be treated as
    -- a pad pin, and the underlying black box design already has an
    -- I/O buffer attached to this pin.
    -- Valid values: comma-seperated port list
    attribute BLACK_BOX_PAD : string;

    -- Specifies that a black box pin is driven by a tristate buffer
    -- in the underlying black box design.
    -- Valid values: comma-seperated port list
    attribute BLACK_BOX_TRI : string;

    -- Specifies that a signal (a net) in the design is to be
    -- buffered with a technology-specific buffer. 
    -- Valid values: A legal mappable buffer cell name
    attribute BUFFER_SIG : string ;
 
    -- Specifies that an instance should be mapped to the dedicated
    -- multiplier or DSP resources during synthesis.
    -- Valid values: "ON" or "OFF"
    attribute DEDICATED_MULT : string;

    -- This HDL-only attribute, when attached to net driving
    -- dedicated clock enable input of a storage element (register,
    -- memory, DSP, etc.) will preserve the clock enable function
    -- and utilize dedicated global routing resources.
    attribute DIRECT_ENABLE : boolean;

    -- This HDL-only attribute disables FSM optimization of a single
    -- state machine. The attribute can be set on any state variable,
    -- effectively blocking FSM optimizations.
    attribute DISABLE_FSM : boolean;

    -- Specifies that the Retiming algorithm can be disabled on
    -- individual registers or modules. Applies only to instances in
    -- the design, and will not propagate from a module definition to
    -- all instances of the module.
    attribute DONT_RETIME : boolean;

    -- Tells Precision Synthesis to pass the module through synthesis
    -- without optimizing or remapping.
    attribute DONT_TOUCH      : boolean;

    -- Sets the value to be associated with a drive.
    attribute DRIVE : integer;

    -- The VHDL attribute enum_encoding is used to specify the encoding
    -- of an enumerated type. The string attribute should contain the
    -- literal representation of each state in the order they appear in
    -- the type definition.
    -- Valid values: Space separated list of bit vectors
    attribute ENUM_ENCODING : string;

    -- This HDL only attribute is applicable only to DSP design
    -- elements.  It will not work when applied to non-DSP design
    -- elements. The frontend_dissolve attribute can only be used
    -- on modules or entities.
    attribute FRONTEND_DISSOLVE : boolean ;

    -- This attribute directs Precision to attempt to place FSMs into
    -- dedicated synchronous RAM structures.
    -- Valid value: "RAM"
    attribute FSM_IMPLEMENTATION : string;

    -- This attribute explicitly specifies FSM encoding during
    -- synthesis. The value of this attribute specifies the encoding
    -- style to be used for encoding the state machine.
    -- Valid values: auto, binary, onehot, twohot, random, or gray
    attribute FSM_STATE : string;

    -- Tells Precision Synthesis to maintain the hierarchy of the
    -- module.
    -- Valid values: preserve or flatten
    attribute HIERARCHY : string;

    -- Partitions are set using HDL code attributes and directives.
    -- The partition designation can be attached to either the design
    -- unit definition or an instance of a design unit.
    attribute INCR_PARTITION : boolean;

    -- Tells Precision Synthesis whether or not to map the first
    -- register in the input path to a register in the I/O boundary.
    attribute INFF : boolean;

    -- Specifies the IO standard to be used.
    -- Valid values: Dependant on target technology
    attribute IOSTANDARD : string;

    -- Allows user to disable inferencing of a RAM for a particular
    -- signal. If value of the attribute is specified as true
    -- Precision will not infer a RAM for the corresponding signal.
    attribute LOGIC_BLOCK : boolean;

    -- Specifies that a VHDL enumerated type is actually a logic
    -- type.
    -- Valid values: a string or character aggregate.
    --attribute LOGIC_TYPE_ENCODING : string;
    --attribute LOGIC_TYPE_ENCODING of my_logic : type is "01XZ";
    --attribute LOGIC_TYPE_ENCODING of my_logic : type is ('0','1','X','Z');

    -- Allows you to change the fanout limit on the specified net.
    attribute MAX_FANOUT : integer;

    -- Ment_tco is used to set clock-to-output (tco) timing on a
    -- black-box module or instance.
    -- Valid values: e.g. "clk[3]->dataout = 1.334";
    attribute MENT_TCO0 : string;
    attribute MENT_TCO1 : string;
    attribute MENT_TCO2 : string;
    attribute MENT_TCO3 : string;
    attribute MENT_TCO4 : string;
    attribute MENT_TCO5 : string;
    attribute MENT_TCO6 : string;
    attribute MENT_TCO7 : string;
    attribute MENT_TCO8 : string;
    attribute MENT_TCO9 : string;
    attribute MENT_TCO10 : string;
    -- MENT_TCO11, MENT_TCO12, etc.


    -- Ment_tpd specifies the propagation delay value on input-to-
    -- output (tpd) path of a black-box module or instance.
    -- Valid values: e.g. "dataa->dataout = 3.5"
    attribute MENT_TPD0 : string;
    attribute MENT_TPD1 : string;
    attribute MENT_TPD2 : string;
    attribute MENT_TPD3 : string;
    attribute MENT_TPD4 : string;
    attribute MENT_TPD5 : string;
    attribute MENT_TPD6 : string;
    attribute MENT_TPD7 : string;
    attribute MENT_TPD8 : string;
    attribute MENT_TPD9 : string;
    attribute MENT_TPD10 : string;
    -- MENT_TPD11, MENT_TPD12, etc.

    -- Setup time for input pin to clock pin (tsu) of a black-box
    -- module or instance is set with ment_tsu attribute.
    -- Valid values: e.g. "dataa[17:0]->clk[3:3] = 0.000"
    attribute MENT_TSU0 : string;
    attribute MENT_TSU1 : string;
    attribute MENT_TSU2 : string;
    attribute MENT_TSU3 : string;
    attribute MENT_TSU4 : string;
    attribute MENT_TSU5 : string;
    attribute MENT_TSU6 : string;
    attribute MENT_TSU7 : string;
    attribute MENT_TSU8 : string;
    attribute MENT_TSU9 : string;
    attribute MENT_TSU10 : string;
    -- MENT_TSU11, MENT_TSU12, etc.

    -- Prevents the specified signal from being buffered. Applies
    -- to internal signals only, primary design inputs, outputs,
    -- and clocks will always conform to vendor I/O pad design rules.
    attribute NOBUFF          : boolean ;

    -- Specifies that an instance should not be optimized or changed.
    attribute NOOPT           : boolean ;

    -- Prevents the placement of an I/O pad on the specified port
    -- when the design is mapped to the technology.
    attribute NOPAD : boolean;

    -- Tells Precision Synthesis whether or not to move an output
    -- register to the I/O boundary.
    attribute OUTFF : boolean;

    -- Specifies which technology-specific I/O cell to used for a
    -- specific port.
    -- Valid values: A legal mappable pad buffer cell name
    attribute PAD : string ;

    -- Assigns a specific device pin number to a specific port in
    -- the design.
    -- Valid values: Any valid pin number token
    attribute PIN_NUMBER      : string ;

    -- Preserves the specified signal and the driver in the design.
    -- Specifies that both a signal and the signal name must
    -- survive synthesis.
    attribute PRESERVE_DRIVER : boolean ;

    -- Preserves the specified signal in the design.
    attribute PRESERVE_SIGNAL : boolean ;

    -- Prevents tri-states from being mapped to MUX logic.
    -- Valid values: true or false
    attribute PRESERVE_Z : string;

    -- Marks a net or port for automatic pullup or pulldown insertion.
    attribute PULL : string;

    -- Always infer a RAM for the signal on which ram_block is
    -- specified. If value of the ram_block is specified as true, the
    -- inferred RAM instance will be mapped to a dedicated Block RAM
    -- resource. If the value of ram_block is specified as false,
    -- mapping of inferred RAM instance to a dedicated Block RAM
    -- resource will be disabled.
    attribute RAM_BLOCK : boolean;

    -- Guides Precision to map an inferred RAM structure into the target
    -- technology's block RAM resource type. If the target technology
    -- doesn't support block RAM, then the structure will be mapped into
    -- distributed RAM or logic. See the appropriate Vendor chapter in
    -- the Precision Synthesis Reference Manual for additional
    -- information on mapping to memory resources.
    attribute RAM_BLOCK_TYPE : string; 

    -- Tells Precision Synthesis to enable or disable resource sharing
    -- for the specified module and all of its instances. By default,
    -- resource sharing is enabled.
    attribute RESOURCE_SHARING : boolean;

    -- Guides Precision to map an inferred ROM structure and transform
    -- it into the target technology's block RAM resource. If the target
    -- technology doesn't support block RAM, then the structure will be
    -- mapped into distributed RAM or logic.
    attribute ROM_BLOCK : boolean; 

    -- Specifies that the Finite State Machine should be built as a
    -- safe FSM.
    attribute SAFE_FSM: boolean;

    -- Specifies the slew value.
    -- Valid values: Dependant on target technology
    attribute SLEW : string;

    -- Used to override the definition of a function body (inside
    -- user defined packages or elsewhere) and map it to the specified
    -- function (technology cell).
    attribute SYNTHESIS_RETURN : string ;

    -- Tells Precision Synthesis whether or not to move an output
    -- enable register to the I/O boundary.
    attribute TRIFF : boolean;

    -- Specifies an explicit bit pattern encoding for each value
    -- in an enumerated type.
    -- Valid values: e.g. ("000","100","011")
    attribute TYPE_ENCODING : exemplar_string_array ;

    -- This VHDL only attribute specifies the style of encoding
    -- for a Finite State Machine.
    type encoding_style is (BINARY, ONEHOT, TWOHOT, GRAY, RANDOM) ;
    attribute TYPE_ENCODING_STYLE : encoding_style ;

    -- If set to FALSE, Precision will not map DFFs to DFFs with
    -- enables, instead Precision will dissolve the clock enable for
    -- the flip-flop. By default Precision will map to clock enable DFFs.
    attribute USE_DFFENABLE : boolean;

    -- Tells the implementation tools to assign the specified signal
    -- to a low skew route line.
    attribute USELOWSKEWLINES : boolean;

    -- Controls operator mapping of technology specific resources
    -- (cells) during design optimization.
    -- Valid values: Dependant on target technology
    attribute USE_RESOURCE : string;

    -- Applied to black-box instances to set the EDIF netlist
    -- viewname appearing in the top-level EDIF netlist.
    attribute VIEWNAME : string;

    ---------------------------
    -- Actel-only attributes --
    ---------------------------

    -- Creates a radiation hardened implementation.
    -- Valid values: CC, TMR, TMR_CC
    attribute RADHARDMETHOD : string;

    ----------------------------
    -- Altera-only attributes --
    ----------------------------

    -- Controls the mapping of multiply-accumulate logic to
    -- Altera DSP blocks.
    attribute EXTRACT_MAC : boolean;

    -----------------------------
    -- Lattice-only attributes --
    -----------------------------

    -- The value of this attribute to true results in a mapping
    -- solution without carry-chain resources. Using the default
    -- value of false creates a mapping solution using carry-chain
    -- resources. 
    -- Supported only for ispXPLD 5000MX devices.
    attribute LATTICE_NOMAP_CARRY_CHAIN : boolean;

    ----------------------------
    -- Xilinx-only attributes --
    ----------------------------

    -- Allows you to specify an asynchronous register. 
    -- This attribute is used in Xilinx to flag flip-flops 
    -- as clock domain-crossing flops for gate-level simulation.
    -- Valid values: TRUE or FALSE
    attribute ASYNC_REG : string;

    -- Always infer a RAM for the signal on which the attribute
    -- is specified. If value of the attribute is specified as
    -- true inferred RAM instance will be mapped to a dedicated
    -- Block RAM resource. If value of the attribute is specified
    -- as false mapping of inferred RAM instance to a dedicated
    -- Block RAM resource will be disabled.
    attribute BLOCK_RAM : boolean; 

    -- Allows you to map synchronous ROM to block RAM in Xilinx
    -- technologies.
    attribute BLOCK_ROM : boolean;

    -- Specifies that the placement of the register is to be
    -- forced into the IO block.
    -- Valid values: TRUE or FALSE
    attribute IOB : string;

end precision_attributes;
