--------------------------------------------------------------------
--
--
-- PACKAGE : VHDL ASSERTIONS LIBRARY
-- FILE    : ASSERT_LOGIC.VHDL
-- REVISION: 1.00 (27.03.2006)
-- 
-- (c) 2006 Aldec, Inc.
--
--
--------------------------------------------------------------------


--------------------------------------------------------------------
--                   PACKAGE BODY ASSERT_LOGIC                    --
--------------------------------------------------------------------
package body assert_logic is
	
	----------------------------------------------------------------
    	
	FUNCTION cast2stdulogic( s: std_logic ) RETURN std_ulogic IS
	BEGIN
		RETURN s;	
	END;
	
	----------------------------------------------------------------
  	
	FUNCTION cast2stdulogic( s: boolean ) RETURN std_ulogic IS
	BEGIN
		CASE s IS
                WHEN true => RETURN '1';
                WHEN false => RETURN '0';
            END CASE;
	END;
	
	----------------------------------------------------------------
    
  	FUNCTION cast2stdulogic ( s : bit  ) RETURN std_ulogic IS
    	BEGIN
	    CASE s IS
                WHEN '0' => RETURN '0';
                WHEN '1' => RETURN '1';
            END CASE;
	END;

	---------------------------------------------------------------------
	
	FUNCTION cast2stdulogic ( s : bit_vector ) RETURN std_ulogic IS 	 
	    VARIABLE zero : bit_vector( s'LENGTH-1 DOWNTO 0 ) :=(others=>'0');
	    BEGIN
		if (s = zero) then 
			return '0';
		else 
			return '1';
		end if;
	END;

	---------------------------------------------------------------------

	FUNCTION cast2stdulogic ( s : std_logic_vector ) RETURN std_ulogic IS
	    ALIAS sv : std_logic_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
	    VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return '1';
			end if;
             
	    end loop;		
	
		return '0';
		
	END;					
	
	--------------------------------------------------------------------

  	FUNCTION cast2stdulogic(s: integer) RETURN std_ulogic is
 	BEGIN
		if (s = 0) then 
			return '0';
		else 
			return '1';
		end if;
	END;

	----------------------------------------------------------------------
	
	FUNCTION cast2stdulogic(s: real) RETURN std_ulogic is
	BEGIN
		if (s = 0.0) then 
			return '0';
		else 
			return '1';
		end if;
	END;	
	
	----------------------------------------------------------------
	

	FUNCTION cast2stdulogic(s: aldec_internal_integer) RETURN std_ulogic is
	 	BEGIN
			if (s = 0) then 
				return '0';
			else 
				return '1';
			end if;
	END;
        
       	----------------------------------------------------------------
        
   	FUNCTION cast2stdulogic ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN std_ulogic IS
	ALIAS sv : IEEE.std_logic_arith.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return '1';
			end if;
             
	    end loop;		
	
		return '0';
	END;
		
	----------------------------------------------------------------
	
	FUNCTION cast2stdulogic ( s : ieee.numeric_std.UNSIGNED ) RETURN std_ulogic IS
	ALIAS sv : ieee.numeric_std.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return '1';
			end if;
             
	    end loop;		
	
		return '0';
	END;
        
	
    ----------------------------------------------------------------
	        
    FUNCTION cast2stdulogic ( s : IEEE.std_logic_arith.SIGNED ) RETURN std_ulogic IS
	ALIAS sv : IEEE.std_logic_arith.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return '1';
			end if;
             
	    end loop;		
	
		return '0';
	END;
		
	----------------------------------------------------------------
	
	FUNCTION cast2stdulogic ( s : ieee.numeric_std.SIGNED ) RETURN std_ulogic IS
	ALIAS sv : ieee.numeric_std.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return '1';
			end if;
             
	    end loop;		
	
		return '0';
	END;
        
	
	----------------------------------------------------------------
        
      
	FUNCTION cast2logic ( s : std_ulogic ) RETURN boolean is
	BEGIN
		if (s = '1' or s = 'H') then 
			return true;
		else 
			return false;
		end if;	
	END;
	
	----------------------------------------------------------------	
	
	FUNCTION cast2logic ( s: boolean ) RETURN boolean is
	BEGIN
		return s;
	END;
	
	----------------------------------------------------------------	
	
	FUNCTION cast2logic ( s : bit ) RETURN boolean is				
	BEGIN			 
		CASE s IS
                WHEN '0' => RETURN false;
                WHEN '1' => RETURN true;
        END CASE;
	END;
	
	----------------------------------------------------------------	
	
	FUNCTION cast2logic ( s : bit_vector  ) RETURN boolean is	 	
	VARIABLE zero : bit_vector( s'LENGTH-1 DOWNTO 0 ) :=(others=>'0');
 	   BEGIN
		if (s = zero) then 
			return false;
		else 
			return true;
		end if;
	
	END;
	
	----------------------------------------------------------------	

        FUNCTION cast2logic ( s : std_logic_vector ) RETURN boolean IS
	    ALIAS sv : std_logic_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
	    VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return true;
			end if;
             
	    end loop;		
	
		return false;
		
	END;	
	
	----------------------------------------------------------------	
	
  	FUNCTION cast2logic ( s : integer    ) RETURN boolean is	  
	BEGIN
		if (s = 0) then 
			return false;
		else 
			return true;
		end if;
	END;
	
	----------------------------------------------------------------	
	  
	FUNCTION cast2logic ( s : real    ) RETURN boolean is	  
	BEGIN
		if (s = 0.0) then 
			return false;
		else 
			return true;
		end if;
	END;
	
	----------------------------------------------------------------	
	
  	FUNCTION cast2logic ( s : aldec_internal_integer ) RETURN boolean is	  
	BEGIN
		if (s = 0) then 
			return false;
		else 
			return true;
		end if;
	END;


	----------------------------------------------------------------	

        FUNCTION cast2logic ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN boolean IS
	    ALIAS sv : IEEE.std_logic_arith.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	    VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return true;
			end if;
             
	    end loop;		
	
		return false;
		
	END;	
	
	----------------------------------------------------------------	

        FUNCTION cast2logic ( s : ieee.numeric_std.UNSIGNED ) RETURN boolean IS
	    ALIAS sv : ieee.numeric_std.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	    VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return true;
			end if;
             
	    end loop;		
	
		return false;
		
	END;	
	
	----------------------------------------------------------------	

        FUNCTION cast2logic ( s : IEEE.std_logic_arith.SIGNED ) RETURN boolean IS
	    ALIAS sv : IEEE.std_logic_arith.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	    VARIABLE result : integer:=0;
	BEGIN

        for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return true;
			end if;
             
	    end loop;		
	
		return false;
		
	END;	
	
	----------------------------------------------------------------	

        FUNCTION cast2logic ( s : ieee.numeric_std.SIGNED ) RETURN boolean IS
	    ALIAS sv : ieee.numeric_std.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	    VARIABLE result : integer:=0;
	BEGIN

	    for i in sv'RANGE loop
		
			if sv(i) = '1' or sv(i) = 'H' then
				return true;
			end if;
             
	    end loop;		
	
		return false;
		
	END;	
	

	----------------------------------------------------------------	
	
	FUNCTION countones( s : std_logic ) RETURN integer IS  
	BEGIN
		if (s='1') then
			RETURN 1;	   
		else 
			RETURN 0;
		end if;	
	END;
	
	----------------------------------------------------------------   
	
	FUNCTION countones( s : bit ) RETURN integer IS  
	BEGIN
		if (s='1') then
			RETURN 1;	   
		else 
			RETURN 0;
		end if;	
	END;
  	
	---------------------------------------------------------------------
	
	FUNCTION countones ( s : bit_vector ) RETURN integer IS 	 
		ALIAS sv : bit_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
		VARIABLE result : integer:=0;
	BEGIN

		for i in sv'RANGE loop
    			CASE sv(i) IS
				WHEN '0' => result := result;
			    	WHEN '1' => result := result+1;				
			END CASE; 
		end loop;
		
	    return result;
		
	END;

	---------------------------------------------------------------------

	FUNCTION countones ( s : std_logic_vector ) RETURN integer IS
		ALIAS sv : std_logic_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
		VARIABLE result : integer:=0;
	BEGIN

		for i in sv'RANGE loop
    			CASE sv(i) IS
				WHEN 'U' => result := result;
				WHEN 'X' => result := result; 
				WHEN '0' => result := result;
				WHEN '1' => result := result + 1;				
				WHEN 'Z' => result := result;
				WHEN 'W' => result := result;
				WHEN 'L' => result := result;
				WHEN 'H' => result := result;				
				WHEN '-' => result := result;                
        		END CASE; 
		end loop;
		
		return result;
		
	END;					

	
	---------------------------------------------------------------------

	FUNCTION countones ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN integer IS
		ALIAS sv : IEEE.std_logic_arith.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
		VARIABLE result : integer:=0;
	BEGIN

		for i in sv'RANGE loop
    			CASE sv(i) IS
				WHEN 'U' => result := result;
				WHEN 'X' => result := result; 
				WHEN '0' => result := result;
				WHEN '1' => result := result + 1;				
				WHEN 'Z' => result := result;
				WHEN 'W' => result := result;
				WHEN 'L' => result := result;
				WHEN 'H' => result := result;				
				WHEN '-' => result := result;                
        		END CASE; 
		end loop;
		
		return result;
		
	END;					

	---------------------------------------------------------------------

	FUNCTION countones ( s : ieee.numeric_std.UNSIGNED ) RETURN integer IS
		ALIAS sv : ieee.numeric_std.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
		VARIABLE result : integer:=0;
	BEGIN

		for i in sv'RANGE loop
    			CASE sv(i) IS
				WHEN 'U' => result := result;
				WHEN 'X' => result := result; 
				WHEN '0' => result := result;
				WHEN '1' => result := result + 1;				
				WHEN 'Z' => result := result;
				WHEN 'W' => result := result;
				WHEN 'L' => result := result;
				WHEN 'H' => result := result;				
				WHEN '-' => result := result;                
        		END CASE; 
		end loop;
		
		return result;
		
	END;					

	---------------------------------------------------------------------

	FUNCTION countones ( s : IEEE.std_logic_arith.SIGNED ) RETURN integer IS
		ALIAS sv : IEEE.std_logic_arith.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
		VARIABLE result : integer:=0;
	BEGIN

		for i in sv'RANGE loop
    			CASE sv(i) IS
				WHEN 'U' => result := result;
				WHEN 'X' => result := result; 
				WHEN '0' => result := result;
				WHEN '1' => result := result + 1;				
				WHEN 'Z' => result := result;
				WHEN 'W' => result := result;
				WHEN 'L' => result := result;
				WHEN 'H' => result := result;				
				WHEN '-' => result := result;                
        		END CASE; 
		end loop;
		
		return result;
		
	END;					

	---------------------------------------------------------------------

	FUNCTION countones ( s : ieee.numeric_std.SIGNED ) RETURN integer IS
		ALIAS sv : ieee.numeric_std.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
		VARIABLE result : integer:=0;
	BEGIN

		for i in sv'RANGE loop
    			CASE sv(i) IS
				WHEN 'U' => result := result;
				WHEN 'X' => result := result; 
				WHEN '0' => result := result;
				WHEN '1' => result := result + 1;				
				WHEN 'Z' => result := result;
				WHEN 'W' => result := result;
				WHEN 'L' => result := result;
				WHEN 'H' => result := result;				
				WHEN '-' => result := result;                
        		END CASE; 
		end loop;
		
		return result;
		
	END;					
	
	
	----------------------------------------------------------------	
	
	
	
	
	FUNCTION cast2stdulogic_edge ( s: std_logic ) RETURN std_ulogic IS
	BEGIN
		RETURN s;	
	END;
	
	----------------------------------------------------------------
  	
	FUNCTION cast2stdulogic_edge ( s: boolean ) RETURN std_ulogic IS
	BEGIN
		CASE s IS
                WHEN true => RETURN '1';
                WHEN false => RETURN '0';
            END CASE;
	END;
	
	----------------------------------------------------------------
    
  	FUNCTION cast2stdulogic_edge ( s : bit ) RETURN std_ulogic IS	
    	BEGIN
	    CASE s IS
                WHEN '0' => RETURN '0';
                WHEN '1' => RETURN '1';
            END CASE;
	END;

	---------------------------------------------------------------------
	
	FUNCTION cast2stdulogic_edge ( s : bit_vector  ) RETURN std_ulogic IS	
	BEGIN
		RETURN cast2stdulogic_edge( s(s'RIGHT) );
	END;

	---------------------------------------------------------------------

	FUNCTION cast2stdulogic_edge ( s : std_logic_vector ) RETURN std_ulogic IS
	BEGIN
	    RETURN cast2stdulogic_edge( s(s'RIGHT) );		
	END;					
	
	--------------------------------------------------------------------
	
	FUNCTION cast2stdulogic_edge ( s : integer    ) RETURN std_ulogic IS  	
 	BEGIN
		if (s = 0) then 
			return '0';
		else 
			return '1';
		end if;
	END;

	----------------------------------------------------------------------
	
	FUNCTION cast2stdulogic_edge ( s : aldec_internal_integer ) RETURN std_ulogic IS	
	 	BEGIN
			if (s = 0) then 
				return '0';
			else 
				return '1';
			end if;
	END;

	---------------------------------------------------------------------

	FUNCTION cast2stdulogic_edge ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN std_ulogic IS
	BEGIN
	    RETURN cast2stdulogic_edge( s(s'RIGHT) );		
	END;					
	
	---------------------------------------------------------------------

	FUNCTION cast2stdulogic_edge ( s : ieee.numeric_std.UNSIGNED ) RETURN std_ulogic IS
	BEGIN
	    RETURN cast2stdulogic_edge( s(s'RIGHT) );		
	END;					

	---------------------------------------------------------------------

	FUNCTION cast2stdulogic_edge ( s : IEEE.std_logic_arith.SIGNED ) RETURN std_ulogic IS
	BEGIN
	    RETURN cast2stdulogic_edge( s(s'RIGHT) );		
	END;					
	
	---------------------------------------------------------------------

	FUNCTION cast2stdulogic_edge ( s : ieee.numeric_std.SIGNED ) RETURN std_ulogic IS
	BEGIN
	    RETURN cast2stdulogic_edge( s(s'RIGHT) );		
	END;					
	
	----------------------------------------------------------------------
	
	FUNCTION "not"  ( s : aldec_internal_integer ) RETURN std_ulogic IS
    	BEGIN
		if (s = 0) then 
			return '1';
		else 
			return '0';
		end if;        
    	END "not";	
	
	----------------------------------------------------------------------
	
	FUNCTION onehot( s : std_logic ) RETURN boolean IS		   
	BEGIN
		if (s='1') then
			RETURN true;	   
		else 
			RETURN false;
		end if;
	END; 
	
	----------------------------------------------------------------------

	FUNCTION onehot( s : bit ) RETURN boolean IS 
	BEGIN
		if (s='1') then
			RETURN true;	   
		else 
			RETURN false;
		end if;
	END;
	
	----------------------------------------------------------------------
	
		
	FUNCTION onehot( s : bit_vector ) RETURN boolean IS 
	ALIAS sv : bit_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if result = true then
					RETURN false;
				else
					result := true;
				end if;
			end if;
		end loop;
		
		RETURN result;
		
	END;
	
	----------------------------------------------------------------------
	
	FUNCTION onehot( s : std_logic_vector ) RETURN boolean IS
	ALIAS sv : std_logic_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if result = true then
					RETURN false;
				else
					result := true;
				end if;
			end if;
		end loop;
		
		RETURN result;
		
	END;

	----------------------------------------------------------------------
	
	FUNCTION onehot( s : IEEE.std_logic_arith.UNSIGNED ) RETURN boolean IS
	ALIAS sv : IEEE.std_logic_arith.UNSIGNED  ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if result = true then
					RETURN false;
				else
					result := true;
				end if;
			end if;
		end loop;
		
		RETURN result;
		
	END;

	----------------------------------------------------------------------
	
	FUNCTION onehot( s : ieee.numeric_std.UNSIGNED ) RETURN boolean IS
	ALIAS sv : ieee.numeric_std.UNSIGNED  ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if result = true then
					RETURN false;
				else
					result := true;
				end if;
			end if;
		end loop;
		
		RETURN result;
		
	END;
	

	----------------------------------------------------------------------
	
	FUNCTION onehot( s : IEEE.std_logic_arith.SIGNED ) RETURN boolean IS
	ALIAS sv : IEEE.std_logic_arith.SIGNED  ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if result = true then
					RETURN false;
				else
					result := true;
				end if;
			end if;
		end loop;
		
		RETURN result;
		
	END;

	----------------------------------------------------------------------
	
	FUNCTION onehot( s : ieee.numeric_std.SIGNED ) RETURN boolean IS
	ALIAS sv : ieee.numeric_std.SIGNED  ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE result : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if result = true then
					RETURN false;
				else
					result := true;
				end if;
			end if;
		end loop;
		
		RETURN result;
		
	END;
	

	----------------------------------------------------------------------
	
	
	FUNCTION onehot0( s : std_logic ) RETURN boolean IS		   
	BEGIN
		RETURN true;		
	END; 
	
	----------------------------------------------------------------------

	FUNCTION onehot0( s : bit ) RETURN boolean IS 
	BEGIN
		RETURN true;
	END;
	
	----------------------------------------------------------------------
	
		
	FUNCTION onehot0( s : bit_vector ) RETURN boolean IS 
	ALIAS sv : bit_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if b = true then
					RETURN false;
				else
					b := true;
				end if;
			end if;
		end loop;
		
		RETURN true;
		
	END;
	
	----------------------------------------------------------------------
	
	FUNCTION onehot0( s : std_logic_vector ) RETURN boolean IS
	ALIAS sv : std_logic_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if b = true then
					RETURN false;
				else
					b := true;
				end if;
			end if;
		end loop;
		
		RETURN true;
		
	END; 			

	----------------------------------------------------------------------	
	FUNCTION onehot0( s : IEEE.std_logic_arith.UNSIGNED ) RETURN boolean IS
	ALIAS sv : IEEE.std_logic_arith.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if b = true then
					RETURN false;
				else
					b := true;
				end if;
			end if;
		end loop;
		
		RETURN true;
		
	END; 			

	----------------------------------------------------------------------	
	FUNCTION onehot0( s : ieee.numeric_std.UNSIGNED ) RETURN boolean IS
	ALIAS sv : ieee.numeric_std.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if b = true then
					RETURN false;
				else
					b := true;
				end if;
			end if;
		end loop;
		
		RETURN true;
		
	END; 			

	----------------------------------------------------------------------	
	FUNCTION onehot0( s : IEEE.std_logic_arith.SIGNED ) RETURN boolean IS
	ALIAS sv : IEEE.std_logic_arith.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if b = true then
					RETURN false;
				else
					b := true;
				end if;
			end if;
		end loop;
		
		RETURN true;
		
	END; 			

	----------------------------------------------------------------------	
	FUNCTION onehot0( s : ieee.numeric_std.SIGNED ) RETURN boolean IS
	ALIAS sv : ieee.numeric_std.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			if sv(i) = '1' then
				if b = true then
					RETURN false;
				else
					b := true;
				end if;
			end if;
		end loop;
		
		RETURN true;
		
	END; 			


	----------------------------------------------------------------------
	
	
	FUNCTION isunknown( s : std_logic ) RETURN boolean IS		   
	BEGIN
		CASE s IS
                WHEN 'X' 	=> RETURN true;
                WHEN 'W' 	=> RETURN true;
				WHEN 'U' 	=> RETURN true;
				WHEN 'Z' 	=> RETURN true;
				WHEN '-' 	=> RETURN true;
				WHEN OTHERS => RETURN false;
        END CASE;		
	END; 		
	
	----------------------------------------------------------------------

	FUNCTION isunknown( s : bit ) RETURN boolean IS 
	BEGIN
		RETURN false;
	END;
	
	----------------------------------------------------------------------
	
		
	FUNCTION isunknown( s : bit_vector ) RETURN boolean IS 	
	BEGIN		
		RETURN false;		
	END;
	
	----------------------------------------------------------------------
	
	FUNCTION isunknown( s : std_logic_vector ) RETURN boolean IS
	ALIAS sv : std_logic_vector ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			CASE sv(i) IS
                WHEN 'X' 	=> RETURN true;
				WHEN 'W' 	=> RETURN true;
				WHEN 'U' 	=> RETURN true;
				WHEN 'Z' 	=> RETURN true;
				WHEN '-' 	=> RETURN true;
				WHEN OTHERS => next;
        	END CASE;			
		end loop;
		
		RETURN false;
		
	END;

	----------------------------------------------------------------------
	
	FUNCTION isunknown( s : IEEE.std_logic_arith.UNSIGNED ) RETURN boolean IS
	ALIAS sv : IEEE.std_logic_arith.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			CASE sv(i) IS
                WHEN 'X' 	=> RETURN true;
				WHEN 'W' 	=> RETURN true;
				WHEN 'U' 	=> RETURN true;
				WHEN 'Z' 	=> RETURN true;
				WHEN '-' 	=> RETURN true;
				WHEN OTHERS => next;
        	END CASE;			
		end loop;
		
		RETURN false;
		
	END;
	
	----------------------------------------------------------------------
	
	FUNCTION isunknown( s : ieee.numeric_std.UNSIGNED ) RETURN boolean IS
	ALIAS sv : ieee.numeric_std.UNSIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			CASE sv(i) IS
                WHEN 'X' 	=> RETURN true;
				WHEN 'W' 	=> RETURN true;
				WHEN 'U' 	=> RETURN true;
				WHEN 'Z' 	=> RETURN true;
				WHEN '-' 	=> RETURN true;
				WHEN OTHERS => next;
        	END CASE;			
		end loop;
		
		RETURN false;
		
	END;

	----------------------------------------------------------------------
	
	FUNCTION isunknown( s : IEEE.std_logic_arith.SIGNED ) RETURN boolean IS
	ALIAS sv : IEEE.std_logic_arith.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			CASE sv(i) IS
                WHEN 'X' 	=> RETURN true;
				WHEN 'W' 	=> RETURN true;
				WHEN 'U' 	=> RETURN true;
				WHEN 'Z' 	=> RETURN true;
				WHEN '-' 	=> RETURN true;
				WHEN OTHERS => next;
        	END CASE;			
		end loop;
		
		RETURN false;
		
	END;
	
	----------------------------------------------------------------------
	
	FUNCTION isunknown( s : ieee.numeric_std.SIGNED ) RETURN boolean IS
	ALIAS sv : ieee.numeric_std.SIGNED ( s'LENGTH-1 DOWNTO 0 ) IS s;
	VARIABLE b : boolean := false;
	BEGIN			
		
		for i in sv'RANGE loop
			CASE sv(i) IS
                WHEN 'X' 	=> RETURN true;
				WHEN 'W' 	=> RETURN true;
				WHEN 'U' 	=> RETURN true;
				WHEN 'Z' 	=> RETURN true;
				WHEN '-' 	=> RETURN true;
				WHEN OTHERS => next;
        	END CASE;			
		end loop;
		
		RETURN false;
		
	END;

	----------------------------------------------------------------------

	FUNCTION cast2integer( s: integer ) RETURN integer IS
	BEGIN
		return s;
	END;

	----------------------------------------------------------------------

	FUNCTION akernel_max( p1, p2: integer ) RETURN integer IS
	BEGIN
		IF p1 > p2 THEN
			RETURN p1;
		ELSE 
			RETURN p2;
		END IF;
	END FUNCTION akernel_max;
	
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left( p: IEEE.std_logic_arith.UNSIGNED ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left;
		
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left( p: ieee.numeric_std.UNSIGNED ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left( p: IEEE.std_logic_arith.SIGNED ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left;
		
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left( p: ieee.numeric_std.SIGNED ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left( p: std_logic_vector ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left;
		
		
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left( p: bit_vector ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right( p: IEEE.std_logic_arith.UNSIGNED ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right;
	
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right( p: ieee.numeric_std.UNSIGNED ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right( p: IEEE.std_logic_arith.SIGNED ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right;
	
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right( p: ieee.numeric_std.SIGNED ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right( p: std_logic_vector ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right;	
	   
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right( p: bit_vector ) RETURN integer IS
	BEGIN
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right;
	
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left_dbg( p: IEEE.std_logic_arith.UNSIGNED ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_left for IEEE.std_logic_arith.UNSIGNED";
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left_dbg;
		
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left_dbg( p: ieee.numeric_std.UNSIGNED ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_left for ieee.numeric_std.UNSIGNED";
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left_dbg;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left_dbg( p: IEEE.std_logic_arith.SIGNED ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_left for IEEE.std_logic_arith.SIGNED";
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left_dbg;
		
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left_dbg( p: ieee.numeric_std.SIGNED ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_left for ieee.numeric_std.SIGNED";
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left_dbg;


	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left_dbg( p: std_logic_vector ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_left for std_logic_vector";
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left_dbg;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_left_dbg( p: bit_vector ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_left for bit_vector";
		IF( p'left > p'right ) THEN
			RETURN p'left;
		ELSE
			RETURN p'right;
		END IF;
	END FUNCTION akernel_get_vect_left_dbg;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right_dbg( p: std_logic_vector ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_right for std_logic_vector";
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right_dbg;
	   
	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right_dbg( p: IEEE.std_logic_arith.UNSIGNED ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_right for IEEE.std_logic_arith.UNSIGNED";
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right_dbg;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right_dbg( p: ieee.numeric_std.UNSIGNED ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_right for ieee.numeric_std.UNSIGNED";
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right_dbg;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right_dbg( p: IEEE.std_logic_arith.SIGNED ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_right for IEEE.std_logic_arith.SIGNED";
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right_dbg;

	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right_dbg( p: ieee.numeric_std.SIGNED ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_right for ieee.numeric_std.SIGNED";
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right_dbg;


	----------------------------------------------------------------------

	FUNCTION akernel_get_vect_right_dbg( p: bit_vector ) RETURN integer IS
	BEGIN
		report "akernel_get_vect_right for bit_vector";
		IF( p'left > p'right ) THEN
			RETURN p'right;
		ELSE
			RETURN p'left;
		END IF;
	END FUNCTION akernel_get_vect_right_dbg;
	
end package body;
--------------------------------------------------------------------
--                 PACKAGE BODY ASSERT_LOGIC END                  --
--------------------------------------------------------------------


