--------------------------------------------------------------------
--
--
-- PACKAGE : VHDL ASSERTIONS LIBRARY
-- FILE    : ASSERT_LOGIC.VHDL
-- REVISION: 1.00 (27.03.2006)
-- 
-- (c) 2006 Aldec, Inc.
--
--
--------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use ieee.numeric_std.all;
library assertions;
use assertions.assert_api.all;

--------------------------------------------------------------------
--                     PACKAGE ASSERT_LOGIC                       --
--------------------------------------------------------------------
package assert_logic is
    ----------------------------------------------------------------
    
	FUNCTION cast2stdulogic ( s: std_logic ) RETURN std_ulogic;
		
	FUNCTION cast2stdulogic ( s: boolean ) RETURN std_ulogic;
	
	FUNCTION cast2stdulogic ( s : bit ) RETURN std_ulogic;	
	
	FUNCTION cast2stdulogic ( s : bit_vector  ) RETURN std_ulogic;	 	
	
	FUNCTION cast2stdulogic ( s : std_logic_vector ) RETURN std_ulogic;
	
  	FUNCTION cast2stdulogic ( s : integer    ) RETURN std_ulogic;
	  
	FUNCTION cast2stdulogic ( s : real    ) RETURN std_ulogic;	  
	
	FUNCTION cast2stdulogic ( s : aldec_internal_integer ) RETURN std_ulogic;
        
        FUNCTION cast2stdulogic ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN std_ulogic;
        
        FUNCTION cast2stdulogic ( s : ieee.numeric_std.UNSIGNED ) RETURN std_ulogic;
        
	FUNCTION cast2stdulogic ( s : IEEE.std_logic_arith.SIGNED ) RETURN std_ulogic;
        
        FUNCTION cast2stdulogic ( s : ieee.numeric_std.SIGNED ) RETURN std_ulogic;
      
	
	FUNCTION cast2logic ( s : std_ulogic ) RETURN boolean;
	
	FUNCTION cast2logic ( s: boolean ) RETURN boolean;			
	
	FUNCTION cast2logic ( s : bit ) RETURN boolean;	
	
	FUNCTION cast2logic ( s : bit_vector  ) RETURN boolean;	 	
	
	FUNCTION cast2logic ( s : std_logic_vector ) RETURN boolean;
	
  	FUNCTION cast2logic ( s : integer    ) RETURN boolean;
	  
	FUNCTION cast2logic ( s : real    ) RETURN boolean;	  
	
	FUNCTION cast2logic ( s : aldec_internal_integer ) RETURN boolean;
	
	FUNCTION cast2logic ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN boolean;
	        
	FUNCTION cast2logic ( s : ieee.numeric_std.UNSIGNED ) RETURN boolean;
	        
        FUNCTION cast2logic ( s : IEEE.std_logic_arith.SIGNED ) RETURN boolean;
	        
        FUNCTION cast2logic ( s : ieee.numeric_std.SIGNED ) RETURN boolean;
	
	
	FUNCTION countones( s : std_logic ) RETURN integer; 

	FUNCTION countones( s : bit ) RETURN integer; 
	
	FUNCTION countones( s : bit_vector ) RETURN integer; 
	
	FUNCTION countones( s : std_logic_vector ) RETURN integer; 

	FUNCTION countones ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN integer;
	        
	FUNCTION countones ( s : ieee.numeric_std.UNSIGNED ) RETURN integer;
	        
       FUNCTION countones ( s : IEEE.std_logic_arith.SIGNED ) RETURN integer;
	        
       FUNCTION countones ( s : ieee.numeric_std.SIGNED ) RETURN integer;

	
		
	FUNCTION onehot( s : std_logic ) RETURN boolean; 

	FUNCTION onehot( s : bit ) RETURN boolean; 
	
	FUNCTION onehot( s : bit_vector ) RETURN boolean; 
	
	FUNCTION onehot( s : std_logic_vector ) RETURN boolean;
	
	FUNCTION onehot ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN boolean;
	        
     	FUNCTION onehot ( s : ieee.numeric_std.UNSIGNED ) RETURN boolean;
	        
        FUNCTION onehot ( s : IEEE.std_logic_arith.SIGNED ) RETURN boolean;
	        
        FUNCTION onehot ( s : ieee.numeric_std.SIGNED ) RETURN boolean;
	
	
	
	FUNCTION onehot0( s : std_logic ) RETURN boolean; 

	FUNCTION onehot0( s : bit ) RETURN boolean; 
	
	FUNCTION onehot0( s : bit_vector ) RETURN boolean; 
	
	FUNCTION onehot0( s : std_logic_vector ) RETURN boolean;
	
     	FUNCTION onehot0 ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN boolean;
	        
     	FUNCTION onehot0 ( s : ieee.numeric_std.UNSIGNED ) RETURN boolean;
	        
        FUNCTION onehot0 ( s : IEEE.std_logic_arith.SIGNED ) RETURN boolean;
	        
        FUNCTION onehot0 ( s : ieee.numeric_std.SIGNED ) RETURN boolean;
	
	
	
	FUNCTION isunknown( s : std_logic ) RETURN boolean; 

	FUNCTION isunknown( s : bit ) RETURN boolean; 
	
	FUNCTION isunknown( s : bit_vector ) RETURN boolean; 
	
	FUNCTION isunknown( s : std_logic_vector ) RETURN boolean;
	
     	FUNCTION isunknown ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN boolean;
	        
     	FUNCTION isunknown ( s : ieee.numeric_std.UNSIGNED ) RETURN boolean;
	        
        FUNCTION isunknown ( s : IEEE.std_logic_arith.SIGNED ) RETURN boolean;
	        
        FUNCTION isunknown ( s : ieee.numeric_std.SIGNED ) RETURN boolean;
	
	
	FUNCTION cast2stdulogic_edge ( s: std_logic ) RETURN std_ulogic;
		
	FUNCTION cast2stdulogic_edge ( s: boolean ) RETURN std_ulogic;
	
	FUNCTION cast2stdulogic_edge ( s : bit ) RETURN std_ulogic;	
	
	FUNCTION cast2stdulogic_edge ( s : bit_vector  ) RETURN std_ulogic;	 	
	
	FUNCTION cast2stdulogic_edge ( s : std_logic_vector ) RETURN std_ulogic;
	
  	FUNCTION cast2stdulogic_edge ( s : integer    ) RETURN std_ulogic;	  
	
	FUNCTION cast2stdulogic_edge ( s : aldec_internal_integer ) RETURN std_ulogic;
	
     	FUNCTION cast2stdulogic_edge ( s : IEEE.std_logic_arith.UNSIGNED ) RETURN std_ulogic;
	        
     	FUNCTION cast2stdulogic_edge ( s : ieee.numeric_std.UNSIGNED ) RETURN std_ulogic;
	        
        FUNCTION cast2stdulogic_edge ( s : IEEE.std_logic_arith.SIGNED ) RETURN std_ulogic;
	        
        FUNCTION cast2stdulogic_edge ( s : ieee.numeric_std.SIGNED ) RETURN std_ulogic;
	
		
	
	FUNCTION "not"( s : aldec_internal_integer ) RETURN std_ulogic;
	
	FUNCTION cast2integer( s: integer ) RETURN integer;
	
	FUNCTION akernel_max( p1, p2 : integer ) RETURN integer;
	
	FUNCTION akernel_get_vect_left( p: std_logic_vector ) RETURN integer;
	
     	FUNCTION akernel_get_vect_left ( p : IEEE.std_logic_arith.UNSIGNED ) RETURN integer;
	        
     	FUNCTION akernel_get_vect_left ( p : ieee.numeric_std.UNSIGNED ) RETURN integer;
	        
        FUNCTION akernel_get_vect_left ( p : IEEE.std_logic_arith.SIGNED ) RETURN integer;
	        
        FUNCTION akernel_get_vect_left ( p : ieee.numeric_std.SIGNED ) RETURN integer;	
	
	FUNCTION akernel_get_vect_left( p: bit_vector ) RETURN integer;

	FUNCTION akernel_get_vect_right( p: std_logic_vector ) RETURN integer;
	
     	FUNCTION akernel_get_vect_right ( p : IEEE.std_logic_arith.UNSIGNED ) RETURN integer;
	        
     	FUNCTION akernel_get_vect_right ( p : ieee.numeric_std.UNSIGNED ) RETURN integer;
	        
        FUNCTION akernel_get_vect_right ( p : IEEE.std_logic_arith.SIGNED ) RETURN integer;
	        
        FUNCTION akernel_get_vect_right ( p : ieee.numeric_std.SIGNED ) RETURN integer;	
	
	FUNCTION akernel_get_vect_right( p: bit_vector ) RETURN integer;

	FUNCTION akernel_get_vect_left_dbg( p: std_logic_vector ) RETURN integer;
	
     	FUNCTION akernel_get_vect_left_dbg ( p : IEEE.std_logic_arith.UNSIGNED ) RETURN integer;
	        
     	FUNCTION akernel_get_vect_left_dbg ( p : ieee.numeric_std.UNSIGNED ) RETURN integer;
	        
        FUNCTION akernel_get_vect_left_dbg ( p : IEEE.std_logic_arith.SIGNED ) RETURN integer;
	        
        FUNCTION akernel_get_vect_left_dbg ( p : ieee.numeric_std.SIGNED ) RETURN integer;		
	
	FUNCTION akernel_get_vect_left_dbg( p: bit_vector ) RETURN integer;

	FUNCTION akernel_get_vect_right_dbg( p: std_logic_vector ) RETURN integer;
	
     	FUNCTION akernel_get_vect_right_dbg ( p : IEEE.std_logic_arith.UNSIGNED ) RETURN integer;
	        
     	FUNCTION akernel_get_vect_right_dbg ( p : ieee.numeric_std.UNSIGNED ) RETURN integer;
	        
        FUNCTION akernel_get_vect_right_dbg ( p : IEEE.std_logic_arith.SIGNED ) RETURN integer;
	        
        FUNCTION akernel_get_vect_right_dbg ( p : ieee.numeric_std.SIGNED ) RETURN integer;	
   
	FUNCTION akernel_get_vect_right_dbg( p: bit_vector ) RETURN integer;

    ----------------------------------------------------------------   
end package;

--------------------------------------------------------------------
--                   PACKAGE ASSERT_LOGIC END                     --
--------------------------------------------------------------------
