--------------------------------------------------------------------
--
--
-- PACKAGE : VHDL ASSERTIONS LIBRARY
-- FILE    : ASSERT_EDGE.VHDL
-- REVISION: 1.01 (26.01.2006)
-- 
-- (c) 2006 Aldec, Inc.
--
--
--------------------------------------------------------------------


--------------------------------------------------------------------
--                   PACKAGE BODY ASSERT_EDGE                     --
--------------------------------------------------------------------
package body assert_edge is

    ----------------------------------------------------------------
    ----------------------------------------------------------------


    FUNCTION is_rose( signal s: BIT ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( s'last_event = 0ns ) and ( s'last_value = '0' and s = '1' );
    END FUNCTION is_rose;

    
    ----------------------------------------------------------------

    
    FUNCTION is_rose( signal s: ova_logic_t ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( s'last_event = 0ns ) and ( s'last_value = '0' and s = '1' );
    END FUNCTION is_rose;

    
    ----------------------------------------------------------------
	
  
    FUNCTION is_rose( signal s : std_ulogic ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( ( s'last_event           = 0ns ) and 
	         ( To_X01( s )            = '1' ) and 
                 ( To_X01( s'last_value ) = '0' )     );
    END;

	
	----------------------------------------------------------------
	
	
	FUNCTION is_rose_expr( s: std_ulogic ; prev_s : std_ulogic ) RETURN BOOLEAN IS	 
	BEGIN
		RETURN ( (To_X01( prev_s ) = '0') and (To_X01( s ) = '1')  );
	END;
	
	
	
    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : BIT_VECTOR ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
        RETURN ( s(right)'last_event = 0ns ) and ( s(right)'last_value = '0' and s(right) = '1' );
    END;
	

    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : STD_LOGIC_VECTOR ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
        RETURN ( ( s(right)'last_event = 0ns ) and 
	         	 ( To_X01( s(right) ) = '1' ) and 
                 ( To_X01( s(right)'last_value ) = '0' )     );
    END;


    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : IEEE.std_logic_arith.UNSIGNED  ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
        RETURN ( ( s(right)'last_event = 0ns ) and 
	         	 ( To_X01( s(right) ) = '1' ) and 
                 ( To_X01( s(right)'last_value ) = '0' )     );
    END;

    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : ieee.numeric_std.UNSIGNED  ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
        RETURN ( ( s(right)'last_event = 0ns ) and 
	         	 ( To_X01( s(right) ) = '1' ) and 
                 ( To_X01( s(right)'last_value ) = '0' )     );
    END;


    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : IEEE.std_logic_arith.SIGNED  ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
        RETURN ( ( s(right)'last_event = 0ns ) and 
	         	 ( To_X01( s(right) ) = '1' ) and 
                 ( To_X01( s(right)'last_value ) = '0' )     );
    END;

    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : ieee.numeric_std.SIGNED  ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
        RETURN ( ( s(right)'last_event = 0ns ) and 
	         	 ( To_X01( s(right) ) = '1' ) and 
                 ( To_X01( s(right)'last_value ) = '0' )     );
    END;


    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : REAL ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( ( s'last_event           = 0ns ) and 
	         ( s /= 0.0                     ) and 
                 ( s'last_value = 0.0           )     );
    END;


    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : INTEGER ) RETURN BOOLEAN IS
        VARIABLE p, a: BIT;
    BEGIN					   
        IF ( s'last_value MOD 2 ) = 1 THEN
            p := '1';
        ELSE
            p := '0';
        END IF;		  

        IF ( s MOD 2 ) = 1 THEN
            a := '1';
        ELSE
            a := '0';
        END IF;

        RETURN ( s'last_event = 0ns AND p = '0' AND a = '1' );
    END;


    ----------------------------------------------------------------


    FUNCTION is_rose( signal s : ova_vector_t ) RETURN BOOLEAN IS
    BEGIN
		RETURN is_rose( s(0) );
    END;
    

    ----------------------------------------------------------------
    ----------------------------------------------------------------


    FUNCTION is_fell( signal s: BIT ) RETURN BOOLEAN IS
    BEGIN				
        RETURN ( s'last_event = 0ns ) and ( s'last_value = '1' and s = '0' );
    END FUNCTION is_fell;

    
    ----------------------------------------------------------------

    
    FUNCTION is_fell( signal s: ova_logic_t ) RETURN BOOLEAN IS
    BEGIN				
        RETURN ( s'last_event = 0ns ) and ( s'last_value = '1' and s = '0' );
    END FUNCTION is_fell;

    
    ----------------------------------------------------------------
	
    
    FUNCTION is_fell( signal s : std_ulogic ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( ( s'last_event           = 0ns ) and
		 ( To_X01( s )            = '0' ) and 
                 ( To_X01( s'last_value ) = '1' )     );
    END;
	
	
	----------------------------------------------------------------
	
	
	FUNCTION is_fell_expr( s: std_ulogic ; prev_s : std_ulogic ) RETURN BOOLEAN IS	 
	BEGIN
		RETURN ( (To_X01( prev_s ) = '1') and (To_X01( s ) = '0')  );
	END;
	
    
    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : BIT_VECTOR ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN        
		RETURN ( s(right)'last_event = 0ns ) and ( s(right)'last_value = '1' and s(right) = '0' );
    END;
	

    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : STD_LOGIC_VECTOR ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN        
		RETURN ( ( s(right)'last_event = 0ns ) and
				 ( To_X01( s(right) ) = '0' ) and 
                 ( To_X01( s(right)'last_value ) = '1' ) );
    END;

    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : IEEE.std_logic_arith.UNSIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN        
		RETURN ( ( s(right)'last_event = 0ns ) and
				 ( To_X01( s(right) ) = '0' ) and 
                 ( To_X01( s(right)'last_value ) = '1' ) );
    END;


    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : ieee.numeric_std.UNSIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN        
		RETURN ( ( s(right)'last_event = 0ns ) and
				 ( To_X01( s(right) ) = '0' ) and 
                 ( To_X01( s(right)'last_value ) = '1' ) );
    END;

    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : IEEE.std_logic_arith.SIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN        
		RETURN ( ( s(right)'last_event = 0ns ) and
				 ( To_X01( s(right) ) = '0' ) and 
                 ( To_X01( s(right)'last_value ) = '1' ) );
    END;


    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : ieee.numeric_std.SIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN        
		RETURN ( ( s(right)'last_event = 0ns ) and
				 ( To_X01( s(right) ) = '0' ) and 
                 ( To_X01( s(right)'last_value ) = '1' ) );
    END;

    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : REAL ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( ( s'last_event           = 0ns ) and 
	         ( s = 0.0                      ) and 
                 ( s'last_value /= 0.0          )     );
    END;


    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : INTEGER ) RETURN BOOLEAN IS
        VARIABLE p, a: BIT;
    BEGIN					   
        IF ( s'last_value MOD 2 ) = 1 THEN
            p := '1';
        ELSE
            p := '0';
        END IF;		  

        IF ( s MOD 2 ) = 1 THEN
            a := '1';
        ELSE
            a := '0';
        END IF;

        RETURN ( s'last_event = 0ns AND p = '1' AND a = '0' );
    END;


    ----------------------------------------------------------------


    FUNCTION is_fell( signal s : ova_vector_t ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_fell( s(0) );
    END;


    ----------------------------------------------------------------
    ----------------------------------------------------------------


    FUNCTION is_change( signal s: BIT ) RETURN BOOLEAN IS
    BEGIN				 
        RETURN ( s'last_event = 0ns ) and ( s'last_value /= s );
    END FUNCTION is_change;


    ----------------------------------------------------------------


    FUNCTION is_change( signal s: ova_logic_t ) RETURN BOOLEAN IS
    BEGIN				 
        RETURN ( s'last_event = 0ns ) and ( s'last_value /= s );
    END FUNCTION is_change;

    ----------------------------------------------------------------

	
    FUNCTION is_change( signal s: std_ulogic ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( ( s'last_event = 0ns ) and 
                 ( To_X01( s ) /= To_X01( s'last_value ) ) );
    END FUNCTION is_change;
	
	
	----------------------------------------------------------------
	
	
	FUNCTION is_change_expr( s: std_ulogic ; prev_s : std_ulogic ) RETURN BOOLEAN IS
	BEGIN
		RETURN ( To_X01( prev_s ) /= To_X01( s ) );	
	END;


    ----------------------------------------------------------------


    FUNCTION is_change( signal s : BIT_VECTOR ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN        
		RETURN ( s(right)'last_event = 0ns ) and ( s(right)'last_value /= s(right) );
    END;
	

    ----------------------------------------------------------------

    FUNCTION is_change( signal s : STD_LOGIC_VECTOR ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;	
    BEGIN		
		RETURN ( ( s(right)'last_event = 0ns ) and 
                 ( To_X01( s(right) ) /= To_X01( s(right)'last_value ) ) );
    END;

    ----------------------------------------------------------------
    FUNCTION is_change( signal s : IEEE.std_logic_arith.UNSIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;	
    BEGIN		
		RETURN ( ( s(right)'last_event = 0ns ) and 
                 ( To_X01( s(right) ) /= To_X01( s(right)'last_value ) ) );
    END;


    ----------------------------------------------------------------
    FUNCTION is_change( signal s : ieee.numeric_std.UNSIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;	
    BEGIN		
		RETURN ( ( s(right)'last_event = 0ns ) and 
                 ( To_X01( s(right) ) /= To_X01( s(right)'last_value ) ) );
    END;

    ----------------------------------------------------------------
    FUNCTION is_change( signal s : IEEE.std_logic_arith.SIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;	
    BEGIN		
		RETURN ( ( s(right)'last_event = 0ns ) and 
                 ( To_X01( s(right) ) /= To_X01( s(right)'last_value ) ) );
    END;


    ----------------------------------------------------------------
    FUNCTION is_change( signal s : ieee.numeric_std.SIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;	
    BEGIN		
		RETURN ( ( s(right)'last_event = 0ns ) and 
                 ( To_X01( s(right) ) /= To_X01( s(right)'last_value ) ) );
    END;



    ----------------------------------------------------------------


    FUNCTION is_change( signal s : REAL ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( ( s'last_event      = 0ns ) and 
	         ( s /= s'last_value       )     );
    END;


    ----------------------------------------------------------------


    FUNCTION is_change( signal s : INTEGER ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( ( s'last_event      = 0ns ) and 
	         ( s /= s'last_value       )     );
    END;

	
    ----------------------------------------------------------------


    FUNCTION is_change( signal s : ova_vector_t ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_change( s(0) );
    END;


    ----------------------------------------------------------------
	
	
    FUNCTION is_change( signal s : BOOLEAN ) RETURN BOOLEAN IS
    BEGIN
        RETURN ( ( s'last_event = 0ns ) and 
	         ( s /= s'last_value  )     );
    END;
	
	
    ----------------------------------------------------------------
	
	
    FUNCTION is_change( signal s1: std_ulogic; signal s2: std_ulogic ) RETURN BOOLEAN IS	  
    BEGIN
        RETURN ( s1 /= s2 );
    END;
	
	
    ----------------------------------------------------------------
    ----------------------------------------------------------------


    FUNCTION is_vchange( signal s: BIT ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_change( s );
    END FUNCTION is_vchange;


    ----------------------------------------------------------------


    FUNCTION is_vchange( signal s: ova_logic_t ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_change( s );
    END FUNCTION is_vchange;

    ----------------------------------------------------------------


    FUNCTION is_vchange( signal s: std_ulogic ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_change( s );
    END FUNCTION is_vchange;


    ----------------------------------------------------------------


    FUNCTION is_vchange( signal s : BIT_VECTOR ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
		RETURN is_change( s );
    END;


    ----------------------------------------------------------------

   FUNCTION is_vchange( signal s : STD_LOGIC_VECTOR ) RETURN BOOLEAN IS
         VARIABLE right : integer := s'RIGHT;
         VARIABLE result : integer:=0;

    BEGIN
         for i in s'RANGE loop
         right:=i;


          if (   ( s(right)'last_event = 0ns ) and ( To_X01( s(right) ) /= To_X01( s(right)'last_value ) ) )
          then result:=result+1;
          else result:=result;
          end if;
         end loop;

      case result is
      when 0 => return FALSE;
      when others => return TRUE;
         end case;

    END;


    ----------------------------------------------------------------
    FUNCTION is_vchange( signal s : IEEE.std_logic_arith.UNSIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
		RETURN is_change( s );
    END;


    ----------------------------------------------------------------
    FUNCTION is_vchange( signal s : ieee.numeric_std.UNSIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
		RETURN is_change( s );
    END;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s : IEEE.std_logic_arith.SIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
		RETURN is_change( s );
    END;


    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s : ieee.numeric_std.SIGNED ) RETURN BOOLEAN IS
	VARIABLE right : integer := s'RIGHT;
    BEGIN
		RETURN is_change( s );
    END;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s : REAL ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_change( s );
    END;

    ----------------------------------------------------------------


    FUNCTION is_vchange( signal s : INTEGER ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_change( s );
    END;


    ----------------------------------------------------------------


    FUNCTION is_vchange( signal s : ova_vector_t ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_change( s(0) );
    END;


    ----------------------------------------------------------------


    FUNCTION is_vchange( signal s : BOOLEAN ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_vchange( s );
    END;


    ----------------------------------------------------------------


    FUNCTION is_vchange( signal s1: std_ulogic; signal s2: std_ulogic ) RETURN BOOLEAN IS
    BEGIN
        RETURN is_vchange( s1, s2 );
    END;


    ----------------------------------------------------------------

end package body;
--------------------------------------------------------------------
--                 PACKAGE BODY ASSERT_EDGE END                   --
--------------------------------------------------------------------

