--------------------------------------------------------------------
--
--
-- PACKAGE : VHDL ASSERTIONS LIBRARY
-- FILE    : ASSERT_EDGE.VHDL
-- REVISION: 1.01 (26.01.2006)
-- 
-- (c) 2006 Aldec, Inc.
--
--
--------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use ieee.numeric_std.all;

library assertions;
use assertions.ova_logic.all;

--------------------------------------------------------------------
--                     PACKAGE ASSERT_EDGE                        --
--------------------------------------------------------------------
package assert_edge is

    ----------------------------------------------------------------
    ----------------------------------------------------------------
   

    FUNCTION is_rose( signal s: BIT ) RETURN BOOLEAN;

 
    ----------------------------------------------------------------


    FUNCTION is_rose( signal s: ova_logic_t ) RETURN BOOLEAN;

	
    ----------------------------------------------------------------

	
    FUNCTION is_rose( signal s: std_ulogic ) RETURN BOOLEAN;
	
	
	----------------------------------------------------------------
	
	
	FUNCTION is_rose_expr( s: std_ulogic ; prev_s : std_ulogic ) RETURN BOOLEAN;
	

    ----------------------------------------------------------------


    FUNCTION is_rose( signal s: REAL ) RETURN BOOLEAN;


    ----------------------------------------------------------------


    FUNCTION is_rose( signal s: INTEGER ) RETURN BOOLEAN;


    ----------------------------------------------------------------


    FUNCTION is_rose( signal s: BIT_VECTOR ) RETURN BOOLEAN;
	

    ----------------------------------------------------------------


    FUNCTION is_rose( signal s: STD_LOGIC_VECTOR ) RETURN BOOLEAN;
    
    ----------------------------------------------------------------

    
    FUNCTION is_rose( signal s: IEEE.std_logic_arith.UNSIGNED ) RETURN BOOLEAN;
    
    ----------------------------------------------------------------
    
    FUNCTION is_rose( signal s: ieee.numeric_std.UNSIGNED ) RETURN BOOLEAN;

    ----------------------------------------------------------------
    
    FUNCTION is_rose( signal s: IEEE.std_logic_arith.SIGNED ) RETURN BOOLEAN;
    
    ----------------------------------------------------------------
    
    FUNCTION is_rose( signal s: ieee.numeric_std.SIGNED ) RETURN BOOLEAN;


	


	
    ----------------------------------------------------------------


    FUNCTION is_rose( signal s: ova_vector_t ) RETURN BOOLEAN;
	
	
    ----------------------------------------------------------------
    ----------------------------------------------------------------


    FUNCTION is_fell( signal s: BIT ) RETURN BOOLEAN;


    ----------------------------------------------------------------


    FUNCTION is_fell( signal s: ova_logic_t ) RETURN BOOLEAN;


    ----------------------------------------------------------------

	
    FUNCTION is_fell( signal s: std_ulogic ) RETURN BOOLEAN;
	
	
	----------------------------------------------------------------
	
	
	FUNCTION is_fell_expr( s: std_ulogic ; prev_s : std_ulogic ) RETURN BOOLEAN;	 	
	

    ----------------------------------------------------------------


    FUNCTION is_fell( signal s: REAL ) RETURN BOOLEAN;


    ----------------------------------------------------------------


    FUNCTION is_fell( signal s: INTEGER ) RETURN BOOLEAN;


    ----------------------------------------------------------------


    FUNCTION is_fell( signal s: BIT_VECTOR ) RETURN BOOLEAN;
	

    ----------------------------------------------------------------


    FUNCTION is_fell( signal s: STD_LOGIC_VECTOR ) RETURN BOOLEAN;


    ----------------------------------------------------------------

    
    FUNCTION is_fell( signal s: IEEE.std_logic_arith.UNSIGNED ) RETURN BOOLEAN;
    
    ----------------------------------------------------------------
    
    FUNCTION is_fell( signal s: ieee.numeric_std.UNSIGNED ) RETURN BOOLEAN;


    ----------------------------------------------------------------

    
    FUNCTION is_fell( signal s: IEEE.std_logic_arith.SIGNED ) RETURN BOOLEAN;
    
    ----------------------------------------------------------------
    
    FUNCTION is_fell( signal s: ieee.numeric_std.SIGNED ) RETURN BOOLEAN;

    ----------------------------------------------------------------


    FUNCTION is_fell( signal s: ova_vector_t ) RETURN BOOLEAN;


    ----------------------------------------------------------------
    ----------------------------------------------------------------

    
    FUNCTION is_change( signal s: BIT ) RETURN BOOLEAN;

	
    ----------------------------------------------------------------

	
    FUNCTION is_change( signal s: ova_logic_t ) RETURN BOOLEAN;


    ----------------------------------------------------------------

	
    FUNCTION is_change( signal s: std_ulogic ) RETURN BOOLEAN;
	
	
	----------------------------------------------------------------
	
	
	FUNCTION is_change_expr( s: std_ulogic ; prev_s : std_ulogic ) RETURN BOOLEAN;


    ----------------------------------------------------------------


    FUNCTION is_change( signal s: REAL ) RETURN BOOLEAN;


    ----------------------------------------------------------------


    FUNCTION is_change( signal s: INTEGER ) RETURN BOOLEAN;


    ----------------------------------------------------------------


    FUNCTION is_change( signal s: BIT_VECTOR ) RETURN BOOLEAN;
	

    ----------------------------------------------------------------


    FUNCTION is_change( signal s: STD_LOGIC_VECTOR ) RETURN BOOLEAN;
    
    ----------------------------------------------------------------
    
        
    FUNCTION is_change( signal s: IEEE.std_logic_arith.UNSIGNED ) RETURN BOOLEAN;

    ----------------------------------------------------------------
        
    FUNCTION is_change( signal s: ieee.numeric_std.UNSIGNED ) RETURN BOOLEAN;
    
    ----------------------------------------------------------------
    
        
    FUNCTION is_change( signal s: IEEE.std_logic_arith.SIGNED ) RETURN BOOLEAN;
        
    ----------------------------------------------------------------
        
    FUNCTION is_change( signal s: ieee.numeric_std.SIGNED ) RETURN BOOLEAN;



    ----------------------------------------------------------------


    FUNCTION is_change( signal s: ova_vector_t ) RETURN BOOLEAN;


    ----------------------------------------------------------------   
	
	
    FUNCTION is_change( signal s: BOOLEAN ) RETURN BOOLEAN;
	
	
    ----------------------------------------------------------------
	
	
    FUNCTION is_change( signal s1: std_ulogic; signal s2: std_ulogic ) RETURN BOOLEAN;	  
	
	
    ----------------------------------------------------------------
    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s: BIT ) RETURN BOOLEAN;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s: ova_logic_t ) RETURN BOOLEAN;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s: std_ulogic ) RETURN BOOLEAN;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s: REAL ) RETURN BOOLEAN;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s: INTEGER ) RETURN BOOLEAN;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s: BIT_VECTOR ) RETURN BOOLEAN;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s: STD_LOGIC_VECTOR ) RETURN BOOLEAN;
    ----------------------------------------------------------------
    
    FUNCTION is_vchange( signal s: IEEE.std_logic_arith.UNSIGNED ) RETURN BOOLEAN;
        
    ----------------------------------------------------------------
        
    FUNCTION is_vchange( signal s: ieee.numeric_std.UNSIGNED ) RETURN BOOLEAN;
    
    ----------------------------------------------------------------
        
    FUNCTION is_vchange( signal s: IEEE.std_logic_arith.SIGNED ) RETURN BOOLEAN;
        
    ----------------------------------------------------------------
        
    FUNCTION is_vchange( signal s: ieee.numeric_std.SIGNED ) RETURN BOOLEAN;

    ----------------------------------------------------------------

    FUNCTION is_vchange( signal s: ova_vector_t ) RETURN BOOLEAN;

    ----------------------------------------------------------------   
	
    FUNCTION is_vchange( signal s: BOOLEAN ) RETURN BOOLEAN;
	
    ----------------------------------------------------------------
	
    FUNCTION is_vchange( signal s1: std_ulogic; signal s2: std_ulogic ) RETURN BOOLEAN;
	
    ----------------------------------------------------------------

end package;
--------------------------------------------------------------------
--                   PACKAGE ASSERT_EDGE END                      --
--------------------------------------------------------------------
