library IEEE;
use IEEE.std_logic_1164.all; 
use IEEE.std_logic_arith.all;

package Matlab is

type TDims is array(POSITIVE range <>) of integer;
type mxClassID is (
	mxLOGICAL,
	mxDOUBLE,
	mxSINGLE,
	mxINT8,
	mxUINT8,
	mxINT16,
	mxUINT16,
	mxINT32,
	mxUINT32,
	mxCHAR);

type mxCastID is (
	mxDEFAULT,
	mxSIGNED,
	mxUNSIGNED);

-- get_variable std_logic
procedure get_variable(var_name : in string; var : out std_logic);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_s";
procedure get_variable(var_name : in string; var : out std_logic_vector);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_sv";
procedure get_variable(var_name : in string; var : out std_logic_vector; cast : in mxCastID);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_svc";
procedure get_variable(var_name : in string; var : out std_logic_vector; point : in integer);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_svf";
procedure get_variable(var_name : in string; var : out std_logic_vector; point : in integer; cast : in mxCastID);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_svfc";
procedure get_variable(var_name : in string; var : out signed);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_sv";
procedure get_variable(var_name : in string; var : out signed; cast : in mxCastID);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_svc";
procedure get_variable(var_name : in string; var : out signed; point : in integer);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_svf";
procedure get_variable(var_name : in string; var : out signed; point : in integer; cast : in mxCastID);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_svfc";
procedure get_variable(var_name : in string; var : out unsigned);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_suv";
procedure get_variable(var_name : in string; var : out unsigned; cast : in mxCastID);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_suvc";
procedure get_variable(var_name : in string; var : out unsigned; point : in integer);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_suvf";
procedure get_variable(var_name : in string; var : out unsigned; point : in integer; cast : in mxCastID);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_suvfc";
-- get_variable bit
procedure get_variable(var_name : in string; var : out bit);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_b";
procedure get_variable(var_name : in string; var : out bit_vector);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_bv";
procedure get_variable(var_name : in string; var : out bit_vector; cast : in mxCastID);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_bvc";
procedure get_variable(var_name : in string; var : out bit_vector; point : in integer);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_bvf";
procedure get_variable(var_name : in string; var : out bit_vector; point : in integer; cast : in mxCastID);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_bvfc";
-- get_variable int/real
procedure get_variable(var_name : in string; var : out integer);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_i";
procedure get_variable(var_name : in string; var : out real);
attribute foreign of get_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_variable_r";

-- put_variable std_logic
procedure put_variable(var_name : in string; var : in std_logic);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_s";
procedure put_variable(var_name : in string; var : in std_logic; class : in mxClassID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_st";
procedure put_variable(var_name : in string; var : in std_logic_vector);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_sv";
procedure put_variable(var_name : in string; var : in std_logic_vector; point : in integer);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_svf";
procedure put_variable(var_name : in string; var : in std_logic_vector; point : in integer; class : in mxClassID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_svft";
procedure put_variable(var_name : in string; var : in std_logic_vector; point : in integer; cast : in mxCastID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_svfc";
procedure put_variable(var_name : in string; var : in std_logic_vector; point : in integer; class : in mxClassID; cast : in mxCastID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_svftc";
-- put_variable signed
procedure put_variable(var_name : in string; var : in signed);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_sv";
procedure put_variable(var_name : in string; var : in signed; point : in integer);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_svf";
procedure put_variable(var_name : in string; var : in signed; point : in integer; class : in mxClassID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_svft";
procedure put_variable(var_name : in string; var : in signed; point : in integer; cast : in mxCastID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_svfc";
procedure put_variable(var_name : in string; var : in signed; point : in integer; class : in mxClassID; cast : in mxCastID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_svftc";
-- put_variable unsigned
procedure put_variable(var_name : in string; var : in unsigned);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_suv";
procedure put_variable(var_name : in string; var : in unsigned; point : in integer);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_suvf";
procedure put_variable(var_name : in string; var : in unsigned; point : in integer; class : in mxClassID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_suvft";
procedure put_variable(var_name : in string; var : in unsigned; point : in integer; cast : in mxCastID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_suvfc";
procedure put_variable(var_name : in string; var : in unsigned; point : in integer; class : in mxClassID; cast : in mxCastID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_suvftc";
-- put_variable bit
procedure put_variable(var_name : in string; var : in bit);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_b";
procedure put_variable(var_name : in string; var : in bit; class : in mxClassID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_bt";
procedure put_variable(var_name : in string; var : in bit_vector);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_bv";
procedure put_variable(var_name : in string; var : in bit_vector; point : in integer);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_bvf";
procedure put_variable(var_name : in string; var : in bit_vector; point : in integer; class : in mxClassID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_bvft";
procedure put_variable(var_name : in string; var : in bit_vector; point : in integer; cast : in mxCastID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_bvfc";
procedure put_variable(var_name : in string; var : in bit_vector; point : in integer; class : in mxClassID; cast : in mxCastID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_bvftc";
-- put_variable int/real
procedure put_variable(var_name : in string; var : in integer);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_i";
procedure put_variable(var_name : in string; var : in integer; class : in mxClassID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_it";
procedure put_variable(var_name : in string; var : in real);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_r";
procedure put_variable(var_name : in string; var : in real; class : in mxClassID);
attribute foreign of put_variable: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_variable_rt";

procedure eval_string(cmd : in string);
attribute foreign of eval_string: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; eval_string";

procedure ml_setup(desktop : in boolean := true; point : in integer := 0; class : in mxClassID := mxDOUBLE; cast : in mxCastID := mxDEFAULT; path : in string := ""; port_nr : in integer := 1211);
attribute foreign of ml_setup: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; ml_setup";

procedure ml_quit;
attribute foreign of ml_quit: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; ml_quit";

procedure put_simtime(var_name : in string);
attribute foreign of put_simtime: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_simtime_r";

procedure put_simtime(var_name_t : in string; var_name_u : in string);
attribute foreign of put_simtime: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_simtime_us";

procedure put_simtime(var_name_t : in string; var_name_u : in string; class : in mxClassID := mxCHAR);
attribute foreign of put_simtime: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_simtime_ust";

---------------------------------------------------------------------------------------
--Array functions
---------------------------------------------------------------------------------------
function create_array(name : in string; ndim : in integer; dims : in TDims) return integer;
attribute foreign of create_array: function is "VHPI $ALDEC/bin/aldec_matlab_cosim; create_array";

function create_array(name : in string; ndim : in integer; dims : in TDims; class : in mxClassID) return integer;
attribute foreign of create_array: function is "VHPI $ALDEC/bin/aldec_matlab_cosim; create_array_t";

function create_array_typed(name : in string; class : in mxClassID; ndim : in integer; dims : in TDims) return integer;
attribute foreign of create_array_typed: function is "VHPI $ALDEC/bin/aldec_matlab_cosim; create_array_typed";

procedure destroy_array(array_id : in integer);
attribute foreign of destroy_array: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; destroy_array";

function get_num_dims(array_id : in integer) return integer;
attribute foreign of get_num_dims: function is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_num_dims";

function get_dim(array_id : in integer; dim_sel : in integer) return integer;
attribute foreign of get_dim: function is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_dim";

procedure hdl2ml(array_id : in integer);
attribute foreign of hdl2ml: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; hdl2ml";

function ml2hdl(name : in string) return integer;
attribute foreign of ml2hdl: function is "VHPI $ALDEC/bin/aldec_matlab_cosim; ml2hdl";	   

---------------------------------------------------------------------------------------
-- Array item transfer
---------------------------------------------------------------------------------------
--Put item
--std_logic
procedure put_item(var : in std_logic; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_s";
procedure put_item(var : in std_logic_vector; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_sv";
procedure put_item(var : in std_logic_vector; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_svc";
procedure put_item(var : in std_logic_vector; point : in integer; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_svf"; 
procedure put_item(var : in std_logic_vector; point : in integer; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_svfc"; 
--signed
procedure put_item(var : in signed; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_sv";
procedure put_item(var : in signed; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_svc";
procedure put_item(var : in signed; point : in integer; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_svf";
procedure put_item(var : in signed; point : in integer; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_svfc";
--unsigned
procedure put_item(var : in unsigned; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_suv";
procedure put_item(var : in unsigned; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_suvc";
procedure put_item(var : in unsigned; point : in integer; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_suvf";
procedure put_item(var : in unsigned; point : in integer; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_suvfc";
--bit
procedure put_item(var : in bit; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_b";
procedure put_item(var : in bit_vector; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_bv";
procedure put_item(var : in bit_vector; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_bvc";
procedure put_item(var : in bit_vector; point : in integer; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_bvf"; 
procedure put_item(var : in bit_vector; point : in integer; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_bvfc"; 
-- integer & real
procedure put_item(var : in integer; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_i";
procedure put_item(var : in real; array_id : in integer; index : in TDims);
attribute foreign of put_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; put_item_r";

--Get item
--std_logic
procedure get_item(var : out std_logic; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_s";
procedure get_item(var : out std_logic_vector; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_sv";
procedure get_item(var : out std_logic_vector; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_svc";
procedure get_item(var : out std_logic_vector; point : in integer; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_svf";
procedure get_item(var : out std_logic_vector; point : in integer; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_svfc";
--signed
procedure get_item(var : out signed; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_sv";
procedure get_item(var : out signed; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_svc";
procedure get_item(var : out signed; point : in integer; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_svf";
procedure get_item(var : out signed; point : in integer; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_svfc";
--unsigned
procedure get_item(var : out unsigned; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_suv";
procedure get_item(var : out unsigned; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_suvc";
procedure get_item(var : out unsigned; point : in integer; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_suvf";
procedure get_item(var : out unsigned; point : in integer; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_suvfc";
--bit
procedure get_item(var : out bit; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_b";
procedure get_item(var : out bit_vector; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_bv";
procedure get_item(var : out bit_vector; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_bvc";
procedure get_item(var : out bit_vector; point : in integer; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_bvf";
procedure get_item(var : out bit_vector; point : in integer; cast : in mxCastID; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_bvfc";
--integer & real
procedure get_item(var : out integer; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_i";
procedure get_item(var : out real; array_id : in integer; index : in TDims);
attribute foreign of get_item: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_item_r";

--Benchmark function
procedure get_time;
attribute foreign of get_time: procedure is "VHPI $ALDEC/bin/aldec_matlab_cosim; get_time";

end package Matlab;

