--------------------------------------------------------------------------
--                                                                      --
-- (c) 1990 Aldec, Inc. All rights reserved.                            --
--                                                                      --
-- This source file may be used and distributed without restriction     --
-- provided that this copyright statement is not removed from the file  --
-- and that any derivative work contains this copyright notice.         --
--                                                                      --
--    Package name: VNVHDL                                              --
--                                                                      --
--    Purpose:                                                          --
--     A set of foreign procedures for calling transeda tasks from      --
--     VHDL code.                                                       --
--                                                                      --
--------------------------------------------------------------------------

library ieee; 
use ieee.std_logic_1164.all;


entity vhdlcover_probe0 is
  generic (reference : integer; control : string; dynamic_flag : integer; store_as_var_flag : integer);
end;

architecture fli of vhdlcover_probe0 is
  attribute foreign of fli : architecture is "VHPI fsdbwrapper; fli_vhdlcover_probe0";
begin
end;


package vnvhdl is
  
  attribute foreign : string;

  function vhdlcover_map   (control : IN string)  return integer;
  attribute foreign of vhdlcover_map : function is "vn_vhdlcover_map fsdbwrapper";

  function vhdlcover_probeS (reference : IN integer;
            probe_id  : IN integer;
            increment : IN integer := 1) return boolean;
  attribute foreign of vhdlcover_probeS : function is "vn_vhdlcover_probeS fsdbwrapper";

  function vhdlcover_probeE (reference : IN integer;
            probe_id  : IN integer;
            increment : IN integer := 1) return boolean;
  attribute foreign of vhdlcover_probeE : function is "vn_vhdlcover_probeE fsdbwrapper";

  function vhdlcover_probeB (reference : IN integer;
            probe_id  : IN integer;
            increment : IN integer := 1) return boolean;
  attribute foreign of vhdlcover_probeB : function is "vn_vhdlcover_probeB fsdbwrapper";

  function vhdlcover_probeP (reference : IN integer;
            start : IN integer;
 			target : IN integer) return boolean;
  attribute foreign of vhdlcover_probeP : function is "vn_vhdlcover_probeP fsdbwrapper";

  function vhdlcover_fliC (reference : IN integer;
          group_id : IN integer;
          group_data : IN string) return boolean;
  attribute foreign of vhdlcover_fliC : function is "vn_vhdlcover_fliC fsdbwrapper";

  function vhdlcover_fliT (reference : IN integer;
          group_id : IN integer;
          group_data : IN string) return boolean;
  attribute foreign of vhdlcover_fliT : function is "vn_vhdlcover_fliT fsdbwrapper";

  function vhdlcover_fliV (reference : IN integer;
          group_id : IN integer;
          group_data : IN string) return boolean;
  attribute foreign of vhdlcover_fliV : function is "vn_vhdlcover_fliV fsdbwrapper";

  function vhdlcover_fliA (reference : IN integer;
            probe_id : IN integer;
            values : IN string) return boolean;
  attribute foreign of vhdlcover_fliA : function is "vn_vhdlcover_fliA fsdbwrapper";

end;
