--------------------------------------------------------------------------
--                                                                      --
-- Copyright (c) 1997 - 2009 Aldec, Inc.  All rights reserved.          --
--                                                                      --
-- This source file may be used and distributed without restriction     --
-- provided that this copyright statement is not removed from the file  --
-- and that any derivative work contains this copyright notice.         --
--                                                                      --
--                       						--
--                                                                      --
--                                                                      --
--                                                                      --
--                                                                      --
--                                                                      --
-------------------------------------------------------------------------- 

library ieee;
use ieee.std_logic_1164.all;

PACKAGE Memory_Modeler IS

  --  mmAddressMap writes memory within a range to a file.
  --  It returns 0 if it succeeds, non zero otherwise.
  FUNCTION mmAddressMap(
    memoryName : STRING; 
    mmid       : INTEGER;
    scramble   : STRING; 
    verbose    : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAddressMap : FUNCTION IS "VHPI denali;addressmap";
        
        
  --  mmAddToSysMem adds to a system memory
  --  -1 is returned on an error
  FUNCTION mmAddToSysMem(
    vmId       : INTEGER;
    mmId       : INTEGER;
    widthPos   : INTEGER;
    depthPos   : INTEGER;
    interleave : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAddToSysMem : FUNCTION IS "VHPI denali;addtosysmem";

  
  --  mmAddToSysMemMask adds to a system memory using a mask
  --  -1 is returned on an error
  FUNCTION mmAddToSysMemMask(
    vmId       : INTEGER;
    mmId       : INTEGER;
    mask       : STRING;
    widthPos   : INTEGER;
    depthPos   : INTEGER;
    interleave : INTEGER
    )
  RETURN INTEGER; 
  ATTRIBUTE FOREIGN OF mmAddToSysMemMask : FUNCTION IS "VHPI denali;addtosysmemmask";

        
  --  mmAssert creates a assertion
  --  -1 is returned on an error
  FUNCTION mmAssert(
    instanceId   : INTEGER;
    bkptype      : STRING;
    bkpaccess    : STRING;
    action       : STRING;
    data         : STRING;
    mask         : STRING;
    compare      : STRING;
    parity       : INTEGER;
    addressStart : INTEGER;
    addressEnd   : INTEGER;
    addressInc   : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssert : FUNCTION IS "VHPI denali;assertcreate";
  
  
  --  mmassertonphysical enables system assertions on accesses of physical instances
  --  It returns 0 if it succeeds, non zero otherwise. 
  FUNCTION mmAssertOnPhysical(
    theBkpId : INTEGER;
    flag     : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssertOnPhysical : FUNCTION IS "VHPI denali;assertonphysical";

  
  --  mmassertonuseraccess enables assertions on user accesses also (vs. model access only)
  --  It returns 0 if it succeeds, non zero otherwise. 
  FUNCTION mmAssertOnUserAccess(
    flag : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssertOnUserAccess : FUNCTION IS "VHPI denali;assertonuseraccess";

  
  --  mmAssert_Access creates an access type assertion
  --  -1 is returned on an error
  FUNCTION mmAssert_Access(
    instanceId   : INTEGER;
    bkpaccess    : STRING;
    action       : STRING;
    addressStart : INTEGER;
    addressEnd   : INTEGER;
    addressInc   : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssert_Access : FUNCTION IS "VHPI denali;assertaccess";

  
  --  mmAssert_DataValue creates a datavalue type assertion
  --  -1 is returned on an error
  FUNCTION mmAssert_DataValue(
    instanceId   : INTEGER;
    bkpaccess    : STRING;
    action       : STRING;
    data         : STRING;
    mask         : STRING;
    compare      : STRING;
    addressStart : INTEGER;
    addressEnd   : INTEGER;
    addressInc   : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssert_DataValue : FUNCTION IS "VHPI denali;assertdatavalue";

  
  --  mmAssert_Parity creates a parity assertion
  --  -1 is returned on an error
  FUNCTION mmAssert_Parity(
    instanceId   : INTEGER;
    bkpaccess    : STRING;
    action       : STRING;
    parity       : INTEGER;
    addressStart : INTEGER;
    addressEnd   : INTEGER;
    addressInc   : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssert_Parity : FUNCTION IS "VHPI denali;assertparity";

  
  --  mmAssert_RRA creates a global RRA assertion
  --  -1 is returned on an error
  FUNCTION mmAssert_RRA(
    action : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssert_RRA : FUNCTION IS "VHPI denali;assertrra";

  
  --  mmAssert_RWA creates a global RWA assertion
  --  -1 is returned on an error
  FUNCTION mmAssert_RWA(
    action : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssert_RWA : FUNCTION IS "VHPI denali;assertrwa";

  
  --  mmAssertUMA creates a global UMA assertion
  --  -1 is returned on an error
  FUNCTION mmAssert_UMA(
    action : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmAssert_UMA : FUNCTION IS "VHPI denali;assertuma"; 


  --  mmCheckOut checks out a Denali license.  
  --  It returns 0 if it succeeds, non zero otherwise.
  FUNCTION mmCheckOut(
    feature : STRING
    ) 
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmCheckOut : FUNCTION IS "VHPI denali;checkout";
  
		
  --  mmComp compares a memory instance with the contents of a file.
  --  It returns 0 if the two compare exactly.
  FUNCTION mmComp(
    instance_name : STRING;
    file_name     : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmComp : FUNCTION IS "VHPI denali;comp";

  
  FUNCTION mmCreateScratchpad(
    name      : STRING;
    width     : INTEGER;
    depth     : INTEGER;
    initvalue : STD_LOGIC_VECTOR
    ) 
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmCreateScratchpad : FUNCTION IS "VHPI denali;createscratchpad";

  
  --  mmCreateSysMem creates a system memory
  --  -1 is returned on an error
  FUNCTION mmCreateSysMem(
    memoryName    : STRING;
    componentName : STRING;
    width         : INTEGER;
    depth         : INTEGER;
    interleaves   : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmCreateSysMem : FUNCTION IS "VHPI denali;createsysmem";

  
  --  mmDebugOff turns off debug
  FUNCTION mmDebugOff
  RETURN INTEGER;
  attribute FOREIGN OF mmDebugOff : FUNCTION IS "VHPI denali;debugoff";

  
  --  mmDebugOn turns on debug
  FUNCTION mmDebugOn
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmDebugOn : FUNCTION IS "VHPI denali;debugon";


  --  mmDisableAssertion disables an assertion
  --  -1 is returned on an error
  FUNCTION mmDisableAssertion(
    bkpId : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmDisableAssertion : FUNCTION IS "VHPI denali;disableassertion";

  
  --  mmEnableAssertion enables an assertion
  --  -1 is returned on an error
  FUNCTION mmEnableAssertion(
    bkpId : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmEnableAssertion : FUNCTION IS "VHPI denali;enableassertion";


  --  mmErrInject makes error injection 
  --  -1 is returned on an error
  FUNCTION mmErrInject(
    mmId       : INTEGER;
    error_type : STRING
  )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmErrInject : FUNCTION IS "VHPI denali;errinject";
  

  --  mmEval evaluates a Tcl command of the built in tcl interpreter 
  --  If the operation was successful the SUCCESS is set to TRUE, FALSE otherwise.
  FUNCTION  mmEval(
    commandstr : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmEval : FUNCTION IS "VHPI denali;tcleval";      
  
                
  --  mmFault creates a fault at a memory location
  --  -1 is returned on an error
  FUNCTION mmFault(
    mmId        : INTEGER;
    fault       : STRING;
    addr        : INTEGER;
    bitNum      : INTEGER;
    bitValue    : INTEGER;
    addrSlave   : INTEGER;
    bitNumSlave : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmFault : FUNCTION IS "VHPI denali;fault";

                
  --  mmGetInstanceId gets an instance ID given the full instance name.
  --  -1 is returned if the instance is not found.
  FUNCTION mmGetInstanceId(
    instance_name : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmGetInstanceId : FUNCTION IS "VHPI denali;getinstanceid";

  
  --  mmInitPureData checks out a PureData Denali license.  
  --  It returns 0 if it succeeds, non zero otherwise.
  FUNCTION mmInitPureData(
    feature : STRING
    ) 
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmInitPureData : FUNCTION IS "VHPI denali;initpuredata";
        
        
  --  mmLoad loads a memory instance from the contents of a file.
  --  It returns 0 if it succeeds, non zero otherwise.
  FUNCTION mmLoad(
    instance_name : STRING;
    file_name     : STRING
    ) 
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmLoad : FUNCTION IS "VHPI denali;load";
  
  
  --  mmReadWord reads data from memory.
  --  If the operation was successful the SUCCESS is set to TRUE, FALSE otherwise.
  PROCEDURE mmReadWord(
    instanceId : INTEGER;
    address    : INTEGER;
    data       : OUT STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
  );
  ATTRIBUTE FOREIGN OF mmReadWord[INTEGER, INTEGER, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;readword";


  PROCEDURE mmReadWord(
    instanceId : INTEGER;
    address    : STD_LOGIC_VECTOR;
    data       : OUT STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    );
  ATTRIBUTE FOREIGN OF mmReadWord[INTEGER, STD_LOGIC_VECTOR, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;readword";                                                      


  PROCEDURE mmReadWord(
    instanceId : INTEGER;
    address    : BIT_VECTOR;
    data       : OUT STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    );
  ATTRIBUTE FOREIGN OF mmReadWord[INTEGER, BIT_VECTOR, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;readword";   
  
  
  --  mmreset
  FUNCTION mmReset(
    instance_name : STRING
	)
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmReset : FUNCTION IS "VHPI denali;reset";
  
  
  FUNCTION mmSave(
    instance_name : STRING;
    file_name     : STRING
    ) 
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmSave : FUNCTION IS "VHPI denali;save";
  
  
  FUNCTION mmSaveRange(
    instance_name : STRING; 
    file_name     : STRING; 
    addressStart  : INTEGER;
    addressEnd    : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmSaveRange : FUNCTION IS "VHPI denali;saverange";


  -- mmSetAllErrInject sets the error injection on/off for all instances
  --  -1 is returned on an error
  FUNCTION mmSetAllErrInject(
    flag : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmSetAllErrInject : FUNCTION IS "VHPI denali;setallerrinject";

  
  -- mmSetAllFault sets faults on/off for all instances
  --  -1 is returned on an error
  FUNCTION mmSetAllFault(
    flag : INTEGER
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmSetAllFault : FUNCTION IS "VHPI denali;setallfault";
  
  
  --  mmSetErrInject sets the error injection on/off
  --  -1 is returned on an error
  --  the parameter flag is 1/0 whether to turn error injection on reads  
  --      from the pins on/off.   
  FUNCTION mmSetErrInject(
    mmId : INTEGER;
    flag : INTEGER
  )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmSetErrInject[INTEGER, INTEGER RETURN INTEGER] : FUNCTION IS "VHPI denali;seterrinject";
  
  
  --  mmSetErrInject sets the error injection on/off
  --  -1 is returned on an error
  --  the parameter flag is 1/0 whether to turn error injection on reads  
  --      from the pins on/off.
  --  the parameter backdoorenabled is 1/0 whether to turn error injection
  --      on reads from backdoor functions on/off  
  FUNCTION mmSetErrInject(
    mmId            : INTEGER;
    flag            : INTEGER;
    backdoorenabled : INTEGER
  )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmSetErrInject[INTEGER, INTEGER, INTEGER RETURN INTEGER] : FUNCTION IS "VHPI denali;seterrinject";
  
  
  --  mmSetFault sets the fault on/off
  --  -1 is returned on an error
  FUNCTION mmSetFault(
    mmId : INTEGER;
    flag : INTEGER
  )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmSetFault : FUNCTION IS "VHPI denali;setfault";
  
  
  --  mmSetFillValue sets the initial value of memory for a given instance.
  --  The value is given as a hexadecimal STRING "0x...", or as "0", "1", "X"
  --  -1 is returned if the instance is not found, or the input STRING is not valid
  FUNCTION mmSetFillValue(
    instanceId      : INTEGER;
    fillValueSTRING : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmSetFillValue : FUNCTION IS "VHPI denali;setfillvalue";
  
  
  --  mmStartPureData starts puredata
  FUNCTION mmStartPureData
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmStartPureData : FUNCTION IS "VHPI denali;startpuredata";
  
  
  --  mmStartPureView starts pureview
  FUNCTION mmStartPureView
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmStartPureView : FUNCTION IS "VHPI denali;startpureview";
  
  
  --  mmStopPureView terminates pureview
  FUNCTION mmStopPureView
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmStopPureView : FUNCTION IS "VHPI denali;stoppureview";
  
  
  --  mmTclCallback assigns a TCL callback to an assertion
  --  It returns 0 if it succeeds, non zero otherwise.
  FUNCTION mmTclCallback(
    mmid      : INTEGER;
    bkpid     : INTEGER;
    tclString : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmTclCallback : FUNCTION IS "VHPI denali;tclcallback";

  
  --  mmTclEval evaluates a Tcl command of the built in tcl interpreter 
  --  If the operation was successful the SUCCESS is set to TRUE, FALSE otherwise.
  FUNCTION  mmTclEval(
    commandstr : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmTclEval : FUNCTION IS "VHPI denali;tcleval";
  
  
  --  mmWriteWord writes data into memory. 
  --  If the operation was successful the SUCCESS is set to TRUE, FALSE otherwise.
  PROCEDURE mmWriteWord(
    instanceId : INTEGER;
    address    : INTEGER;
    data       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    );
  ATTRIBUTE FOREIGN OF mmWriteWord[INTEGER, INTEGER, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;writeword";
  
  
  PROCEDURE mmWriteWord(
    instanceId : INTEGER;
    address    : STD_LOGIC_VECTOR;
    data       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    );
  ATTRIBUTE FOREIGN OF mmWriteWord[INTEGER, STD_LOGIC_VECTOR, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;writeword";
  
  
  PROCEDURE mmWriteWord(
    instanceId : INTEGER;
    address    : BIT_VECTOR;
    data       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    );
  ATTRIBUTE FOREIGN OF mmWriteWord[INTEGER, BIT_VECTOR, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;writeword";
  
  
  --  mmWriteWordMasked writes masked data into memory.
  --  If the operation was successful the SUCCESS is set to TRUE, FALSE otherwise.
  PROCEDURE mmWriteWordMasked(
    instanceId : INTEGER;
    address    : INTEGER;
    data       : STD_LOGIC_VECTOR;
    mask       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    );
  ATTRIBUTE FOREIGN OF mmWriteWordMasked[INTEGER, INTEGER, STD_LOGIC_VECTOR, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;writewordmasked";


  PROCEDURE mmWriteWordMasked(
    instanceId : INTEGER;
    address    : STD_LOGIC_VECTOR;
    data       : STD_LOGIC_VECTOR;
    mask       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    );
  ATTRIBUTE FOREIGN OF mmWriteWordMasked[INTEGER, STD_LOGIC_VECTOR, STD_LOGIC_VECTOR, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;writewordmasked";
  
  
  PROCEDURE mmWriteWordMasked(
    instanceId : INTEGER;
    address    : BIT_VECTOR;
    data       : STD_LOGIC_VECTOR;
    mask       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    );
  ATTRIBUTE FOREIGN OF mmWriteWordMasked[INTEGER, BIT_VECTOR, STD_LOGIC_VECTOR, STD_LOGIC_VECTOR, BOOLEAN] : PROCEDURE IS "VHPI denali;writewordmasked";
  
  
  FUNCTION mmXmlEval(
    xmlString : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmXmlEval : FUNCTION IS "VHPI denali;xmleval";
  
  
  FUNCTION mmXmlFile(
    xmlFile : STRING
    )
  RETURN INTEGER;
  ATTRIBUTE FOREIGN OF mmXmlFile : FUNCTION IS "VHPI denali;xmlfile";

END PACKAGE Memory_Modeler;

PACKAGE BODY Memory_Modeler is
  FUNCTION mmAddressMap(
    memoryName : STRING; 
    mmid       : INTEGER;
    scramble   : STRING; 
    verbose    : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAddressMap call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
        

  FUNCTION mmAddToSysMem(
    vmId       : INTEGER;
    mmId       : INTEGER;
    widthPos   : INTEGER;
    depthPos   : INTEGER;
    interleave : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAddToSysMem call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmAddToSysMemMask(
    vmId       : INTEGER;
    mmId       : INTEGER;
    mask       : string;
    widthPos   : INTEGER;
    depthPos   : INTEGER;
    interleave : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAddToSysMemMask call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

        
  FUNCTION mmAssert(
    instanceId   : INTEGER;
    bkptype      : STRING;
    bkpaccess    : STRING;
    action       : STRING;
    data         : STRING;
    mask         : STRING;
    compare      : STRING;
    parity       : INTEGER;
    addressStart : INTEGER;
    addressEnd   : INTEGER;
    addressInc   : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssert call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmAssertOnPhysical(
    theBkpId : INTEGER;
    flag     : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssertOnPhysical call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmAssertOnUserAccess(
    flag : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssertOnUserAccess call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmAssert_Access(
    instanceId   : INTEGER;
    bkpaccess    : STRING;
    action       : STRING;
    addressStart : INTEGER;
    addressEnd   : INTEGER;
    addressInc   : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssert_Access call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmAssert_DataValue(
    instanceId   : INTEGER;
    bkpaccess    : STRING;
    action       : STRING;
    data         : STRING;
    mask         : STRING;
    compare      : STRING;
    addressStart : INTEGER;
    addressEnd   : INTEGER;
    addressInc   : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssert_DataValue call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmAssert_Parity(
    instanceId   : INTEGER;
    bkpaccess    : STRING;
    action       : STRING;
    parity       : INTEGER;
    addressStart : INTEGER;
    addressEnd   : INTEGER;
    addressInc   : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssert_Parity call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmAssert_RRA(
    action : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssert_RRA call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmAssert_RWA(
    action : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssert_RWA call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmAssert_UMA(
    action : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmAssert_UMA call failed" SEVERITY FAILURE;
	RETURN -1;
  END; 


  FUNCTION mmCheckOut(
    feature : STRING
    ) 
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmCheckOut call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
		
  FUNCTION mmComp(
    instance_name : STRING;
    file_name     : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmComp call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmCreateScratchpad(
    name      : STRING;
    width     : INTEGER;
    depth     : INTEGER;
    initvalue : STD_LOGIC_VECTOR
    ) 
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmCreateScratchpad call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmCreateSysMem(
    memoryName    : STRING;
    componentName : STRING;
    width         : INTEGER;
    depth         : INTEGER;
    interleaves   : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmCreateSysMem call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmDebugOff
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmDebugOff call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmDebugOn
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmDebugOn call failed" SEVERITY FAILURE;
	RETURN -1;
  END;


  FUNCTION mmDisableAssertion(
    bkpId : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmDisableAssertion call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmEnableAssertion(
    bkpId : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmEnableAssertion call failed" SEVERITY FAILURE;
	RETURN -1;
  END;


  FUNCTION mmErrInject(
    mmId       : INTEGER;
    error_type : STRING
  )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmErrInject call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
        

  FUNCTION  mmEval(
    commandstr : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmEval call failed" SEVERITY FAILURE;
	RETURN -1;
  END;      
  
                
  FUNCTION mmFault(
    mmId        : INTEGER;
    fault       : STRING;
    addr        : INTEGER;
    bitNum      : INTEGER;
    bitValue    : INTEGER;
    addrSlave   : INTEGER;
    bitNumSlave : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmFault call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

                
  FUNCTION mmGetInstanceId(
    instance_name : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmGetInstanceId call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION mmInitPureData(
    feature : STRING
    ) 
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmInitPureData call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
        
        
  FUNCTION mmLoad(
    instance_name : STRING;
    file_name     : STRING
    ) 
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmLoad call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  PROCEDURE mmReadWord(
    instanceId : INTEGER;
    address    : INTEGER;
    data       : OUT STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
  ) IS
  BEGIN
    ASSERT FALSE REPORT "mmReadWord call failed" SEVERITY FAILURE;
  END;


  PROCEDURE mmReadWord(
    instanceId : INTEGER;
    address    : STD_LOGIC_VECTOR;
    data       : OUT STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    ) IS
  BEGIN
    ASSERT FALSE REPORT "mmReadWord call failed" SEVERITY FAILURE;
  END;                                                      


  PROCEDURE mmReadWord(
    instanceId : INTEGER;
    address    : BIT_VECTOR;
    data       : OUT STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    ) IS
  BEGIN
    ASSERT FALSE REPORT "mmReadWord call failed" SEVERITY FAILURE;
  END;   
  
  
  FUNCTION mmReset(
    instance_name : STRING
	)
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmReset call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmSave(
    instance_name : STRING;
    file_name     : STRING
    ) 
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmSave call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmSaveRange(
    instance_name : STRING; 
    file_name     : STRING; 
    addressStart  : INTEGER;
    addressEnd    : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmSaveRange call failed" SEVERITY FAILURE;
	RETURN -1;
  END;


  FUNCTION mmSetAllErrInject(
    flag : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmSetAllErrInject call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmSetAllFault(
    flag : INTEGER
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmSetAllFault call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmSetErrInject(
    mmId : INTEGER;
    flag : INTEGER
  )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmSetErrInject call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmSetErrInject(
    mmId            : INTEGER;
    flag            : INTEGER;
    backdoorenabled : INTEGER
  )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmSetErrInject call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmSetFault(
    mmId : INTEGER;
    flag : INTEGER
  )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmSetFault call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmSetFillValue(
    instanceId      : INTEGER;
    fillValueSTRING : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmSetFillValue call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmStartPureData
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmStartPureData call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmStartPureView
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmStartPureView call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmStopPureView
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmStopPureView call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmTclCallback(
    mmid      : INTEGER;
    bkpid     : INTEGER;
    tclString : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmTclCallback call failed" SEVERITY FAILURE;
	RETURN -1;
  END;

  
  FUNCTION  mmTclEval(
    commandstr : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmTclEval call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  PROCEDURE mmWriteWord(
    instanceId : INTEGER;
    address    : INTEGER;
    data       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    ) IS
  BEGIN
    ASSERT FALSE REPORT "mmWriteWord call failed" SEVERITY FAILURE;
  END;
  
  
  PROCEDURE mmWriteWord(
    instanceId : INTEGER;
    address    : STD_LOGIC_VECTOR;
    data       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    ) IS
  BEGIN
    ASSERT FALSE REPORT "mmWriteWord call failed" SEVERITY FAILURE;
  END;
  
  
  PROCEDURE mmWriteWord(
    instanceId : INTEGER;
    address    : BIT_VECTOR;
    data       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    ) IS
  BEGIN
    ASSERT FALSE REPORT "mmWriteWord call failed" SEVERITY FAILURE;
  END;
  
  
  PROCEDURE mmWriteWordMasked(
    instanceId : INTEGER;
    address    : INTEGER;
    data       : STD_LOGIC_VECTOR;
    mask       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    ) IS
  BEGIN
    ASSERT FALSE REPORT "mmWriteWordMasked call failed" SEVERITY FAILURE;
  END;


  PROCEDURE mmWriteWordMasked(
    instanceId : INTEGER;
    address    : STD_LOGIC_VECTOR;
    data       : STD_LOGIC_VECTOR;
    mask       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    ) IS
  BEGIN
    ASSERT FALSE REPORT "mmWriteWordMasked call failed" SEVERITY FAILURE;
  END;
  
  
  PROCEDURE mmWriteWordMasked(
    instanceId : INTEGER;
    address    : BIT_VECTOR;
    data       : STD_LOGIC_VECTOR;
    mask       : STD_LOGIC_VECTOR;
    SUCCESS    : OUT BOOLEAN
    ) IS
  BEGIN
    ASSERT FALSE REPORT "mmWriteWordMasked call failed" SEVERITY FAILURE;
  END;


  FUNCTION mmXmlEval(
    xmlString : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmXmlEval call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
  
  FUNCTION mmXmlFile(
    xmlFile : STRING
    )
  RETURN INTEGER IS
  BEGIN
    ASSERT FALSE REPORT "mmXmlFile call failed" SEVERITY FAILURE;
	RETURN -1;
  END;
  
END PACKAGE BODY Memory_Modeler;
