--------------------------------------------------------------------------
--                                                                      --
-- (c) 1990 Aldec, Inc. All rights reserved.                           --
--                                                                      --
-- This source file may be used and distributed without restriction     --
-- provided that this copyright statement is not removed from the file  --
-- and that any derivative work contains this copyright notice.         --
--                                                                      --
--    Package name: FSDB_WRAPPER                                        --
--                                                                      --
--    Purpose:                                                          --
--     A set of foreign procedures for calling fsdb tasks from          --
--     VHDL code.                                                       --
--                                                                      --
--------------------------------------------------------------------------


package fsdb_wrapper is

  procedure fsdbDumpfile(file_name	: IN string);
  attribute foreign of fsdbDumpfile : procedure is "fsdbDumpfile fsdbwrapper";

  procedure fsdbDumpvarsToFile(scope_file_name : IN string; file_name : IN string := "");
  attribute foreign of fsdbDumpvarsToFile: procedure is "fsdbDumpvarsToFile fsdbwrapper";

  procedure fsdbDumpvars(depth : IN integer; region_name : IN string);
  attribute foreign of fsdbDumpvars : procedure is "fsdbDumpvars fsdbwrapper";

  procedure fsdbDumpSingle(signal_name : IN string);
  attribute foreign of fsdbDumpSingle : procedure is "fsdbDumpSingle fsdbwrapper";

  procedure fsdbDumpVariable(variable_name : IN string);
  attribute foreign of fsdbDumpVariable : procedure is "fsdbDumpVariable fsdbwrapper";

  procedure fsdbVersion;
  attribute foreign of fsdbVersion : procedure is "fsdbVersion fsdbwrapper";

  procedure fsdbSwitchDumpfile(file_name : IN string);
  attribute foreign of fsdbSwitchDumpfile : procedure is "fsdbSwitchDumpfile fsdbwrapper";

  procedure fsdbDumpon;
  attribute foreign of fsdbDumpon : procedure is "fsdbDumpon fsdbwrapper";

  procedure fsdbDumpoff;
  attribute foreign of fsdbDumpoff : procedure is "fsdbDumpoff fsdbwrapper";

  procedure fsdbDumpflush;
  attribute foreign of fsdbDumpflush : procedure is "fsdbDumpflush fsdbwrapper";

  procedure fsdbDumpMem(signal_name	: IN string; begin_cell : IN integer := -1; size : IN integer := -1; cycle_time : IN time := 0ns; trigger : IN string := ""; delay_time : IN time := 0ns);
  attribute foreign of fsdbDumpMem : procedure is "fsdbDumpMem fsdbwrapper";

  procedure fsdbDumpMemNow(signal_name	: IN string; begin_cell : IN integer := -1; size : IN integer := -1);
  attribute foreign of fsdbDumpMemNow : procedure is "fsdbDumpMemNow fsdbwrapper";

  procedure fsdbAutoSwitchDumpfile(file_size : IN integer; file_name : IN string; file_amount : IN integer; log_file_name : IN string := "");
  attribute foreign of fsdbAutoSwitchDumpfile : procedure is "fsdbAutoSwitchDumpfile fsdbwrapper";

  procedure fsdbDumpOVA( level : IN integer := 0; scope: IN string := "";files  : IN string := "";file_name : IN string := "");
  attribute foreign of fsdbDumpOVA : procedure is "fsdbDumpOVA fsdbwrapper";

  procedure fsdbDumpOVAon;
  attribute foreign of fsdbDumpOVAon : procedure is "fsdbDumpOVAon fsdbwrapper";

  procedure fsdbDumpOVAoff;
  attribute foreign of fsdbDumpOVAoff : procedure is "fsdbDumpOVAoff fsdbwrapper";

  procedure fsdbDumpSVA( level : IN integer := 0; scope: IN string := "";files  : IN string := "";file_name : IN string := "");
  attribute foreign of fsdbDumpSVA : procedure is "fsdbDumpSVA fsdbwrapper";

  procedure fsdbDumpSVAon;
  attribute foreign of fsdbDumpSVAon : procedure is "fsdbDumpSVAon fsdbwrapper";

  procedure fsdbDumpSVAoff;
  attribute foreign of fsdbDumpSVAoff : procedure is "fsdbDumpSVAoff fsdbwrapper";

  procedure fsdbDumpPSL( level : IN integer := 0; scope: IN string := "";files  : IN string := "";file_name : IN string := "");
  attribute foreign of fsdbDumpPSL : procedure is "fsdbDumpPSL fsdbwrapper";

  procedure fsdbDumpPSLon;
  attribute foreign of fsdbDumpPSLon : procedure is "fsdbDumpPSLon fsdbwrapper";

  procedure fsdbDumpPSLoff;
  attribute foreign of fsdbDumpPSLoff : procedure is "fsdbDumpPSLoff fsdbwrapper";

end;
