---------------------------------------------------------------------------------
--                                                                             --
-- (c) 2005 Aldec, Inc. All rights reserved.                                   --
--                                                                             --
-- This source file may be used and distributed without restriction            --
-- provided that this copyright statement is not removed from the file         --
-- and that any derivative work contains this copyright notice.                --
--                                                                             --
--    Package name: ALDEC_TOOLS                                                --
--                                                                             --
--    Purpose:                                                                 --
--     A set of foreign procedures for calling trace and force from VHDL code. --
--     A set of foreign functions to convert values and recive simulation      --
--         resolution.                                                         --
--                                                                             --
---------------------------------------------------------------------------------


package aldec_tools is

    procedure asdb_flush;
    procedure asdb_dump ( signal_name: string );
    procedure asdb_dump ( entity_name: string; counter: integer );
    procedure asdb_dump_on;
    procedure asdb_dump_off;
    procedure force ( mode: string; signal_name: string; formula: string );
    procedure noforce ( signal_name: string );
    function to_real ( time_val : IN time ) return real;
    function to_time ( real_val : IN real ) return time;
    function get_resolution return real;

    attribute foreign of asdb_flush: procedure is "VHPI systf; call_vhpi_asdb_flush";
    attribute foreign of asdb_dump[string]: procedure is "VHPI systf; call_vhpi_asdb_dump";
    attribute foreign of asdb_dump[string,integer]: procedure is "VHPI systf; call_vhpi_asdb_dump";
    attribute foreign of asdb_dump_on: procedure is "VHPI systf; call_vhpi_asdb_dump_on";
    attribute foreign of asdb_dump_off: procedure is "VHPI systf; call_vhpi_asdb_dump_off";
    attribute foreign of force: procedure is "VHPI systf; call_vhpi_force";
    attribute foreign of noforce: procedure is "VHPI systf; call_vhpi_noforce";
    attribute foreign of to_real: function is "VHPI systf; time_to_real";  
    attribute foreign of to_time: function is "VHPI systf; real_to_time";  
    attribute foreign of get_resolution: function is "VHPI systf; call_vhpi_get_resolution";  

end package aldec_tools;

package body aldec_tools is

    procedure asdb_flush is
    begin
    end procedure asdb_flush;

    procedure asdb_dump ( signal_name: string ) is
    begin
    end procedure asdb_dump;

    procedure asdb_dump ( entity_name: string; counter: integer ) is
    begin
    end procedure asdb_dump;
    
    procedure asdb_dump_off is
    begin
    end procedure asdb_dump_off;
    
    procedure asdb_dump_on is
    begin
    end procedure asdb_dump_on;

    procedure force ( mode: string; signal_name: string; formula: string ) is
    begin
    end procedure force;

    procedure noforce ( signal_name: string ) is
    begin
    end procedure noforce;

	function to_real ( time_val : IN time ) return real is
    begin
    end function to_real;
 
    function to_time ( real_val : IN real ) return time is
    begin
    end function to_time;
 
    function get_resolution return real is
    begin
    end function get_resolution;

end package body aldec_tools;
