--------------------------------------------------------------------------
--                                                                      --
-- Copyright (c) 1997 - 2009 Aldec, Inc.  All rights reserved.          --
--                                                                      --
-- This source file may be used and distributed without restriction     --
-- provided that this copyright statement is not removed from the file  --
-- and that any derivative work contains this copyright notice.         --
--                                                                      --
--                       						--
--                                                                      --
--                                                                      --
--                                                                      --
--                                                                      --
--                                                                      --
-------------------------------------------------------------------------- 


library IEEE;
use IEEE.std_logic_1164.all;
entity and2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
	   );
end and2;
architecture and2 of and2 is
begin
O <= I0 and I1;
end and2;


library IEEE;
use IEEE.std_logic_1164.all;
entity and2b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and2b1;
architecture and2b1 of and2b1 is
begin
O <= not(I0) and I1;
end and2b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity and2b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and2b2;
architecture and2b2 of and2b2 is
begin
O <= not(I0) and not(I1);
end and2b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity and3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and3;
architecture and3 of and3 is
begin
O <= I0 and I1 and I2;
end and3;


library IEEE;
use IEEE.std_logic_1164.all;
entity and3b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and3b1;
architecture and3b1 of and3b1 is
begin
O <= not(I0) and I1 and I2;
end and3b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity and3b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and3b2;
architecture and3b2 of and3b2 is
begin
O <= not(I0) and not(I1) and I2;
end and3b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity and3b3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and3b3;
architecture and3b3 of and3b3 is
begin
O <= not(I0) and not(I1) and not(I2);
end and3b3;


library IEEE;
use IEEE.std_logic_1164.all;
entity and4 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and4;
architecture and4 of and4 is
begin
O <= I0 and I1 and I2 and I3;
end and4;


library IEEE;
use IEEE.std_logic_1164.all;
entity and4b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and4b1;
architecture and4b1 of and4b1 is
begin
O <= not(I0) and I1 and I2 and I3;
end and4b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity and4b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and4b2;
architecture and4b2 of and4b2 is
begin
O <= not(I0) and not(I1) and I2 and I3;
end and4b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity and4b3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and4b3;
architecture and4b3 of and4b3 is
begin
O <= not(I0) and not(I1) and not(I2) and I3;
end and4b3;


library IEEE;
use IEEE.std_logic_1164.all;
entity and4b4 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end and4b4;
architecture and4b4 of and4b4 is
begin
O <= not(I0) and not(I1) and not(I2) and not(I3);
end and4b4;


library IEEE;
use IEEE.std_logic_1164.all;
entity buf is
  port(
       I : in STD_LOGIC;
       O : out STD_LOGIC
  );
end buf;
architecture buf of buf is
begin
O <= I;
end buf; 


library IEEE;
use IEEE.std_logic_1164.all;
entity buft is
  port(
       I : in STD_LOGIC;
       T : in STD_LOGIC;
       O : out STD_LOGIC
  );
end buft;
architecture buft of buft is
begin
O <= I when T='1' else 'Z';
end buft;


library IEEE;
use IEEE.std_logic_1164.all;
entity inv is
  port(
       I : in STD_LOGIC;
       O : out STD_LOGIC
  );
end inv;
architecture inv of inv is
begin
O <= not(I);
end inv;


library IEEE;
use IEEE.std_logic_1164.all;
entity m2_1 is
  port(
       D0 : in STD_LOGIC;
       D1 : in STD_LOGIC;
       S0 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end m2_1;
architecture m2_1 of m2_1 is
begin
O <= (D0 and not S0) or (D1 and S0);


end m2_1;


library IEEE;
use IEEE.std_logic_1164.all;
entity m2_1b1 is
  port(
       D0 : in STD_LOGIC;
       D1 : in STD_LOGIC;
       S0 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end m2_1b1;
architecture m2_1b1 of m2_1b1 is
begin
O <= (not(D0) and not S0) or (D1 and S0);
end m2_1b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity m2_1b2 is
  port(
       D0 : in STD_LOGIC;
       D1 : in STD_LOGIC;
       S0 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end m2_1b2;
architecture m2_1b2 of m2_1b2 is
begin
O <= (not(D0) and not S0) or (not(D1) and S0);
end m2_1b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand2;
architecture nand2 of nand2 is
begin
O <= not(I0 and I1);
end nand2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand2b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand2b1;
architecture nand2b1 of nand2b1 is

begin

----  Component instantiations  ----

O <= not(not(I0) and I1);


end nand2b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand2b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand2b2;
architecture nand2b2 of nand2b2 is

begin

----  Component instantiations  ----

O <= not(not(I0) and not(I1));


end nand2b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand3;
architecture nand3 of nand3 is
begin
O <= not(I0 and I1 and I2);
end nand3;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand3b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand3b1;
architecture nand3b1 of nand3b1 is
begin
O <= not(not(I0) and I1 and I2);
end nand3b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand3b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand3b2;
architecture nand3b2 of nand3b2 is
begin
O <= not(not(I0) and not(I1) and I2);
end nand3b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand3b3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand3b3;
architecture nand3b3 of nand3b3 is
begin
O <= not(not(I0) and not(I1) and not(I2));
end nand3b3;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand4 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand4;
architecture nand4 of nand4 is
begin
O <= not(I0 and I1 and I2 and I3);
end nand4;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand4b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand4b1;
architecture nand4b1 of nand4b1 is
begin
O <= not(not(I0) and I1 and I2 and I3);
end nand4b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand4b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand4b2;
architecture nand4b2 of nand4b2 is
begin
O <= not(not(I0) and not(I1) and I2 and I3);
end nand4b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand4b3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand4b3;
architecture nand4b3 of nand4b3 is
begin
O <= not(not(I0) and not(I1) and not(I2) and I3);
end nand4b3;


library IEEE;
use IEEE.std_logic_1164.all;
entity nand4b4 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nand4b4;
architecture nand4b4 of nand4b4 is
begin
O <= not(not(I0) and not(I1) and not(I2) and not(I3));
end nand4b4;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor2;
architecture nor2 of nor2 is
begin
O <= not(I0 or I1);
end nor2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor2b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor2b1;
architecture nor2b1 of nor2b1 is
begin
O <= not(not(I0) or I1);
end nor2b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor2b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor2b2;
architecture nor2b2 of nor2b2 is
begin
O <= not(not(I0) or not(I1));
end nor2b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor3;
architecture nor3 of nor3 is
begin
O <= I0 and I1 and I2;
end nor3;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor3b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor3b1;
architecture nor3b1 of nor3b1 is
begin
O <= not(I0) and I1 and I2;
end nor3b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor3b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor3b2;
architecture nor3b2 of nor3b2 is
begin
O <= not(I0) and not(I1) and I2;
end nor3b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor3b3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor3b3;
architecture nor3b3 of nor3b3 is
begin
O <= not(I0) and not(I1) and not(I2);
end nor3b3;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor4 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor4;
architecture nor4 of nor4 is
begin
O <= not(I0 or I1 or I2 or I3);
end nor4;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor4b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor4b1;
architecture nor4b1 of nor4b1 is
begin
O <= not(not(I0) or I1 or I2 or I3);
end nor4b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor4b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor4b2;
architecture nor4b2 of nor4b2 is
begin
O <= not(not(I0) or not(I1) or I2 or I3);
end nor4b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor4b3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor4b3;
architecture nor4b3 of nor4b3 is
begin
O <= not(not(I0) or not(I1) or not(I2) or I3);
end nor4b3;


library IEEE;
use IEEE.std_logic_1164.all;
entity nor4b4 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end nor4b4;
architecture nor4b4 of nor4b4 is
begin
O <= not(not(I0) or not(I1) or not(I2) or not(I3));
end nor4b4;


library IEEE;
use IEEE.std_logic_1164.all;
entity or2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or2;
architecture or2 of or2 is
begin
O <= I0 or I1;
end or2;


library IEEE;
use IEEE.std_logic_1164.all;
entity or2b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or2b1;
architecture or2b1 of or2b1 is
begin
O <= not(I0) or I1;
end or2b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity or2b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or2b2;
architecture or2b2 of or2b2 is
begin
O <= not(I0) or not(I1);
end or2b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity or3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or3;
architecture or3 of or3 is
begin
O <= I0 or I1 or I2;
end or3;


library IEEE;
use IEEE.std_logic_1164.all;
entity or3b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or3b1;
architecture or3b1 of or3b1 is
begin
O <= not(I0) or I1 or I2;
end or3b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity or3b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or3b2;
architecture or3b2 of or3b2 is
begin
O <= not(I0) or not(I1) or I2;
end or3b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity or3b3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or3b3;
architecture or3b3 of or3b3 is
begin
O <= not(I0) or not(I1) or not(I2);
end or3b3;


library IEEE;
use IEEE.std_logic_1164.all;
entity or4 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or4;
architecture or4 of or4 is
begin
O <= I0 or I1 or I2 or I3;
end or4;


library IEEE;
use IEEE.std_logic_1164.all;
entity or4b1 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or4b1;
architecture or4b1 of or4b1 is
begin
O <= not(I0) or I1 or I2 or I3;
end or4b1;


library IEEE;
use IEEE.std_logic_1164.all;
entity or4b2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or4b2;
architecture or4b2 of or4b2 is
begin
O <= not(I0) or not(I1) or I2 or I3;
end or4b2;


library IEEE;
use IEEE.std_logic_1164.all;
entity or4b3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or4b3;
architecture or4b3 of or4b3 is
begin
O <= not(I0) or not(I1) or not(I2) or I3;
end or4b3;


library IEEE;
use IEEE.std_logic_1164.all;
entity or4b4 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       I3 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end or4b4;
architecture or4b4 of or4b4 is
begin
O <= not(I0) or not(I1) or not(I2) or not(I3);
end or4b4;


library IEEE;
use IEEE.std_logic_1164.all;
entity xnor2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end xnor2;
architecture xnor2 of xnor2 is
begin
O <= not(I0 xor I1);
end xnor2;


library IEEE;
use IEEE.std_logic_1164.all;
entity xnor3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end xnor3;
architecture xnor3 of xnor3 is
begin
O <= not(I0 xor I1 xor I2);
end xnor3;


library IEEE;
use IEEE.std_logic_1164.all;
entity xor2 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end xor2;
architecture xor2 of xor2 is
begin
O <= I0 xor I1;
end xor2;


library IEEE;
use IEEE.std_logic_1164.all;
entity xor3 is
  port(
       I0 : in STD_LOGIC;
       I1 : in STD_LOGIC;
       I2 : in STD_LOGIC;
       O : out STD_LOGIC
  );
end xor3;
architecture xor3 of xor3 is
begin
O <= I0 xor I1 xor I2;
end xor3;
