/*------------------------------------------------------------------------
--                                                                      --
-- Copyright (c) 1997 - 2009 Aldec, Inc.  All rights reserved.          --
--                                                                      --
-- This source file may be used and distributed without restriction     --
-- provided that this copyright statement is not removed from the file  --
-- and that any derivative work contains this copyright notice.         --
--                                                                      --
--                       						--
--                                                                      --
--                                                                      --
--                                                                      --
--                                                                      --
--                                                                      --
------------------------------------------------------------------------*/ 

`timescale 1ps / 1ps
module and2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = I0 & I1;
endmodule 


`timescale 1ps / 1ps
module and2b1 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(I0) & I1;
endmodule 


`timescale 1ps / 1ps
module and2b2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(I0) & ~(I1);
endmodule 


`timescale 1ps / 1ps
module and3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = I0 & I1 & I2;
endmodule 


`timescale 1ps / 1ps
module and3b1 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) & I1 & I2;
endmodule 


`timescale 1ps / 1ps
module and3b2 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) & ~(I1) & I2;
endmodule 


`timescale 1ps / 1ps
module and3b3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) & ~(I1) & ~(I2);
endmodule 


`timescale 1ps / 1ps
module and4 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = I0 & I1 & I2 & I3;
endmodule 


`timescale 1ps / 1ps
module and4b1 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0) & I1 & I2 & I3;
endmodule 


`timescale 1ps / 1ps
module and4b2 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0) & ~(I1) & I2 & I3;
endmodule 


`timescale 1ps / 1ps
module and4b3 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0) & ~(I1) & ~(I2) & I3;
endmodule 


`timescale 1ps / 1ps
module and4b4 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0) & ~(I1) & ~(I2) & ~(I3);
endmodule 


`timescale 1ps / 1ps
module \buf  (I,O) ;
input I;
wire I;
output O;
wire O;
assign O = I;
endmodule 


`timescale 1ps / 1ps
module buft (I,T,O) ;
input I;
wire I;
input T;
wire T;
output O;
wire O;
assign O = T ? I : 1'bZ;
endmodule 


`timescale 1ps / 1ps
module inv (I,O) ;
input I;
wire I;
output O;
wire O;
assign O = ~(I);
endmodule 


`timescale 1ps / 1ps
module m2_1 (D0,D1,S0,O) ;
input D0;
wire D0;
input D1;
wire D1;
input S0;
wire S0;
output O;
wire O;
assign O = S0 ? D1 : D0;
endmodule 


`timescale 1ps / 1ps
module m2_1b1 (D0,D1,S0,O) ;
input D0;
wire D0;
input D1;
wire D1;
input S0;
wire S0;
output O;
wire O;
assign O = S0 ? D1 : ~(D0);
endmodule 


`timescale 1ps / 1ps
module m2_1b2 (D0,D1,S0,O) ;
input D0;
wire D0;
input D1;
wire D1;
input S0;
wire S0;
output O;
wire O;
assign O = S0 ? ~(D1) : ~(D0);
endmodule 


`timescale 1ps / 1ps
module nand2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(I0 & I1);
endmodule 


`timescale 1ps / 1ps
module nand2b1 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(~(I0) & I1);
endmodule 


`timescale 1ps / 1ps
module nand2b2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(~(I0) & ~(I1));
endmodule 


`timescale 1ps / 1ps
module nand3 (I0,I1,I2,O) ;

input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;


assign O = ~(I0 & I1 & I2);


endmodule 


`timescale 1ps / 1ps
module nand3b1 (I0,I1,I2,O) ;

input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(~(I0) & I1 & I2);
endmodule 


`timescale 1ps / 1ps
module nand3b2 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(~(I0) & ~(I1) & I2);
endmodule 


`timescale 1ps / 1ps
module nand3b3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(~(I0) & ~(I1) & ~(I2));
endmodule 


`timescale 1ps / 1ps
module nand4 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0 & I1 & I2 & I3);
endmodule 


`timescale 1ps / 1ps
module nand4b1 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(~(I0) & I1 & I2 & I3);
endmodule 


`timescale 1ps / 1ps
module nand4b2 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(~(I0) & ~(I1) & I2 & I3);
endmodule 


`timescale 1ps / 1ps
module nand4b3 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(~(I0) & ~(I1) & ~(I2) & I3);
endmodule 


`timescale 1ps / 1ps
module nand4b4 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(~(I0) & ~(I1) & ~(I2) & ~(I3));
endmodule 


`timescale 1ps / 1ps
module nor2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(I0 | I1);
endmodule 


`timescale 1ps / 1ps
module nor2b1 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(~(I0) | I1);
endmodule 


`timescale 1ps / 1ps
module nor2b2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(~(I0) | ~(I1));
endmodule 


`timescale 1ps / 1ps
module nor3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = I0 & I1 & I2;
endmodule 


`timescale 1ps / 1ps
module nor3b1 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) & I1 & I2;
endmodule 


`timescale 1ps / 1ps
module nor3b2 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) & ~(I1) & I2;
endmodule 


`timescale 1ps / 1ps
module nor3b3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) & ~(I1) & ~(I2);
endmodule 


`timescale 1ps / 1ps
module nor4 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0 | I1 | I2 | I3);
endmodule 


`timescale 1ps / 1ps
module nor4b1 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(~(I0) | I1 | I2 | I3);
endmodule 


`timescale 1ps / 1ps
module nor4b2 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(~(I0) | ~(I1) | I2 | I3);
endmodule 


`timescale 1ps / 1ps
module nor4b3 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(~(I0) | ~(I1) | ~(I2) | I3);
endmodule 


`timescale 1ps / 1ps
module nor4b4 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(~(I0) | ~(I1) | ~(I2) | ~(I3));
endmodule 


`timescale 1ps / 1ps
module or2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = I0 | I1;
endmodule 


`timescale 1ps / 1ps
module or2b1 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(I0) | I1;
endmodule 


`timescale 1ps / 1ps
module or2b2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(I0) | ~(I1);
endmodule 


`timescale 1ps / 1ps
module or3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = I0 | I1 | I2;
endmodule 


`timescale 1ps / 1ps
module or3b1 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) | I1 | I2;
endmodule 


`timescale 1ps / 1ps
module or3b2 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) | ~(I1) | I2;
endmodule 


`timescale 1ps / 1ps
module or3b3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0) | ~(I1) | ~(I2);
endmodule 


`timescale 1ps / 1ps
module or4 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = I0 | I1 | I2 | I3;
endmodule 


`timescale 1ps / 1ps
module or4b1 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0) | I1 | I2 | I3;
endmodule 


`timescale 1ps / 1ps
module or4b2 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0) | ~(I1) | I2 | I3;
endmodule 


`timescale 1ps / 1ps
module or4b3 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0) | ~(I1) | ~(I2) | I3;
endmodule 


`timescale 1ps / 1ps
module or4b4 (I0,I1,I2,I3,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
input I3;
wire I3;
output O;
wire O;
assign O = ~(I0) | ~(I1) | ~(I2) | ~(I3);
endmodule 


`timescale 1ps / 1ps
module xnor2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = ~(I0 ^ I1);
endmodule 


`timescale 1ps / 1ps
module xnor3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = ~(I0 ^ I1 ^ I2);
endmodule 


`timescale 1ps / 1ps
module xor2 (I0,I1,O) ;
input I0;
wire I0;
input I1;
wire I1;
output O;
wire O;
assign O = I0 ^ I1;
endmodule 


`timescale 1ps / 1ps
module xor3 (I0,I1,I2,O) ;
input I0;
wire I0;
input I1;
wire I1;
input I2;
wire I2;
output O;
wire O;
assign O = I0 ^ I1 ^ I2;
endmodule 
