% ALD_SET_PARAM   Set the HDL Black-Box and Active-HDL Co-Sim block parameter
% values.
% 
%
%   Syntax:
%      ald_set_param(block, 'object', '<object_name>', 'param', value, ...)
%      ald_set_param(block, 'param', value, ...)
%      ald_set_param(block, 'struct', value)
%
%
%   Description:
%      ald_set_param(block, 'object', '<object_name>', 'param', value) sets
%      the parameter value of the specified HDL Black-Box.
%      Function parameters:
%         block       - The handle to HDL Black-Box (gcb function is
%                       supported).
%         object      - The object type for which a scalar block
%                       parameter is set ('Port', 'Param' or 'Wave').
%         object_name - The name of the object for which a scalar block
%                       parameter is set.
%         param       - The block parameter name.
%         value       - The value of parameter.
%                
%      ald_set_param(block, 'param') sets the 'param' paremeter value of 
%      the Active-HDL Co-Sim block specified by block handle. 
%
%      ald_set_param(block, 'struct') passes to block the structure holding
%      set of parameters specified by 'struct' function parameter. The block
%      handle specifies the Active-HDL Co-Sim block or HDL Black-Box.
%      Available structures for Active-HDL Co-Sim block and parameters held
%      within each structure:
%         General - 'HDLPeriod', 'HDLUnit', 'SimTimeEQ', 'SimPeriod',
%                   'SimUnit', 'HDLAutoRes', 'HDLRes', 'HDLResUnit',
%                   'DebugMode', 'SimAutoStart', 'MetaX', 'MetaZ'
%         Script  - 'ScriptPreInit', 'ScriptAsim', 'ScriptPostInit',
%                   'ScriptPostSim'
%         Wave    - 'WaveFN', 'CreateASDB', 'ASDBRefrSimTime',
%                   'ASDBRefrPeriod', 'ASDBRefrUnit', 'OffLineSim',
%                   'OffLineSimFN'
%      Available structures for HDL Black-Box and parameters held
%      within each structure:
%         Ports   - 'PortName', 'PortHDLType', 'PortMode', 'PortCast',
%                   'PortSize', 'PortPoint', 'PortPointExpr', 'PortQuant',
%                   'PortOvf', 'PortBreak', 'PortSampling',
%                   'PortMultiRate', 'PortAddToWave'
%         Params  - 'ParamName', 'ParamType', 'ParamDefVal', 'ParamActVal'
%         Clocks  - 'PortName', 'ClockPeriod', 'ClockOffset', 'ClockDuty'
%         Syncs   - 'PortName', 'SyncRefClk', 'ClkPerSync', 'SyncOffset',
%                   'SyncActive'
%         Stims   - 'PortName', 'CustomFormula'
%         Waves   - 'WaveName', 'WaveHeight', 'WaveColor', 'WaveFormat',
%                   'WaveNotation', 'WaveRadix', 'WaveMin', 'WaveMax',
%                   'WaveUserArgs'
%         Sources - 'FileName'
%           
%    Examples:
%       %Modifying settings of all ports:
%       ports_temp = ald_get_param(gcb,'ports');
%       for i=1:1:(size(ports_temp,2)) ports_temp(1,i).PortPointExpr = '3'; end;
%       for i=1:1:(size(ports_temp,2)) ports_temp(1,i).PortOvf = 'Error'; end;
%       ald_set_param(gcb,'ports',ports_temp);
%
%       %Examining and modifying the script commands settings for Active-HDL 
%       % Co-Sim block:
%       settings = ald_get_param(gcb,'script');
%       settings.ScriptPreInit = 'echo compiling glbl.v file\nacom $aldec/dat/glbl.v\n';
%       ald_set_param(gcb,'script',settings);
%
%       %Selecting and configuring the clock port:
%       ald_set_param(gcb,'port','clk','PortMode','Clock','ClockPeriod','2','ClockDuty','0.3');
%
%    See also: ALD_GET_PARAM.
%
%
% Copyright  2008 Aldec, Inc.
% All rights reserved.

