% ALD_GET_PARAM   Get the HDL Black-Box and Active-HDL Co-Sim block parameter
% values.
% 
%
%   Syntax:
%      ald_get_param(block, 'object', '<object_name>', 'param')
%      ald_get_param(block, 'param')
%      ald_get_param(block, 'struct')
%
%
%   Description:
%      ald_get_param(block, 'object', '<object_name>', 'param') returns the
%      parameter value of the specified HDL Black-Box.
%      Function parameters:
%         block       - The handle to HDL Black-Box (gcb function is
%                       supported).
%         object      - The object type for which a scalar block
%                       parameter is obtained ('Port', 'Param' or 'Wave').
%         object_name - The name of the object for which a scalar block
%                       parameter is obtained.
%         param       - The block parameter name.
%                
%      ald_get_param(block, 'param') returns the 'param' paremeter value of 
%      the Active-HDL Co-Sim block specified by block handle. 
%
%      ald_get_param(block, 'struct') returns the structure holding set of
%      parameters specified by 'struct' function parameter. The block
%      handle specifies the Active-HDL Co-Sim block or HDL Black-Box.
%      Available structures for Active-HDL Co-Sim block and parameters held
%      within each structure:
%         General - 'HDLPeriod', 'HDLUnit', 'SimTimeEQ', 'SimPeriod',
%                   'SimUnit', 'HDLAutoRes', 'HDLRes', 'HDLResUnit',
%                   'DebugMode', 'SimAutoStart', 'MetaX', 'MetaZ'
%         Script  - 'ScriptPreInit', 'ScriptAsim', 'ScriptPostInit',
%                   'ScriptPostSim'
%         Wave    - 'WaveFN', 'CreateASDB', 'ASDBRefrSimTime',
%                   'ASDBRefrPeriod', 'ASDBRefrUnit', 'OffLineSim',
%                   'OffLineSimFN'
%      Available structures for HDL Black-Box and parameters held
%      within each structure:
%         Ports   - 'PortName', 'PortHDLType', 'PortMode', 'PortCast',
%                   'PortSize', 'PortPoint', 'PortPointExpr', 'PortQuant',
%                   'PortOvf', 'PortBreak', 'PortSampling',
%                   'PortMultiRate', 'PortAddToWave'
%         Params  - 'ParamName', 'ParamType', 'ParamDefVal', 'ParamActVal'
%         Clocks  - 'PortName', 'ClockPeriod', 'ClockOffset', 'ClockDuty'
%         Syncs   - 'PortName', 'SyncRefClk', 'ClkPerSync', 'SyncOffset',
%                   'SyncActive'
%         Stims   - 'PortName', 'CustomFormula'
%         Waves   - 'WaveName', 'WaveHeight', 'WaveColor', 'WaveFormat',
%                   'WaveNotation', 'WaveRadix', 'WaveMin', 'WaveMax',
%                   'WaveUserArgs'
%         Sources - 'FileName'
%      The 'ObjectParameters' keyword can be used to get names of all
%      parameters.
%           
%    Examples:
%       %Examining the settings of the 'Iout' port:
%       s = ald_get_param(gcb,'ports','Iout')
%     
%       %Examining the waveform settings for all added objects:
%       s = ald_get_param(gcb,'waves')
%
%       %Examining notation selected in waveform for 'Iout' port:
%       p = ald_get_param(gcb,'wave','Iout','WaveNotation')
%   
%       %Examining overflow handling setting of the 'Qout' port:
%       p = ald_get_param(gcb,'port','Qout','PortOvf')
%
%
%    See also: ALD_SET_PARAM.
%
%
% Copyright  2008 Aldec, Inc.
% All rights reserved.

