%ALD_CONVERT   Convert number to fixed-point vector or fixed-point vector
%              to number.
%
%   Syntax:
%      ald_convert(v_b)
%      ald_convert(v_b, s)
%      ald_convert(v_b, s, p)
%      ald_convert(v_d)
%      ald_convert(v_d, s)
%      ald_convert(v_d, s, w)
%      ald_convert(v_d, s, w, p)
%      ald_convert(v_d, s, w, p, RoundMode)
%      ald_convert(v_d, s, w, p, RoundMode, OverflowMode)
%      ald_convert(..., property1, value1, ...)
%      ald_convert(ConvType, value, property1, value1, ...)
%
%
%   Description:
%      ald_convert(v_b) returns a decimal value of binary vector 
%      v_b with binary point 0 and signed two's complement notation. 
%      The input binary vector can be specified as string representing 
%      binary or hexadecimal number (indicated by starting 0x). 
%      Optionally it can be specified as a vector of double numbers with 
%      each number equal to 0 or 1, assuming MSB has index 1.
%      
%      ald_convert(v_b, s) returns a decimal value of binary vector v_b 
%      with signedness s and binary point 0. If s is equal 0 (false),  
%      unsigned notation is assumed. If s is equal 1 (true), signed two's
%      complement notation is assumed.
%      
%      ald_convert(v_b, s, p) returns a decimal value of binary vector v_b 
%      with signedness s and binary point p. Negative values of binary
%      point as well as values exceeding vector length are allowed.
%
%      ald_convert(v_d) returns a structure describing signed binary vector 
%      representing decimal value v_d with binary point 0, 16-bit word 
%      length, rounding mode set to 'round' and overflow handling set 
%      to 'saturate'. Input argument v_d can be specified as any valid
%      expression which returns non-complex decimal number.
%      Returned structure contains following fields: 
%         BinaryValue - result in binary format, 
%         HexadecimalValue - result in hexadecimal format,
%         DecimalValue - decimal value v_d, 
%         QuantError - quantization error,
%         Saturated - 1 if result is saturated, 0 if not. 
%      Field 'Saturated' is set to 1 only if 'OverflowMode' property was 
%      set to 'saturate' and input argument value exceeds the range of
%      values available for specified binary representation.
%      
%      ald_convert(v_d, s) returns a structure describing binary vector
%      with decimal value v_d, signedness s, binary point 0, 16-bit word 
%      length, rounding mode set to 'round' and overflow handling set to
%      'saturate'.
%      
%      ald_convert(v_d, s, w) returns a structure describing binary vector 
%      with decimal value v_d, signedness s, word length w, binary point 0, 
%      rounding mode set to 'round' and overflow handling set to
%      'saturate'. 
%
%      ald_convert(v_d, s, w, p) returns a structure describing binary
%      vector with decimal value v_d, signedness s, word length w, binary
%      point p, rounding mode set to 'round' and overflow handling set
%      to 'saturate'.
%
%      ald_convert(v_d, s, w, p, RoundMode) returns a binary vector with
%      decimal value v_d, signedness s, word length w, binary point p,
%      rounding mode set to RoundMode ('round', 'nearest', or 'truncate')
%      and overflow handling set to 'saturate'.
%      
%      ald_convert(v_d, s, w, p, RoundMode, OverflowMode) returns a
%      structure describing binary vector with decimal value v_d,
%      signedness s, word length w, binary point p, rounding mode set to
%      RoundMode ('round', 'nearest' or 'truncate'), and overflow handling
%      set to OverflowMode ('saturate', 'wrap' or 'error').
%
%      ald_convert(..., property1, value1, ...) and 
%      ald_convert(ConvType, value, property1, value1, ...) allow you to
%      configure ald_convert function using property name/property value
%      pairs. ConvType should be set to 'b2d' for binary to decimal
%      conversion or to 'd2b' for decimal to binary conversion.
%
%
%   Properties:
%
%      Signed         - Specifies whether input argument is signed or 
%                       unsigned (1 or 0). The default value of this 
%                       property is 1.
%      Point          - Specifies the position of binary point in converted 
%                       binary vector. The default value of this property
%                       is 0.
%      Width          - Word length of binary vector. The default value 
%                       of this property is 16. Allowed only for decimal to
%                       binary conversion ('d2b' is used as ConvType).
%      RoundMode      - Round mode can be set as 'round', 'nearest' or
%                       'truncate'. The default value of this property is
%                       'round'. Allowed only for decimal to binary
%                       conversion ('d2b' is used as ConvType). 
%      OverflowMode   - Overflow mode can be set to 'wrap', 'saturate'
%                       or 'error'. The default value of this property is 
%                       'saturate'. Allowed only for decimal to binary
%                       conversion ('d2b' is used as ConvType).
%
%   Examples:
%      %Signed binary to decimal conversion with binary point 2.
%      a = ald_convert('b2d',[0 1 1],'signed',1,'point',2);
%      a = ald_convert('b2d','011','signed',1,'point',2);
%      a = ald_convert('0x3',1,2);
%
%      %Signed decimal to binary conversion with word length 8 and
%      %binary point 2.
%      a = ald_convert('d2b',4.25,'signed',1,'point',1,'width',8);
%      a = ald_convert(4.25,1,8,1);
%
%      %Signed decimal to binary conversion with word length 8,
%      %binary point 1 and round mode set to 'round' and overflow handling
%      %set to saturate.
%      a = ald_convert(4.25,1,8,1,'round','saturate');
%
%      %Signed decimal to binary conversion with word length 8,
%      %binary point 1 and overflow mode set as error.
%      a = ald_convert('d2b',4.25,'signed',1,'point',1,...
%                      'width',8,'overflowmode','error');
%
%
% Copyright  2008 Aldec, Inc.
% All rights reserved.
