% ALD_UPDATEMODEL   Update Active-HDL Co-Simulation Interface blocks.
% 
%
%   Syntax:
%      ald_UpdateModel
%      ald_UpdateModel('system')
%
%
%   Description:
%      ald_UpdateModel updates all blocks coming from Active-HDL Blockset
%      instantiated on current Simulink model to current version of
%      blockset and returns the update status:   
%         0 - diagram is not updated (no recognizable block found)
%         1 - diagram is updated successfully (all recognized blocks updated)
%         2 - diagram is updated partially (some of recognized blocks require
%         manual update)
%      In case of partial update, links to blocks requiring manual update
%      are displayed. Clicking the link opens block parameters dialog 
%      box and allows manual update by pressing OK button and following
%      further instructions.
%
%      ald_UpdateModel('system') updates all blocks coming from Active-HDL
%      Blockset instantiated on Simulink model, where 'system' is model
%      file (*.mdl) path name, specified without file extension.
%    
%
% Copyright  2008 Aldec, Inc.
% All rights reserved.

