#ifndef ALDECPLI_H
#define ALDECPLI_H

#include "acc_user.h"

/*------------- values for component 'type' in s_tfcell structure -------------*/
#define usertask                  1
#define USERTASK                  usertask
#define userfunction              2
#define USERFUNCTION              userfunction
#define userrealfunction          3
#define USERREALFUNCTION          userrealfunction

/*----------------- structure used for the veriusertfs array ----------------*/
typedef struct t_tfcell
{
	short   type;
	int     data;
	int     (*checktf)();
	int     (*sizetf)();
	int     (*calltf)();
	int     (*misctf)();
	char*   tfname;

	/* The following fields are ignored */
	int     forwref;
	char    *tfveritool;
	char    *tferrmessage;
	int     hash;
	struct  t_tfcell *left_p;
	struct  t_tfcell *right_p;
	char    *namecell_p;
	int     warning_printed;
} s_tfcell, *p_tfcell;

#define reason_endsim       100
#define REASON_ENDSIM       reason_endsim
#define VERILOG_OBJECT      0
#define VHDL_OBJECT         1
#define EDIF_OBJECT         2

#if defined(__STDC__) || defined(__cplusplus)

	#ifndef PROTO_PARAMS
		#define PROTO_PARAMS(params) params
		#define DEFINED_PROTO_PARAMS
	#endif
	#ifndef EXTERN
		#define EXTERN
		#define DEFINED_EXTERN
	#endif

#else

	#ifndef PROTO_PARAMS
		#define PROTO_PARAMS(params) params
		#define DEFINED_PROTO_PARAMS
	#endif
	#ifndef EXTERN
		#define EXTERN extern
		#define DEFINED_EXTERN
	#endif

#endif /* __STDC__ */

#define accVhdlArchitecture		1010
#define accBlock				1020
#define accGenerate				1030
#define accPackage				1040
#define accConfiguration		1050
#define accEdifUnit				2000

#define accMemory				3000
#define accMemoryWord			3001

#define vpiVhdlArchitecture		accVhdlArchitecture

#ifdef __cplusplus
extern "C"
{
#endif

#if defined(_MSC_VER)
    typedef __int64 long_int;
#else
    typedef long long int long_int;
#endif

#define KP_HASSERT void*

	EXTERN KP_HASSERT pli_GetNextAssert (KP_HASSERT _handle);

	EXTERN     handle acc_next_generate_block PROTO_PARAMS( (handle mod, handle child, char **_path) );
	EXTERN char* acc_name_from_elb(handle _obj, bool _foolpath /*= false*/);
	EXTERN int set_pli_context(void* _call_instance, char* name);
	EXTERN int free_pli_context();
	EXTERN void pli_GetAssertInfoEx (KP_HASSERT hassert,
										char** name,
										char** path,
										char** source,
										int* line,
										char** library,
										char** _type );

	EXTERN void pli_SetFsdbCallBackDumpOVA_scopePath(int level, const char *_scope, void * _action);
	EXTERN void pli_SetFsdbCallBackDumpOVA_scopeHandle(int level, void *_scope, void * _action);
	EXTERN void pli_fsdbDumpOVAon();
	EXTERN void pli_fsdbDumpOVAoff();

	EXTERN void pli_SetFsdbCallBackDumpPSL_scopePath(int level, const char *_scope, void * _action);
	EXTERN void pli_SetFsdbCallBackDumpPSL_scopeHandle(int level, void *_scope, void * _action);
	EXTERN void pli_fsdbDumpPSLon();
	EXTERN void pli_fsdbDumpPSLoff();

	EXTERN void pli_SetFsdbCallBackDumpSVA_scopePath(int level, const char *_scope, void * _action);
	EXTERN void pli_SetFsdbCallBackDumpSVA_scopeHandle(int level, void *_scope, void * _action);
	EXTERN void pli_fsdbDumpSVAon();
	EXTERN void pli_fsdbDumpSVAoff();

	EXTERN void* pli_get_slp_signal_handle(handle);
	EXTERN bool pli_is_access_read(handle sig);

	EXTERN const char* pli_ComponentGetHierarchy(handle obj, char* _spliter);
	EXTERN bool pli_registertf PROTO_PARAMS((p_tfcell usertf));
	EXTERN void* pli_memory PROTO_PARAMS((int pnum, int* msb, int* lsb, int* first, int* last));
	EXTERN long_int pli_gettimeresolution();
	EXTERN int pli_gettimeformatwidth();
	EXTERN const char* pli_getsearchpaths();
	EXTERN int pli_loadsdf(void* sdfdata,int sdfdataCount);
#ifdef __cplusplus
	EXTERN int pli_trace_signal(void* signal, const char* name);
	EXTERN int pli_trace_signals_from_module(void* modinst, int level, int flags);
	EXTERN int pli_trace_commit();
	EXTERN void pli_trace_off();
	EXTERN void pli_trace_on();
	EXTERN int pli_force_signal(int ForceKind,void* Signal,const char* formula,const char* szSignalName);
	EXTERN int pli_noforce_signal(void* Signal, const char* szSignalName);
	EXTERN int vhpi_trace_signal(void* signal, const char* name);
	EXTERN int vhpi_trace_signals_from_module(void* modinst, int level, int flags);
	EXTERN int vhpi_force_signal(int ForceKind,void* Signal,const char* formula,const char* szSignalName);
	EXTERN int vhpi_noforce_signal(void* Signal, const char* szSignalName);
#endif
	EXTERN char pli_gethierarchyseparator();
	EXTERN const char* pli_convert_to_expanded_path(const char* path);
	EXTERN int pli_set_memory_word(int pnum, int word_idx, p_setval_value setval_p, p_setval_delay delay_p);
	EXTERN const char* pli_fetch_paramval_binstr(handle param);
	EXTERN int pli_countdrivers(handle net, int param_cnt, int *params);
	EXTERN handle pli_get_whole_memory(handle memword);
	EXTERN bool pli_is_verilog();
	EXTERN bool pli_is_vhdl();
	EXTERN char* acc_fetch_type_description(handle);
	EXTERN char* acc_fetch_init_value(handle);
	EXTERN int pli_hdl_of_object(handle);
	EXTERN handle pli_get_handle_by_name(const char*);
	EXTERN const char* pli_getenv(const char*);
	EXTERN int pli_memory_is2state PROTO_PARAMS((int pnum));
	EXTERN int pli_is2state(handle);
	EXTERN bool pli_is_vcd_reg(handle);

	EXTERN void pli_disable_cb(handle);
	EXTERN void pli_enable_cb(handle);

#ifdef __cplusplus
}
#endif

#ifdef DEFINED_PROTO_PARAMS
	#undef DEFINED_PROTO_PARAMS
	#undef PROTO_PARAMS
#endif

#ifdef DEFINED_EXTERN
	#undef DEFINED_EXTERN
	#undef EXTERN
#endif

#endif // ALDECPLI_H
