#ifndef AHDL_RC_H
#define AHDL_RC_H

#include <windows.h>

#define CMD_BUF_SIZE 1024
#define CMD_QUIT 0x01

#define INSTR_ERR_FLAG		0x80
#define INSTR_IF_INFO		0
#define INSTR_EXECUTE		1
#define INSTR_EXECUTE_ERR	INSTR_EXECUTE | INSTR_ERR_FLAG
#define INSTR_PRINT_MESSAGE	2
#define INSTR_PRINT_ERROR	3
#define INSTR_PRINT_WARNING	4
#define INSTR_PRINT_EX		5
#define INSTR_SIM_STATUS	6
#define INSTR_PROC_ID		100
#define INSTR_ERR			255
//First and last instruction executed by framework
#define INSTR_EX_FR_MIN INSTR_EXECUTE
#define INSTR_EX_FR_MAX INSTR_SIM_STATUS

//Simulator state
#define VSIM_OFF	0x00
#define VSIM_ON		0x01
#define VSIM_BUSY	0x02

#define BUF_SIZE 32768
#define ITEM_QUEUE_SIZE 8192
#define MAX_VEC_SIZE 16
#define WAVE_TYPE_BUF_SIZE 32
#define MAX_CMD_SIZE 256
#define TX_BUF_FULL BUF_SIZE - MAX_CMD_SIZE

#define IF_OK		0x00000000
#define CMD_EXE_ERR 0x80000000
#define IF_ERR		0x80000001
#define IF_BUSY		0x80000002
#define IF_TIME_OUT 0x80000003


typedef struct t_acc_vecval
{
unsigned int aval;
unsigned int bval;
} s_acc_vecval, *p_acc_vecval;

typedef enum ESignalType {
	LOG_TYPE = 0,
	INT_TYPE,
	FLOAT_TYPE
} ESignalType;

typedef enum ECmdState {
	E_CMD_DOWN = 0,
	E_CMD_IDLE,	
	E_CMD_EXEC,
	E_CMD_RQ_ERR,
	E_CMD_RESP_ERR,
	E_CMD_QUIT
} ECmdState;

typedef struct TSignalInfo {
	int handle;	
	ESignalType type;
	int size;
} TSignalInfo;

typedef struct TSignal {
	char name[128];		
	int pli_handle;	
	int size;			//size of vector	
	int chunks;			//number of 32-bit chunks
	int user;			//Auxilary variable
	s_acc_vecval val[4];
} TSignal;

//Command
//typedef void* TAHDLcmd; 
typedef struct TAHDLcmd {
	bool isConnected;
	ECmdState CmdState;
	int CmdRq;	
	HANDLE hCmdPipe;
	HANDLE hCmdThr;
	HANDLE hEvCmdRq;
	HANDLE hEvDone;
	DWORD dwLastError;
	char rx[CMD_BUF_SIZE];
	char tx[CMD_BUF_SIZE];
	char msg[CMD_BUF_SIZE];
	int rx_cnt;
	int rx_pos;
	int tx_cnt;	
} TAHDLcmd;

//Simulation
//typedef void *TAHDLsim;
typedef struct TAHDLsim {
	HANDLE hPipe;
	HANDLE hEvRq;
	HANDLE hEvDone;
	HANDLE hSimThr;
	ECmdState PostState;
	DWORD dwLastError;
	int PostRq;
	int PostRetVal;
	unsigned char rx[BUF_SIZE];
	unsigned char tx[BUF_SIZE];
	char *items[ITEM_QUEUE_SIZE];	
	int tx_cnt;
	int rx_cnt;
	int rx_pos;	
	int item_cnt;
} TAHDLsim;



//Simulator command functions
int IsCmdChannelPresent(int time_out);
TAHDLcmd* StartAHDLIPC(char *path, int time_out);
TAHDLcmd* OpenCmdChannel();
int CloseCmdChannel(TAHDLcmd *cmd_if);
int Connect(TAHDLcmd *cmd_if);		
int Disconnect(TAHDLcmd *cmd_if);
int TransactRq(TAHDLcmd *cmd_if);
int ExecuteCommand(TAHDLcmd *cmd_if, char *cmd);	
int PostCommand(TAHDLcmd *cmd_if, char *cmd);	
int VaExecuteCommand(TAHDLcmd *cmd_if, char *cmd, ...);		
int PrintMessage(TAHDLcmd *cmd_if, char *msg);
int VaPrintMessage(TAHDLcmd *cmd_if, char *msg, ...);
int PrintWarning(TAHDLcmd *cmd_if, char *msg);
int VaPrintWarning(TAHDLcmd *cmd_if, char *msg, ...);
int PrintError(TAHDLcmd *cmd_if, char *msg);
int VaPrintError(TAHDLcmd *cmd_if, char *msg, ...);
int PrintTranscript(TAHDLcmd *cmd_if);
int GetSimulatorState(TAHDLcmd *cmd_if);
int GetProcessId(TAHDLcmd *cmd_if);
char* GetResponse(TAHDLcmd *cmd_if);

//Simulation functions
TAHDLsim* OpenSimChannel(int pid, int time_out);
int CloseSimChannel(TAHDLsim *sim);
int ExecuteFrame(TAHDLsim *sim);
int PostFrame(TAHDLsim *sim);
int QueueSetDelay(TAHDLsim *sim, __int64 d);
int QueueSetLongDelay(TAHDLsim *sim, __int64 d);
int QueueCalculate(TAHDLsim *sim);
int QueueFetchValue(TAHDLsim *sim, TSignal *signal);
int QueueSetValue(TAHDLsim *sim, TSignal *signal);
int QueueHandleSignal(TAHDLsim *sim, TSignal *signal);
int QueueGetSignal(TAHDLsim *sim, TSignal *signal);
int QueueVersion(TAHDLsim *sim, char **s);
int QueueStop(TAHDLsim *sim);
int QueueProductVersion(TAHDLsim *sim, char **s);
int QueueIfVersion(TAHDLsim *sim, int *v);
int QueueCheckLicense(TAHDLsim *sim, int *v);
int QueueSize(TAHDLsim *sim, TSignal *signal);
DWORD TransferData(TAHDLsim *sim);
	

#endif
