-- ----------------------------------------------------------------------------
Library IEEE;
Use     IEEE.Std_Logic_1164.All;
-- ----------------------------------------------------------------------------


-- ----------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
    Port (
        IO_CYC_I   : In  Std_Logic;
        IO_STB_I   : In  Std_Logic;
        IO_ACK_O   : Out Std_Logic;
        IO_ADR_I   : In  Std_Logic_Vector(11 Downto 0);
        IO_DAT_O   : Out Std_Logic_Vector(31 Downto 0);
        IO_DAT_I   : In  Std_Logic_Vector(31 Downto 0);
        IO_SEL_I   : In  Std_Logic_Vector(3  Downto 0);
        IO_WE_I    : In  Std_Logic;
        IO_CLK_I   : In  Std_Logic;
        IO_RST_I   : In  Std_Logic;

        IO_INT_O   : Out Std_Logic_Vector(2 Downto 0);          
        
        PIXELCLOCK : In  Std_Logic;                             -- ExcludeIf_NotVGA
        PIXELRESET : In  Std_Logic;                             -- ExcludeIf_NotVGA
        R          : Out Std_Logic_Vector(7 Downto 0);          -- ExcludeIf_NotVGA32
        G          : Out Std_Logic_Vector(7 Downto 0);          -- ExcludeIf_NotVGA32
        B          : Out Std_Logic_Vector(7 Downto 0);          -- ExcludeIf_NotVGA32
        HSYNC      : Out Std_Logic;                             -- ExcludeIf_NotVGA
        VSYNC      : Out Std_Logic;                             -- ExcludeIf_NotVGA
        CSYNC      : Out Std_Logic;                             -- ExcludeIf_NotVGA
        BLANK      : Out Std_Logic;                             -- ExcludeIf_NotVGA
        
        R          : Out Std_Logic_Vector(4 Downto 0);          -- ExcludeIf_NotVGA16bpp
        G          : Out Std_Logic_Vector(5 Downto 0);          -- ExcludeIf_NotVGA16bpp
        B          : Out Std_Logic_Vector(4 Downto 0);          -- ExcludeIf_NotVGA16bpp
        
        TFT_RED    : Out Std_Logic_Vector(4 Downto 0);          -- ExcludeIf_NotTFT
        TFT_GREEN  : Out Std_Logic_Vector(5 Downto 0);          -- ExcludeIf_NotTFT
        TFT_BLUE   : Out Std_Logic_Vector(4 Downto 0);          -- ExcludeIf_NotTFT
        TFT_CL     : Out Std_Logic_Vector(3 Downto 1);          -- ExcludeIf_NotTFT
        TFT_DISP_ON : Out Std_Logic;                            -- ExcludeIf_NotTFT
        TFT_M       : Out Std_Logic;                            -- ExcludeIf_NotTFT
        TFT_POL     : Out Std_Logic;                            -- ExcludeIf_NotTFT
        TFT_STH     : Out Std_Logic;                            -- ExcludeIf_NotTFT
        TFT_STV     : Out Std_Logic;                            -- ExcludeIf_NotTFT

        ME_STB_O   : Out Std_Logic;
        ME_CYC_O   : Out Std_Logic;
        ME_ACK_I   : In  Std_Logic;
	ME_ADR_O   : Out Std_Logic_Vector(ReplaceWith_AddressWidth-1 Downto 0);
        ME_DAT_I   : In  Std_Logic_Vector(31 Downto 0);
        ME_SEL_O   : Out Std_Logic_Vector(3  Downto 0);
        ME_WE_O    : Out Std_Logic
    );
End;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of Configurable_ReplaceWith_Designator Is
-- ----------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    Component ReplaceWith_WishboneDisplayDriver Is
        Port (
        WBS_CYC_I : In  Std_Logic;
        WBS_STB_I : In  Std_Logic;
        WBS_ACK_O : Out Std_Logic;
        WBS_ADR_I : In  Std_Logic_Vector(11 Downto 0);
        WBS_DAT_O : Out Std_Logic_Vector(31 Downto 0);
        WBS_DAT_I : In  Std_Logic_Vector(31 Downto 0);
        WBS_SEL_I : In  Std_Logic_Vector(3  Downto 0);
        WBS_WE_I  : In  Std_Logic;
        CLK_I     : In  Std_Logic;
        RST_I     : In  Std_Logic;
        
        INT_O     : Out Std_Logic_Vector(2 Downto 0);           
        
        PIXELCLOCK : In  Std_Logic;                             -- ExcludeIf_NotVGA
        PIXELRESET : In  Std_Logic;                             -- ExcludeIf_NotVGA
        R          : Out Std_Logic_Vector(7 Downto 0);          -- ExcludeIf_NotVGA32
        G          : Out Std_Logic_Vector(7 Downto 0);          -- ExcludeIf_NotVGA32
        B          : Out Std_Logic_Vector(7 Downto 0);          -- ExcludeIf_NotVGA32
        HSYNC      : Out Std_Logic;                             -- ExcludeIf_NotVGA
        VSYNC      : Out Std_Logic;                             -- ExcludeIf_NotVGA
        CSYNC      : Out Std_Logic;                             -- ExcludeIf_NotVGA
        BLANK      : Out Std_Logic;                             -- ExcludeIf_NotVGA
        
        R          : Out Std_Logic_Vector(4 Downto 0);          -- ExcludeIf_NotVGA16bpp
        G          : Out Std_Logic_Vector(5 Downto 0);          -- ExcludeIf_NotVGA16bpp
        B          : Out Std_Logic_Vector(4 Downto 0);          -- ExcludeIf_NotVGA16bpp

        TFT_RED    : Out Std_Logic_Vector(4 Downto 0);          -- ExcludeIf_NotTFT
        TFT_GREEN  : Out Std_Logic_Vector(5 Downto 0);          -- ExcludeIf_NotTFT
        TFT_BLUE   : Out Std_Logic_Vector(4 Downto 0);          -- ExcludeIf_NotTFT
        TFT_CL     : Out Std_Logic_Vector(3 Downto 1);          -- ExcludeIf_NotTFT
        TFT_DISP_ON : Out Std_Logic;                            -- ExcludeIf_NotTFT
        TFT_M       : Out Std_Logic;                            -- ExcludeIf_NotTFT
        TFT_POL     : Out Std_Logic;                            -- ExcludeIf_NotTFT
        TFT_STH     : Out Std_Logic;                            -- ExcludeIf_NotTFT
        TFT_STV     : Out Std_Logic;                            -- ExcludeIf_NotTFT

        WBM_STB_O : Out Std_Logic;
        WBM_CYC_O : Out Std_Logic;
        WBM_ACK_I : In  Std_Logic;
        WBM_ADR_O : Out Std_Logic_Vector(31 Downto 0);
        WBM_DAT_I : In  Std_Logic_Vector(31 Downto 0);
        WBM_SEL_O : Out Std_Logic_Vector(3  Downto 0);
        WBM_WE_O  : Out Std_Logic
        );
    End Component;
    -- ------------------------------------------------------------------------

    Signal ME_ADR_O_Signal : Std_Logic_Vector(31 Downto 0);
-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------

    SubPart_WishboneDisplayDriver : ReplaceWith_WishboneDisplayDriver
    Port Map (
        WBS_CYC_I  => IO_CYC_I,
        WBS_STB_I  => IO_STB_I,  
        WBS_ACK_O  => IO_ACK_O,  
        WBS_ADR_I  => IO_ADR_I,  
        WBS_DAT_O  => IO_DAT_O,  
        WBS_DAT_I  => IO_DAT_I,  
        WBS_SEL_I  => IO_SEL_I,  
        WBS_WE_I   => IO_WE_I,   
        CLK_I      => IO_CLK_I,  
        RST_I      => IO_RST_I,
        INT_O      => IO_INT_O,                                 
                                
        PIXELCLOCK => PIXELCLOCK,                               -- ExcludeIf_NotVGA
        PIXELRESET => PIXELRESET,                               -- ExcludeIf_NotVGA
        R          => R,                                        -- ExcludeIf_NotVGA
        G          => G,                                        -- ExcludeIf_NotVGA
        B          => B,                                        -- ExcludeIf_NotVGA         
        HSYNC      => HSYNC,                                    -- ExcludeIf_NotVGA
        VSYNC      => VSYNC,                                    -- ExcludeIf_NotVGA
        CSYNC      => CSYNC,                                    -- ExcludeIf_NotVGA
        BLANK      => BLANK,                                    -- ExcludeIf_NotVGA
        
        TFT_RED     => TFT_RED,                                 -- ExcludeIf_NotTFT
        TFT_GREEN   => TFT_GREEN,                               -- ExcludeIf_NotTFT
        TFT_BLUE    => TFT_BLUE,                                -- ExcludeIf_NotTFT
        TFT_CL      => TFT_CL,                                  -- ExcludeIf_NotTFT
        TFT_DISP_ON => TFT_DISP_ON,                             -- ExcludeIf_NotTFT
        TFT_M       => TFT_M,                                   -- ExcludeIf_NotTFT 
        TFT_POL     => TFT_POL,                                 -- ExcludeIf_NotTFT
        TFT_STH     => TFT_STH,                                 -- ExcludeIf_NotTFT
        TFT_STV     => TFT_STV,                                 -- ExcludeIf_NotTFT
        
        WBM_STB_O  => ME_STB_O,  
        WBM_CYC_O  => ME_CYC_O,  
        WBM_ACK_I  => ME_ACK_I,  
        WBM_ADR_O  => ME_ADR_O_Signal,  
        WBM_DAT_I  => ME_DAT_I,  
        WBM_SEL_O  => ME_SEL_O,  
        WBM_WE_O   => ME_WE_O
    );

    ME_ADR_O <= ME_ADR_O_Signal(ReplaceWith_AddressWidth-1 Downto 0);

-- ----------------------------------------------------------------------------
End RTL;
-- ----------------------------------------------------------------------------
