-- ----------------------------------------------------------------------------
Library IEEE;
Use     IEEE.Std_Logic_1164.All;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Entity ReplaceWith_EntityName Is
    Port (
        CLK_BASE : In  Std_Logic;
        WS       : Out Std_Logic;
        ADCK     : Out Std_Logic;
        SCK      : Out Std_Logic;
        STB_I    : In  Std_Logic;
        CYC_I    : In  Std_Logic;
        ACK_O    : Out Std_Logic;
        ADR_I    : In  Std_Logic_Vector(1 Downto 0);
        DAT_O    : Out Std_Logic_Vector(31 Downto 0);
        DAT_I    : In  Std_Logic_Vector(31 Downto 0);
        WE_I     : In  Std_Logic;
        CLK_I    : In  Std_Logic;
        SDO      : Out Std_Logic;                       --IncludeIf_TXEnabled
        SDI      : In  Std_Logic;                       --IncludeIf_RXEnabled
        INT_O    : Out Std_Logic;                       --IncludeIf_BufferDisabled
        RST_I    : In  Std_Logic
    );
End ReplaceWith_EntityName;
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
Architecture RTL Of ReplaceWith_EntityName Is
-- ----------------------------------------------------------------------------
    Component I2S_W Is
    Port (
        ACK_O    : Out   STD_LOGIC;
        ADCK     : Out   STD_LOGIC;
        ADR_I    : In    STD_LOGIC_VECTOR(1 Downto 0);
        CLK_BASE : In    STD_LOGIC;
        CLK_I    : In    STD_LOGIC;
        CYC_I    : In    STD_LOGIC;
        DAT_I    : In    STD_LOGIC_VECTOR(31 Downto 0);
        DAT_O    : Out   STD_LOGIC_VECTOR(31 Downto 0);
        INT_O    : Out   STD_LOGIC;
        RST_I    : In    STD_LOGIC;
        SCK      : Out   STD_LOGIC;
        SDI      : In    STD_LOGIC;
        SDO      : Out   STD_LOGIC;
        STB_I    : In    STD_LOGIC;
        WE_I     : In    STD_LOGIC;
        WS       : Out   STD_LOGIC
    );
    End Component;

    Signal Sdi_Signal       : Std_Logic;
    Signal Sdo_Signal       : Std_Logic;
    Signal Interrupt_Signal : Std_Logic;
-- ----------------------------------------------------------------------------
Begin
-- ----------------------------------------------------------------------------

U_I2S: I2S_W Port Map (
    ACK_O    => ACK_O,
    ADCK     => ADCK,
    ADR_I    => ADR_I,
    CLK_BASE => CLK_BASE,
    CLK_I    => CLK_I,
    CYC_I    => CYC_I,
    DAT_I    => DAT_I,
    DAT_O    => DAT_O,
    INT_O    => Interrupt_Signal,
    RST_I    => RST_I,
    SCK      => SCK,
    SDI      => Sdi_Signal,
    SDO      => Sdo_Signal,
    STB_I    => STB_I,
    WE_I     => WE_I,
    WS       => WS
);
SDO        <= Sdo_Signal;        --IncludeIf_TXEnabled
Sdi_Signal <= SDI;               --IncludeIf_RXEnabled
Sdi_Signal <= '0';               --IncludeIf_RXDisabled
INT_O      <= Interrupt_Signal;  --IncludeIf_BufferDisabled
-- ----------------------------------------------------------------------------
End;
-- ----------------------------------------------------------------------------

