--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.All;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity %EntityName% Is
  Port(
        ACK_O : out STD_LOGIC;
        ADR_I : In  Std_Logic_Vector(2 Downto 0); -- IncludeIfAdrPortCount8
        ADR_I : in  STD_LOGIC_VECTOR(1 downto 0); -- IncludeIfAdrPortCount4
        ADR_I : in  STD_LOGIC;                    -- IncludeIfAdrPortCount2
        CLK_I : in  STD_LOGIC;
        CYC_I : in  STD_LOGIC;
        DAT_I : in  STD_LOGIC_VECTOR(%BusWidth%);
        DAT_O : out STD_LOGIC_VECTOR(%BusWidth%); -- ExcludeIfPortKindOutput
        PAI   : in  STD_LOGIC_VECTOR(%BusWidth%); -- ExcludeIfPortKindOutput
        PAO   : out STD_LOGIC_VECTOR(%BusWidth%);
        TRISA : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortKindTristate
        PBI   : in  STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount2 IncludeIfPortCount4 ExcludeIfPortKindOutput
        PBO   : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount2 IncludeIfPortCount4
        TRISB : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount2 IncludeIfPortCount4 IncludeIfPortKindTristate
        PCI   : in  STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4                     ExcludeIfPortKindOutput
        PCO   : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4
        TRISC : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4                     IncludeIfPortKindTristate
        PDI   : in  STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4                     ExcludeIfPortKindOutput
        PDO   : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4
        TRISD : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4                     IncludeIfPortKindTristate
        RST_I : in  STD_LOGIC;
        STB_I : in  STD_LOGIC;
        WE_I  : in  STD_LOGIC
      );
End %EntityName%;

Architecture RTL Of %EntityName% Is
   Component %ChildModel%
      port
      (
        ACK_O : out STD_LOGIC;
        ADR_I : In  Std_Logic_Vector(2 Downto 0); -- IncludeIfAdrPortCount8
        ADR_I : in  STD_LOGIC_VECTOR(1 downto 0); -- IncludeIfAdrPortCount4
        ADR_I : in  STD_LOGIC;                    -- IncludeIfAdrPortCount2
        CLK_I : in  STD_LOGIC;
        CYC_I : in  STD_LOGIC;
        DAT_I : in  STD_LOGIC_VECTOR(%BusWidth%);
        DAT_O : out STD_LOGIC_VECTOR(%BusWidth%); -- ExcludeIfPortKindOutput
        PAI   : in  STD_LOGIC_VECTOR(%BusWidth%); -- ExcludeIfPortKindOutput
        PAO   : out STD_LOGIC_VECTOR(%BusWidth%);
        TRISA : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortKindTristate
        PBI   : in  STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount2 IncludeIfPortCount4 ExcludeIfPortKindOutput
        PBO   : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount2 IncludeIfPortCount4
        TRISB : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount2 IncludeIfPortCount4 IncludeIfPortKindTristate
        PCI   : in  STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4                     ExcludeIfPortKindOutput
        PCO   : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4
        TRISC : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4                     IncludeIfPortKindTristate
        PDI   : in  STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4                     ExcludeIfPortKindOutput
        PDO   : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4
        TRISD : out STD_LOGIC_VECTOR(%BusWidth%); -- IncludeIfPortCount4                     IncludeIfPortKindTristate
        RST_I : in  STD_LOGIC;
        STB_I : in  STD_LOGIC;
        WE_I  : in  STD_LOGIC
      );
   End Component;

Begin
   SubPart_Port : %ChildModel%
   Port Map
   (
        ACK_O => ACK_O,
        ADR_I => ADR_I,     -- IncludeIfAdrPortCount2 IncludeIfAdrPortCount4 IncludeIfAdrPortCount8
        CLK_I => CLK_I,
        CYC_I => CYC_I,
        DAT_I => DAT_I,
        DAT_O => DAT_O,     --                                         ExcludeIfPortKindOutput
        PAI   => PAI,       --                                         ExcludeIfPortKindOutput
        PAO   => PAO,
        TRISA => TRISA,     --                                         IncludeIfPortKindTristate
        PBI   => PBI,       -- IncludeIfPortCount2 IncludeIfPortCount4 ExcludeIfPortKindOutput
        PBO   => PBO,       -- IncludeIfPortCount2 IncludeIfPortCount4
        TRISB => TRISB,     -- IncludeIfPortCount2 IncludeIfPortCount4 IncludeIfPortKindTristate
        PCI   => PCI,       -- IncludeIfPortCount4                     ExcludeIfPortKindOutput
        PCO   => PCO,       -- IncludeIfPortCount4
        TRISC => TRISC,     -- IncludeIfPortCount4                     IncludeIfPortKindTristate
        PDI   => PDI,       -- IncludeIfPortCount4                     ExcludeIfPortKindOutput
        PDO   => PDO,       -- IncludeIfPortCount4
        TRISD => TRISD,     -- IncludeIfPortCount4                     IncludeIfPortKindTristate
        RST_I => RST_I,
        STB_I => STB_I,
        WE_I  => WE_I
   );

End RTL;
