#Copyright (C)1991-2002 Altera Corporation
#Any megafunction design, and related net list (encrypted or decrypted),
#support information, device programming or simulation file, and any other
#associated documentation or information provided by Altera or a partner
#under Altera's Megafunction Partnership Program may be used only to
#program PLD devices (but not masked PLD devices) from Altera.  Any other
#use of such megafunction design, net list, support information, device
#programming or simulation file, or any other related documentation or
#information is prohibited for any other purpose, including, but not
#limited to modification, reverse engineering, de-compiling, or use with
#any other silicon devices, unless such use is explicitly licensed under
#a separate agreement with Altera or a megafunction partner.  Title to
#the intellectual property, including patents, copyrights, trademarks,
#trade secrets, or maskworks, embodied in any such megafunction design,
#net list, support information, device programming or simulation file, or
#any other related documentation or information provided by Altera or a
#megafunction partner, remains with Altera, the megafunction partner, or
#their respective licensors.  No other licenses, including any licenses
#needed under any third party's intellectual property, are provided herein.
#Copying or modifying any file, or portion thereof, to which this notice
#is attached violates this copyright.
#ALTIUM_NIOS2_VER_60

no strict;    # {~<% that strict $#!+.
use europa_all;

#----------------------------------------------------------------------------
# Copyright (C) 1999-2002 First Silicon Solutions, Inc.  All rights reserved.
#----------------------------------------------------------------------------

sub make_nios2_oci_jtag
{
  my ($Opt, $project) = (@_);

  my $jtag_module_name =  $Opt->{name}."_jtag_debug_module";
  my $jtag_file_name = $jtag_module_name;

  my $module = e_module->new ({
      name    => $jtag_module_name,
      project => $project,
      output_file => $jtag_file_name,
  });

                         #-------------------#
                         #                   #
                         #  LOCAL VARIABLES  #
                         #                   #
                         #-------------------#
  # JTAG TAP controller states.  Note that I don't use these anymore, but
  # the list is useful for reference.
  my $ST_RESET     = "4'h0";
  my $ST_IDLE      = "4'h1";
  my $ST_SELECTDR  = "4'h2";
  my $ST_SELECTIR  = "4'h3";
  my $ST_CAPTUREDR = "4'h4";
  my $ST_SHIFTDR   = "4'h5";
  my $ST_EXIT1DR   = "4'h6";
  my $ST_PAUSEDR   = "4'h7";
  my $ST_EXIT2DR   = "4'h8";
  my $ST_UPDATEDR  = "4'h9";
  my $ST_CAPTUREIR = "4'hA";
  my $ST_SHIFTIR   = "4'hB";
  my $ST_EXIT1IR   = "4'hC";
  my $ST_PAUSEIR   = "4'hD";
  my $ST_EXIT2IR   = "4'hE";
  my $ST_UPDATEIR  = "4'hF";


  # declaring signals ahead of time saves me exporting headaches
  $module->add_contents (
    # outputs
    e_signal->news (
      ["jrst_n",    1,    1],
      # we no longer need to export the following signals; now we export
      #   action strobes associated with the registers.
      #["jxir",      1,    1],    # no longer needed?
      #["jxdr",      1,    1],   
      ["jdo",       $SR_WIDTH,    1],
    ),
    # inputs
    e_signal->news (
      ["MonDReg",       32,   0],
      ["tracemem_trcdata",   $Opt->{oci_tm_width},         0,], 
    ),
    # all other inputs are 1 bit wide, and should resolve themselves.

    # special hub node signals
    e_port->news (
      ["raw_tck",       1,    "in"],
      ["tdi",           1,    "in"],
      ["rti",           1,    "in"],
      ["shift",         1,    "in"],
      ["update",        1,    "in"],
      ["usr1",          1,    "in"],
      ["clrn",          1,    "in"],
      ["ena",           1,    "in"],
      ["tdo",           1,    "out"],
      ["irq",           1,    "out"],
      ["ir_in",         $IR_WIDTH,    "in"],
      ["ir_out",        $IR_WIDTH,    "out"],
	["jtag_state_udr", 1,   "in"]
    ),
  );

  $module->add_contents (
    # local, unexported variables
    e_signal->news (
      ["dummy_sink",            1,    0,  1],
      ["sr",            $SR_WIDTH,    0,  1],
      ["DRsize",                3,    0,  1],
    ),
  );

  ## Format of SLD_Node_Info is :
  # +-----------+---------+-------------+---------------+
  # | 31     27 | 26   19 | 18        8 | 7           0 |
  # +-----------+---------+-------------+---------------+
  # | Node Ver  | Node ID | Node Mfg_ID | Node Inst ID  |
  # +-----------+---------+-------------+---------------+
  unless ($Opt->{altium_jtag}) {
      # unless altium_debug is "1", define SLD_NODE_INFO, so quartus will 
      # plumb us up the SLD Hub
      my $instance_id = 
        $project->assign_available_SLD_Node_Instance_Id ("jtag_debug_module");
      my $base_id =
        $project->module_ptf->{"SLAVE jtag_debug_module"}->
              {SYSTEM_BUILDER_INFO}->{JTAG_Hub_Base_Id};
      $module->add_contents (
        e_parameter->new (
          [SLD_NODE_INFO, (($base_id << 8) + $instance_id), "INTEGER"],
        ),
      );
  }

                         #-------------------#
                         #                   #
                         #  EXECUTABLE CODE  #
                         #                   #
                         #-------------------#

  my @europa_objects = (

    ##############
    #            #
    # CLK domain #
    #            #
    ##############

    # synchronize updateir state to clk domain.
    #e_process->new ({
    #  clock     => "clk",
    #  contents  => [
    #    e_assign->news (
    #      ["ir_update1"  => "st_updateir"], 
    #      ["ir_update2"  => "ir_update1"],
    #      ["jxir" => "~ir_update1 & ir_update2"], 
    #        # pulse when update-IR state reached
    #    ),
    #  ],
    #}),

    # synchronize updatedr state to clk domain.
    e_process->new ({
      clock     => "clk",
      contents  => [
        e_assign->news (
          ["dr_update1"  => "st_updatedr"], 
          ["dr_update2"  => "dr_update1"],
          ["jxdr" => "~dr_update1 & dr_update2"], 
            # pulse when update-DR state reached
        ),
      ],
    }),

    # now we've got a nice update strobe for the clock domain.
    # translate this into directions into actions.
    e_assign->news (
      ["take_action_ocimem_a" => 
          "jxdr && (ir == $IRC_OCIMEM) && 
            ~jdo[$OCIMEM_A_OR_B_POS] && jdo[$OCIMEM_A_ACT_POS]"],
      ["take_no_action_ocimem_a" => 
          "jxdr && (ir == $IRC_OCIMEM) && 
            ~jdo[$OCIMEM_A_OR_B_POS] && ~jdo[$OCIMEM_A_ACT_POS]"],
      ["take_action_ocimem_b" => 
          "jxdr && (ir == $IRC_OCIMEM) && 
              jdo[$OCIMEM_A_OR_B_POS]"],

      ["take_action_tracemem_a" => 
          "jxdr && (ir == $IRC_TRACEMEM) &&
            ~jdo[$TRACEMEM_A_OR_B_POS] && 
            jdo[$TRACEMEM_A_ACT_POS] "], 
      ["take_no_action_tracemem_a" => 
          "jxdr && (ir == $IRC_TRACEMEM) &&
            ~jdo[$TRACEMEM_A_OR_B_POS] && 
            ~jdo[$TRACEMEM_A_ACT_POS] "], 
      ["take_action_tracemem_b" => 
          "jxdr && (ir == $IRC_TRACEMEM) &&
            jdo[$TRACEMEM_A_OR_B_POS] "], 

      ["take_action_break_a" => 
          "jxdr && (ir == $IRC_BREAK) && 
            ~jdo[$BREAK_A_OR_B_C_POS] && 
            jdo[$BREAK_W_POS]"],
      ["take_no_action_break_a" =>           # nothing depends on this?
          "jxdr && (ir == $IRC_BREAK) && 
            ~jdo[$BREAK_A_OR_B_C_POS] && 
            ~jdo[$BREAK_W_POS]"],
      ["take_action_break_b" => 
          "jxdr && (ir == $IRC_BREAK) && 
            jdo[$BREAK_A_OR_B_C_POS] && ~jdo[$BREAK_B_OR_C_POS] &&
            jdo[$BREAK_W_POS]"],
      ["take_no_action_break_b" => 
          "jxdr && (ir == $IRC_BREAK) && 
            jdo[$BREAK_A_OR_B_C_POS] && ~jdo[$BREAK_B_OR_C_POS] &&
            ~jdo[$BREAK_W_POS]"],
      ["take_action_break_c" => 
          "jxdr && (ir == $IRC_BREAK) && 
            jdo[$BREAK_A_OR_B_C_POS] &&  jdo[$BREAK_B_OR_C_POS] &&
            jdo[$BREAK_W_POS]"],
      ["take_no_action_break_c" => 
          "jxdr && (ir == $IRC_BREAK) && 
            jdo[$BREAK_A_OR_B_C_POS] &&  jdo[$BREAK_B_OR_C_POS] &&
            ~jdo[$BREAK_W_POS]"],

      ["take_action_tracectrl" => 
          "jxdr && (ir == $IRC_TRACECTRL) &&  
            jdo[$TRACECTRL_ACT_POS]"], 
      #["take_no_action_tracectrl" => 
      #    "jxdr && (ir == $IRC_TRACECTRL) &&  
      #      ~jdo[$TRACECTRL_ACT_POS "], 
    ),



    ##############
    #            #
    # TCK domain #
    #            #
    ##############
    # these two wire assignments are for switch statements inside the process
    #e_assign->new ([["ir_7_to_5", 3], "ir[7:5]"]),
    #e_assign->new ([["ir_in_7_to_5", 3], "ir_in[7:5]"]),

    # ir_out is just a register. it gets updated every tck. 
    # technically, we should update it only during the UPDATEIR stage... but
    # what the heck...
    e_process->new ({
      clock     => "raw_tck",
      reset     => "jrst_n",
      asynchronous_contents => [
        e_assign->news (
          ["ir_out"     => "$IR_WIDTH\'b0"],
        ),
      ],
      contents  => [
        e_assign->new (
          #ph: come up with legit returned value for IR
          ["ir_out"   =>  "{debugack, monitor_ready}"],
        ),
      ],
    }),

    # the Great State process. 
    e_process->new ({
      clock     => "raw_tck",
      reset     => "jrst_n",
      asynchronous_contents => [
        e_assign->news (
          ["sr"         => 0],
          ["DRsize"     => "$SZ_1"],
        ),
      ],
      contents  => [

#STATE => ST_UPDATEIR 
        e_if->new ({ 
          condition => "(st_updateir)",   # ST_UPDATEIR
          then    => [
            e_case->new ({
              switch    => "ir_in",
              parallel  => 0,
              full      => 0,
              contents  => {
                $IRC_OCIMEM     => ["DRsize" => "$SZ_OCIMEM"],
                $IRC_TRACEMEM   => ["DRsize" => "$SZ_TRACEMEM"],
                $IRC_BREAK      => ["DRsize" => "$SZ_BREAK"],
                $IRC_TRACECTRL  => ["DRsize" => "$SZ_TRACECTRL"],

                #$IRC_JTAG =>    ["DRsize" => "$SZ_8"],
                #$IRC_ADDR =>    ["DRsize" => "$SZ_16"],
                #$IRC_DATA =>    ["DRsize" => "$SZ_16"],
                #$IRC_CTRL =>    ["DRsize" => "$SZ_16"],
                #$IRC_TRCADDR => ["DRsize" => "$SZ_16"],
                #$IRC_BRK =>     ["DRsize" => "$SZ_32"],
                #$IRC_TRCDATA => ["DRsize" => "$SZ_36"],
                #$IRC_BYPASS =>  ["DRsize" => "$SZ_1"],
              },
            }),
            # also, update sr with the new ir 
            # ir is also captured here.  
            # you may ask: why isn't ir captured like jdo, on the update clock?
            # well, we must wait for ir_in to change.  if we capture ir on the
            # update clock, we get the old value of ir_in, and not the new
            # value. 
            #e_assign->new (["sr[7:0]",   "ir_in[7:0]"]),   
            e_assign->new (["ir" , "ir_in"]),
            ],

# STATE => ST_CAPTUREDR 
          elsif => {
            condition => "(~shift & ~usr1 & ena & ".
                         "~in_between_shiftdr_and_updatedr)",   # ST_CAPTUREDR 
            then    => [
              e_case->new ({
                switch => "ir",
                parallel  => 0,
                full      => 0,
                contents  => {
                  $IRC_OCIMEM   => [
                    ["sr[$OCIMEM_DA_POS]" => "debugack"],
                    ["sr[$OCIMEM_ER_POS]" => "monitor_error"],
                    ["sr[$OCIMEM_RST_POS]" => "resetlatch"],
                    ["sr[$OCIMEM_RDDATA_MSB_POS:$OCIMEM_RDDATA_LSB_POS]" 
                        => "MonDReg"],
                    ["sr[$OCIMEM_MR_POS]" => "monitor_ready"],
                  ],
                  $IRC_TRACEMEM => [
                    ["sr[$TRACEMEM_RDDATA_MSB_POS:$TRACEMEM_RDDATA_LSB_POS]" 
                        => "tracemem_trcdata"],
                    ["sr[$TRACEMEM_TW_POS]" => "tracemem_tw"],
                    ["sr[$TRACEMEM_ON_POS]" => "tracemem_on"],
                  ],
                  $IRC_BREAK    => [
                    ["sr[$BREAK_TS_POS]" => "trigger_state_1"], 
                    ["sr[$BREAK_W3_POS]" => "dbrk_hit3_latch"],
                    ["sr[$BREAK_W2_POS]" => "dbrk_hit2_latch"],
                    ["sr[$BREAK_W1_POS]" => "dbrk_hit1_latch"],
                    ["sr[$BREAK_W0_POS]" => "dbrk_hit0_latch"],
                    ["sr[$BREAK_RDDATA_MSB_POS:$BREAK_RDDATA_LSB_POS]" 
                        => "break_readreg"],
                    ["sr[$BREAK_TB_POS]" => "trigbrktype"],
                  ],
                  $IRC_TRACECTRL  => [
                    ["sr[$TRACECTRL_RESERVED_BITS]" => "1'b0"], # reserved=0.
                    ["sr[$TRACECTRL_TRCACQADDR_BITS]" => "trc_im_addr"], 
                    ["sr[$TRACECTRL_TW_POS]" => "trc_wrap"], 
                    ["sr[$TRACECTRL_ON_POS]" => "trc_on"], 
                  ],
                },
              }), # end of case
            ],  # end of elsif->then
            elsif => {

# STATE => ST_SHIFTDR 
# The only hub responsibility here is to provide a TDI->TDO path.
              condition => "(shift & ~usr1 & ena)",   # ST_SHIFTDR
              then    => [
                e_case->new ({
                  switch => "DRsize",
                  parallel  => 0,
                  full      => 0,
                  contents => {
                    $SZ_1 =>  ["sr" => "{tdi, sr[$SR_MSB: 2], tdi}"],
                    $SZ_8 =>  ["sr" => "{tdi, sr[$SR_MSB: 9], tdi, sr[ 7:1]}"],
                    $SZ_16 => ["sr" => "{tdi, sr[$SR_MSB:17], tdi, sr[15:1]}"],
                    $SZ_32 => ["sr" => "{tdi, sr[$SR_MSB:33], tdi, sr[31:1]}"],
                    $SZ_36 => ["sr" => "{tdi, sr[37],         tdi, sr[35:1]}"],
                    $SZ_38 => ["sr" => "{tdi, sr[$SR_MSB: 1]}"],
                    default =>["sr" => "{tdi, sr[$SR_MSB: 2], tdi}"],
                  },
                }),
              ],  # end of then
            },  # end of elsif
          },  # end of elsif
        }),  # end of e_if
      ], # end of e_process contents
    }), # end of e_process

    # tdo used to be in e_process below, but now it's just sr[0].
    e_assign->new (["tdo" => "sr[0]"]),

    # export the rti state.
    # this simplistically assumes that rti will be true for more than one clk.
    e_assign->new (["st_ready_test_idle" => "rti"]),

    # jdo is a register on the special "update" clock domain.
    e_process->new ({
      clock       => "update",
      clock_level => 1, # rising tck (posedge) (normal)
      contents  => [
        e_if->new ({ 
          condition => "(~usr1 & ena & jtag_state_udr)",   # ST_UPDATEDR
          then    => [
            e_assign->new (["jdo"    => "sr"]),
          ],
        }),
      ],  # end of contents
    }),

    # keep track of states involving the "update" strobe.
    e_process->new ({
      clock     => "raw_tck",
      clock_level => 1, # rising tck (posedge) (normal)
      reset     => "update",
      reset_level => 1, # rising update (posedge)
      asynchronous_contents => [
        e_assign->new (
          ["st_shiftdr"   => "1'b0"],  # an update means we're not in shift
        ),
        e_if->new ({ 
          condition => "(usr1 & ena)",   # ST_UPDATEIR
          then    => [
            ["st_updateir" => "1'b1"],
            ["st_updatedr"  => "1'b0"],
          ],
          elsif => {
            condition => "(~usr1 & ena)",   # ST_UPDATEDR
            then      => [
              ["st_updateir"  => "1'b0"],
              ["st_updatedr"  => "1'b1"],
            ],
            else      => [      # this should prevent combinatorial loop
              ["st_updateir"  => "1'b0"],
              ["st_updatedr"  => "1'b0"],
            ],
          }, # end of elsif
        }),
      ],
      contents  => [
        e_if->new ({ 
          condition => "(shift & ~usr1 & ena)",   # ST_SHIFTDR
          then    => [
            ["st_updateir"  => "1'b0"],
            ["st_updatedr"  => "1'b0"],
            ["st_shiftdr"   => "1'b1"],
          ],
          else => [     # if nothing else is happening, all goes back to 0.
            ["st_updateir"  => "1'b0"],
            ["st_updatedr"  => "1'b0"],
            ["st_shiftdr"   => "1'b0"],
          ],
        }), # end of e_if
      ], # end of e_process contents
    }), # end of e_process


    e_process->new ({
      clock     => "raw_tck",
      clock_level => 1, # rising tck (posedge) (normal)
      reset     => "jrst_n",
      asynchronous_contents => [
        e_assign->new (
          ["in_between_shiftdr_and_updatedr" => "1'b0"],
        ),
      ],
      contents  => [
        e_if->new ({ 
          condition => "(st_shiftdr)",   # ST_SHIFTDR
          then    => [
            ["in_between_shiftdr_and_updatedr" => "1'b1"],
          ],
          elsif => {
            condition => "(st_updatedr)",   # ST_UPDATEDR
            then      => [
              ["in_between_shiftdr_and_updatedr" => "1'b0"],
            ],
          }, # end of elsif
        }), # end of e_if
      ],  # end of contents
    }),
  );

  push(@europa_objects,
    # jrst_n is assigned twice.  once for simulation (to reset all the JTAG
    # registers to a nice assigned (non-X) state), once for synthesis.
    e_assign->new ({
      lhs => "jrst_n",
      rhs => "clrn",      # for synthesis, use jtag clrn
      tag => "synthesis",
    }),
    e_assign->new ({
      lhs => "jrst_n",
      rhs => "reset_n",   # for simulation, just use normal ol' reset.
      tag => "simulation",
    }),
  );

  $module->add_contents (@europa_objects);

  return $module;
}


1;



