#Copyright (C)1991-2002 Altera Corporation
#Any megafunction design, and related net list (encrypted or decrypted),
#support information, device programming or simulation file, and any other
#associated documentation or information provided by Altera or a partner
#under Altera's Megafunction Partnership Program may be used only to
#program PLD devices (but not masked PLD devices) from Altera.  Any other
#use of such megafunction design, net list, support information, device
#programming or simulation file, or any other related documentation or
#information is prohibited for any other purpose, including, but not
#limited to modification, reverse engineering, de-compiling, or use with
#any other silicon devices, unless such use is explicitly licensed under
#a separate agreement with Altera or a megafunction partner.  Title to
#the intellectual property, including patents, copyrights, trademarks,
#trade secrets, or maskworks, embodied in any such megafunction design,
#net list, support information, device programming or simulation file, or
#any other related documentation or information provided by Altera or a
#megafunction partner, remains with Altera, the megafunction partner, or
#their respective licensors.  No other licenses, including any licenses
#needed under any third party's intellectual property, are provided herein.
#Copying or modifying any file, or portion thereof, to which this notice
#is attached violates this copyright.
#ALTIUM_NIOS2_VER_60
package nios2_oci;
use Exporter;
@ISA = Exporter;
@EXPORT = qw(
    &make_nios2_oci
);

use isa;
no strict;    # {~<% that strict $#!+.
use europa_all;
use nios2_oci_cfg;
use nios2_oci_jtag;
use nios2_oci_debug;
use nios2_oci_ocimem;
use nios2_oci_avalon_reg;
# hw breakpoints, triggers :
use nios2_oci_break;
use nios2_oci_xbrk;
use nios2_oci_dbrk;
# trace :
use nios2_oci_itrace;
use nios2_oci_dtrace;
use nios2_oci_fifo;
use nios2_oci_pib;
use nios2_oci_im;
# performance monitors :
use nios2_oci_performance_monitors;
use europa_utils;   # for validate_parameter

#----------------------------------------------------------------------------
# Copyright (C) 19debug99-2002 First Silicon Solutions, Inc.  All rights reserved.
#----------------------------------------------------------------------------

sub make_nios2_oci
{
  my ($Opt, $top_module) = @_;

  my $make_submodule = $Opt->{avalon_oci_in_submodule};
  $make_submodule = 1;
#  my $submodule = $make_submodule ? 
#    e_module->new({name => $Opt->{name}."_oci"}) : 0;
#  my $marker = $make_submodule ? e_default_module_marker->new($submodule) : 0;
  my $module = e_module->new({name => $Opt->{name}."_nios2_oci"}) ;
  my $marker = e_default_module_marker->new($module);
  my $sub_export = $make_submodule && $force_export;
  my $project = $top_module->project();
  my $project_WSA = $project->SYS_WSA();



  &validate_nios2_oci_parameters ($Opt, $project);
 
  my @submodules = (
#    &make_nios2_oci_jtag ($Opt, $project),  # it is always a submod. see below
    &make_nios2_oci_debug ($Opt, $project),
    &make_nios2_ocimem ($Opt, $project),
    &make_nios2_oci_avalon_reg ($Opt, $project),
    &make_nios2_oci_break ($Opt, $project),
    &make_nios2_oci_xbrk ($Opt, $project),
    &make_nios2_oci_dbrk ($Opt, $project),
    &make_nios2_oci_itrace ($Opt, $project),
    &make_nios2_oci_dtrace ($Opt, $project),
    &make_nios2_oci_fifo ($Opt, $project),
    &make_nios2_oci_pib ($Opt, $project),
    &make_nios2_oci_im ($Opt, $project),
    &make_nios2_oci_performance_monitors ($Opt, $project),
  );

  # First, instantiate submodules:
  if ($make_submodule) {
    foreach my $submod (@submodules) { 
      e_instance->add ({
        module  => $submod->name(),
      }); 
    }
  }

  my $system_clock_ps = int (1e12/($project->get_module_clock_frequency()) );
  my $double_clock_ns = ($system_clock_ps / 1e3) >> 1;

  # The JTAG module is instantiated slightly differently than the other
  # submodules, so that it may connect to the SLD hub.
  my $nios2_oci_jtag_module = &make_nios2_oci_jtag ($Opt, $project);

  my $export_jtag = $Opt->{altium_jtag};
  my $never_export_jtag = $export_jtag ^ 1;
  print "altium_jtag = " . $Opt->{altium_jtag} . "\n";
  if ($export_jtag) {
      print "Info: Exporting Altium JTAG interface\n";
  }


  my @nios2_oci_jtag_extra_contents = (
    # special instance of JTAG, so that we can connect it to the hub

    # define signals to never export, so that Q will suck them into the hub
    e_signal->news ( 
      ["tck",     1],
      ["raw_tck", 1],
      ["tdi",     1],
      ["rti",     1],
      ["shift",   1],
      ["update",  1],
      ["usr1",    1],
      ["clrn",    1],
      ["ena",     1],
      ["ir_in",   8],
      ["tdo",     1,  $export_jtag, $never_export_jtag],
      ["irq",     1,  $export_jtag, $never_export_jtag],
      ["ir_out",  8,  $export_jtag, $never_export_jtag],
      ["jtag_state_udr",  1,  $export_jtag,  $never_export_jtag],
     ),

    e_signal->news ( 
      ["resetrequest",     1,  1],
    ),

    e_assign->news (
      [["trigout", 1,],       "dbrk_trigout | xbrk_trigout"],
      [["readdata", 32,],  "address[8] ? oci_reg_readdata : oci_ram_readdata"],
      # note that this won't exists unless there's an OCI present
      [["jtag_debug_module_debugaccess_to_roms", 1, 1],  "debugack"],
    ),
  );

  # Note that one instance below is for synth, with open ports, and
  # that the other instance ties down some open ports, so that
  # simulation continues undisturbed and 'x' free...
  my $nios2_oci_jtag_syn_port_map = {};
  if ($export_jtag) {
      $nios2_oci_jtag_syn_port_map = {
        "tck",     "tck",
        "raw_tck", "raw_tck",
        "tdi",     "tdi",
        "rti",     "rti",
        "shift",   "shift",
        "update",  "update",
        "usr1",    "usr1",
        "clrn",    "clrn",
        "ena",     "ena",
        "ir_in",   "ir_in",
        "tdo",     "tdo",
        "irq",     "irq",
        "ir_out",  "ir_out",
      "jtag_state_udr", "jtag_state_udr"
      };
  } else {
      $nios2_oci_jtag_syn_port_map = {
        "tck",     "open",
        "raw_tck", "open",
        "tdi",     "open",
        "rti",     "open",
        "shift",   "open",
        "update",  "open",
        "usr1",    "open",
        "clrn",    "open",
        "ena",     "open",
        "ir_in",   "open",
        "tdo",     "open",
        "irq",     "open",
        "ir_out",  "open",
      "jtag_state_udr", "open"
      };
  }

  my $nios2_oci_jtag_sim_port_map = {
    "tck",     "1'b0",
    "raw_tck", "1'b0",
    "tdi",     "1'b0",
    "rti",     "1'b0",
    "shift",   "1'b0",
    "update",  "1'b0",
    "usr1",    "1'b0",
    "clrn",    "reset_n",
    "ena",     "1'b0",
    "ir_in",   "2'b0",
    "tdo",     "open",
    "irq",     "open",
    "ir_out",  "open",
    "jtag_state_udr", "1'b0"
  };

  my $jtag_wrapper_module_name = $Opt->{name}."_jtag_debug_module_wrapper";
  my $jtag_wrapper_file_name = $jtag_wrapper_module_name;

  my $jtag_wrapper_module = e_module->new ({
    name  => $jtag_wrapper_module_name,
    output_file => $jtag_wrapper_file_name,
  });
  push(@nios2_oci_jtag_extra_contents,
    e_instance->new ({
      module  => $jtag_wrapper_module,
      tag => "normal",
    }),
  );

  $jtag_wrapper_module->add_contents (
      e_instance->new ({
        module  => $nios2_oci_jtag_module,
        tag => "synthesis",
        port_map  => $nios2_oci_jtag_syn_port_map,
        suppress_open_ports => 1,
      }),

      e_instance->new ({
        module  => $nios2_oci_jtag_module,
        tag => "simulation",
        port_map  => $nios2_oci_jtag_sim_port_map,
        suppress_open_ports => 1,
      }),
  );

  $module->add_contents (@nios2_oci_jtag_extra_contents);

  # offchip trace signals
  if ($Opt->{oci_offchip_trace}) {
    # export these signals out of the OCI module
    $module->add_contents (
      e_signal->news (
        ["tr_clk",                1,                        1],
        ["tr_data",               $Opt->{oci_tr_width},     1],
        ["trigout",               1,                        1],
      ),
    );
    # in the Nios module, tie these to 0s for simulation purposes.
    # (Why are these even here? I need to p4-blame them)
    e_assign->adds (
      { lhs => "tr_clk",  
        rhs => 0, 
        tag => "simulation",
      },
      { lhs => "tr_data", 
        rhs => 0, 
        tag => "simulation",
      },
      { lhs => "trigout", 
        rhs => 0, 
        tag => "simulation",
      },
    );
  } else {  # if no offchip trace, don't let these signals percolate out
    $module->get_and_set_thing_by_name({
      thing => "mux",
      lhs   => ["dummy_sink", 1, 0, 1],
      name  => "dummy sink",
      type  => "and_or",
      add_table =>
        [   "tr_clk",   "tr_clk",
            "tr_data",  "tr_data",
            "trigout",  "trigout",
        ],
    });
  }

  # debugreq signals. 
  if ($Opt->{oci_debugreq_signals}) {
    # export these signals
    $module->add_contents (
      e_signal->news (
        ["debugack",              1,                        1],
      ),
    );
  } else {  # if debugreq signals, don't let these signals percolate out
    $module->get_and_set_thing_by_name({
      thing => "mux",
      lhs   => ["dummy_sink", 1, 0, 1],
      name  => "dummy sink",
      type  => "and_or",
      add_table => ["debugack", "debugack",]
    });
    $module->add_contents (
      e_assign->news (
        [["debugreq",  1,], 0],
      ),
    );
  }

  # deal with clkx2.  only needed for offchip trace.
  if ($Opt->{oci_offchip_trace}) 
  {
    my $pll_module_name =  $Opt->{name}."_ext_trace_pll_module";
    my $pll_file_name = $pll_module_name;
    my $pll_module = e_module->new ({
        name    => $pll_module_name,
        project => $project,
        output_file => $pll_file_name,
    });
    if ($Opt->{oci_embedded_pll}) {
      # add our own PLL
      $pll_module->add_contents (
        e_instance->new ({
          name    => $Opt->{name}."_nios2_oci_altclklock",
          tag     => "synthesis",
          module  => e_module->new ({
            name    => "altclklock",
            _hdl_generated  => 1,
            contents  => [
              e_port->news (
                ["inclock",   1,  "in"],
                ["clock1",    1,  "out"],
              ),
              e_parameter->news (
                ["inclock_period",    $system_clock_ps   , "NATURAL"],          
                ["clock1_boost",      2,        , "NATURAL"],            
                [qw(operation_mode    NORMAL     STRING)],
                ["intended_device_family", $project->{device_family}, "STRING"],
                ["valid_lock_cycles",     1     , "NATURAL"],       
                ["invalid_lock_cycles",   5     , "NATURAL"],     
                ["valid_lock_multiplier", 1     , "NATURAL"],   
                ["invalid_lock_multiplier",5    , "NATURAL"], 
                ["clock1_divide",          1    , "NATURAL"],           
                ["outclock_phase_shift",   0    , "NATURAL"],    
                [qw(lpm_type          altclklock     STRING)],                
              ),
            ],
          }),
          port_map  => {
            inclock   => "clk",
            clock1    => "clkx2",
          },
          parameter_map => {
            inclock_period          => $system_clock_ps,
            clock1_boost            => 2,
            operation_mode          => "NORMAL",
            intended_device_family  => $project->{device_family},
            valid_lock_cycles       => 1,
            invalid_lock_cycles     => 5,
            valid_lock_multiplier   => 1,
            invalid_lock_multiplier => 5,
            clock1_divide           => 1,
            outclock_phase_shift    => 0,
            lpm_type                => "altclklock",
          },
        }),
        e_clk_gen->new  ({
          tag => "simulation",
          clk => "clkx2",
          ns_period => $double_clock_ns,
        }),
      );
      $module->add_contents (
        e_instance->new ({
          name    => "the_".$pll_module_name, 
          tag     => "synthesis",
          module  => $pll_module,
        }),
      );
    } else {
      # export clkx2 to the top.
      $module->add_contents (
        e_signal->news ( ["clkx2",  1,   0],),
      );
    }
  } else {  # no need for clock.
    # tie off clkx2 to 0.
    $module->add_contents (
      e_assign->news ( [["clkx2",  1,   0], 0]),
    );
  }
  
  # instantiate the Avalon slave and module instance in the top CPU module.
  $top_module->add_contents (
    e_instance->new ({
  #    verilog_override => 1,
  #    tag => 'compilation',
      module => $module,
      port_map  => {

        # OCI RAM Avalon slave interface
        address       => "jtag_debug_module_address",
        begintransfer => "jtag_debug_module_begintransfer",
        byteenable    => "jtag_debug_module_byteenable",
        clk           => "jtag_debug_module_clk",
        readdata      => "jtag_debug_module_readdata",
        reset         => "jtag_debug_module_reset",
        resetrequest  => "jtag_debug_module_resetrequest",
        chipselect    => "jtag_debug_module_select",
        write         => "jtag_debug_module_write",
        writedata     => "jtag_debug_module_writedata",
        debugaccess   => "jtag_debug_module_debugaccess",

  #      # raw JTAG interface ?
  #      tck           => "oci_tck",
  #      trst_n        => "oci_trst_n",
  #      tms           => "oci_tms",     
  #      tdi           => "oci_tdi",     
  #      tdo           => "oci_tdo",     
                
        # optional external trace/triggering signals
        debugreq      => "jtag_debug_debugreq",
        debugack      => "jtag_debug_debugack",
        trigout       => "jtag_debug_trigout",

        tr_clk        => "jtag_debug_offchip_trace_clk",  
        tr_data       => "jtag_debug_offchip_trace_data",  
      },
    }), 
    e_avalon_slave->new ({
      name  => "jtag_debug_module",
      type_map  => {
        jtag_debug_module_address       => "address",
        jtag_debug_module_begintransfer => "begintransfer",
        jtag_debug_module_byteenable    => "byteenable",
        jtag_debug_module_clk           => "clk",
        jtag_debug_module_readdata      => "readdata",
        jtag_debug_module_reset         => "reset",
        jtag_debug_module_resetrequest  => "resetrequest",
        jtag_debug_module_select        => "chipselect",
        jtag_debug_module_write         => "write",
        jtag_debug_module_writedata     => "writedata",
        jtag_debug_module_debugaccess   => "debugaccess",
      },
    }),
  );


#    # ph: temporary tie-offs to facilitate first milestone:
#  $module->add_contents (
#    e_assign->news (
#      ['tr_data',               0], 
#      ['tr_clk',                0], 
#    ),
#  );
#  # ph: temporary tie-offs to facilitate first milestone:
#  $module->get_and_set_thing_by_name({
#    thing => "mux",
#    lhs   => ["dummy_sink", 1, 0, 1],
#    name  => "dummy sink",
#    type  => "and_or",
#    add_table => [
#          "dbrk_traceme",       "dbrk_traceme",
#          "dbrk_traceoff",      "dbrk_traceoff",
#          "dbrk_traceon",       "dbrk_traceon",
#          "clkx2",              "clkx2",
#      ],
#  });

  return $module;
}



# TODO for validate_nios2_oci_parameters:
# fill out defaults for :
#   oci_fifo_addr_width
#
sub validate_nios2_oci_parameters 
{
  my ($Opt, $project) = (@_);

  &validate_parameter ({  # width of cpu inst addr bus
    hash    => $Opt,
    name    => "consistent_synthesis",
    type    => "boolean",
    default => 0,
  });
  &validate_parameter ({  # width of cpu inst addr bus
    hash    => $Opt,
    name    => "cpu_i_address_width",
    type    => "integer",
    default => $Opt->{consistent_synthesis} ? 20 : $Opt->{i_Address_Width},
  });
  &validate_parameter ({  # width of cpu inst data bus
    hash    => $Opt,
    name    => "cpu_i_data_width",
    type    => "integer",
    default => 32,
  });
  &validate_parameter ({  # width of cpu data addr bus
    hash    => $Opt,
    name    => "cpu_d_address_width",
    type    => "integer",
    default => $Opt->{d_Address_Width},
  });
  &validate_parameter ({  # width of cpu data data bus
    hash    => $Opt,
    name    => "cpu_d_data_width",
    type    => "integer",
    default => 32,
  });
  &validate_parameter ({  # number of xbrks
    hash    => $Opt,
    name    => "oci_num_xbrk",
    type    => "integer",
    default => 0,
  });
  &validate_parameter ({  # number of dbrks
    hash    => $Opt,
    name    => "oci_num_dbrk",
    type    => "integer",
    default => 0,
  });
  &validate_parameter ({  # do we support trigger states?
    hash    => $Opt,
    name    => "oci_trigger_arming",
    type    => "boolean",
    default => 0,
  });
  &validate_parameter ({  # can dbrks control trace collection?
    hash    => $Opt,
    name    => "oci_dbrk_trace",
    type    => "boolean",
    default => 0,
  });
  &validate_parameter ({  # can dbrks be combined into pairs?
    hash    => $Opt,
    name    => "oci_dbrk_pairs",
    type    => "boolean",
    default => 0,
  });
  &validate_parameter ({  # capability to do data trace?
    hash    => $Opt,
    name    => "oci_data_trace",
    type    => "boolean",
    default => 0,
  });
  &validate_parameter ({  # on-chip trace memory present
    hash    => $Opt,
    name    => "oci_onchip_trace",
    type    => "boolean",
    default => 0,
  });
  &validate_parameter ({  # off-chip trace port present
    hash    => $Opt,
    name    => "oci_offchip_trace",
    type    => "boolean",
    default => 0,
  });
  &validate_parameter ({  # 7 = 128 trace words
    hash    => $Opt,
    name    => "oci_trace_addr_width",
    type    => "integer",
    default => 7,
  });
  &validate_parameter ({  # extra external signals?
    hash    => $Opt,      # (usefill if off-chip trace port present)
    name    => "oci_debugreq_signals",
    type    => "integer",
    default => 0,
  });
  &validate_parameter ({  # 4 = 16 words oci trace fifo
    hash    => $Opt,
    name    => "oci_fifo_addr_width",
    type    => "integer",
    default => 4,
  });

  &validate_parameter ({  # width of trace message
    hash    => $Opt,
    name    => "oci_tm_width",
    type    => "integer",
    default => ($Opt->{cpu_d_data_width} + 4),
  });
  &validate_parameter ({  # off-chip trace port width
    hash    => $Opt,
    name    => "oci_tr_width",
    type    => "integer",
    default => ($Opt->{oci_tm_width} >> 1),
  });
  &validate_parameter ({  # does the OCI include an embedded call to a 2x PLL,
    hash    => $Opt,      #   or does the OCI export the 2x clock signal?
    name    => "oci_embedded_pll",
    type    => "boolean",
    default => 1,
  });
  &validate_parameter ({  # Number of Performance Monitors?
    hash    => $Opt,      # 0 == no performance monitor support.
    name    => "oci_num_pm",
    type    => "integer",
    default => 0,
  });
  &validate_parameter ({  # What is the width of the
    hash    => $Opt,      # Performance Monitors counters?
    name    => "oci_pm_width",
    type    => "integer",
    default => 40,
  });
}


1;

